dnl ######################################################################
dnl check the correct way to dereference the address part of the nfs fhandle
AC_DEFUN(AC_CHECK_NFS_FH_DREF,
[
AC_CACHE_CHECK(nfs file-handle address dereferencing style,
ac_cv_nfs_fh_dref_style,
[
# select the correct nfs address dereferencing style
case "${host_os}" in
	svr4* | solaris2* | sunos5* )
		ac_cv_nfs_fh_dref_style=svr4 ;;
	sunos4* )
		ac_cv_nfs_fh_dref_style=sunos4 ;;
	bsd44* | bsdi2* | freebsd* | netbsd* | openbsd* )
		ac_cv_nfs_fh_dref_style=bsd44 ;;
	hpux* )
		ac_cv_nfs_fh_dref_style=hpux ;;
	irix* )
		ac_cv_nfs_fh_dref_style=irix ;;
	linux* )
		ac_cv_nfs_fh_dref_style=linux ;;
	aix3* )
		ac_cv_nfs_fh_dref_style=aix3 ;;
	isc3 )
		ac_cv_nfs_fh_dref_style=isc3 ;;
	* )
		ac_cv_nfs_fh_dref_style=default ;;
esac
])
am_utils_nfs_fh_dref=$srcdir"/conf/fh_dref/fh_dref_"$ac_cv_nfs_fh_dref_style".h"
AC_SUBST_FILE(am_utils_nfs_fh_dref)
])
dnl ======================================================================
