dnl ######################################################################
dnl check the correct network transport type to use
AC_DEFUN(AC_CHECK_TRANSPORT_TYPE,
[
AC_CACHE_CHECK(network transport type,
ac_cv_transport_type,
[
# select the correct type
case "${host_os}" in
	solaris2* | svr4* | sunos5* )
		ac_cv_transport_type=tli ;;
	* )
		ac_cv_transport_type=sockets ;;
esac
])
am_utils_link_files_src=${am_utils_link_files_src}conf/transp/transp_${ac_cv_transport_type}.c" "
am_utils_link_files_dst=${am_utils_link_files_dst}lib/transputil.c" "
# append transport utilities object to LIBOBJS for automatic compilation
LIBOBJS="$LIBOBJS transputil.o"
if test $ac_cv_transport_type = tli
then
  AC_DEFINE(HAVE_TRANSPORT_TYPE_TLI)
fi
])
dnl ======================================================================
