dnl ######################################################################
dnl check the correct printf-style type for the mount type in the mount()
dnl system call.
AC_DEFUN(AC_CHECK_MTYPE_PRINTF_TYPE,
[
AC_CACHE_CHECK(printf string to print type field of mount() call,
ac_cv_mtype_printf_type,
[
# select the correct printf type
case "${host_os}" in
	linux | mach* | bsdi1* | 386bsd* | irix5* | irix6* | \
	news4 |	riscos | solaris2* | sunos5* | svr4* | sunos4* | xinu43 )
		ac_cv_mtype_printf_type="%s" ;;
	irix3 | isc3 )
		ac_cv_mtype_printf_type="0x%x" ;;
	* )
		ac_cv_mtype_printf_type="%d" ;;
esac
])
AC_DEFINE_UNQUOTED(MTYPE_PRINTF_TYPE, "$ac_cv_mtype_printf_type")
])
dnl ======================================================================
