/*
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      %W% (Berkeley) %G%
 *
 * $Id: amd.h,v 1.1 1996/01/13 23:23:39 ezk Exp ezk $
 *
 */

#ifndef _AMD_H
#define _AMD_H

/*
 * external definitions for building amd
 */

/* amd global functions */
extern amq_mount_info_list *amqproc_getmntfs_1(voidp argp, struct svc_req *rqstp);
extern amq_mount_stats *amqproc_stats_1(voidp argp, struct svc_req *rqstp);
extern amq_mount_tree_list *amqproc_export_1(voidp argp, struct svc_req *rqstp);
extern amq_mount_tree_p *amqproc_mnttree_1(voidp argp, struct svc_req *rqstp);
extern amq_string *amqproc_getvers_1(voidp argp, struct svc_req *rqstp);
extern entry *make_entry_chain(am_node *mp, entry *current_chain);
extern fserver *find_nfs_srvr(mntfs *mf);
extern int *amqproc_mount_1(voidp argp, struct svc_req *rqstp);
extern int *amqproc_setopt_1(voidp argp, struct svc_req *rqstp);
extern int mount_nfs_fh(struct fhstatus *fhp, char *dir, char *fs_name, char *opts, mntfs *mf);
extern nfs_fh *root_fh(char *dir);
extern void flush_srvr_nfs_cache(void);
extern void mf_mounted(mntfs *mf);
extern void quick_reply(am_node *mp, int error);
extern voidp amqproc_null_1(voidp argp, struct svc_req *rqstp);
extern voidp amqproc_umnt_1(voidp argp, struct svc_req *rqstp);

/* amd global variables */
extern am_ops cdfs_ops;
extern am_ops lofs_ops;
extern am_ops nfs_ops;
extern am_ops pcfs_ops;
extern am_ops ufs_ops;
extern int NumChild;
extern int fwd_sock;
extern int select_intr_valid;
extern jmp_buf select_intr;
extern qelem mfhead;

#ifdef HAVE_SIGACTION
extern sigset_t masked_sigs;
#endif /* HAVE_SIGACTION */

#if defined(HAVE_AM_FS_SFS) || defined(HAVE_AM_FS_SFSX)
extern char * sfs_match(am_opts *fo);
extern int sfs_fumount(mntfs *mf);
#endif /* defined(HAVE_AM_FS_SFS) || defined(HAVE_AM_FS_SFSX) */

#endif /* not _AMD_H */
