
TELNETD(8)               UNIX System Manager's Manual               TELNETD(8)

NNAAMMEE
     tteellnneettdd - DARPA TELNET protocol server

SSYYNNOOPPSSIISS
     //uussrr//lliibbeexxeecc//tteellnneettdd [--BBUUhhllkknnss] [--DD _d_e_b_u_g_m_o_d_e] [--II_i_n_i_t_i_d] [--SS _t_o_s] [--XX
                          _a_u_t_h_t_y_p_e] [--aa _a_u_t_h_m_o_d_e] [--eeddeebbuugg] [--rr_l_o_w_p_t_y_-_h_i_g_h_p_t_y]
                          [--uu _l_e_n] [--ddeebbuugg [_p_o_r_t]]

DDEESSCCRRIIPPTTIIOONN
     The tteellnneettdd command is a server which supports the DARPA standard TELNET
     virtual terminal protocol.  TTeellnneettdd is normally invoked by the internet
     server (see inetd(8))  for requests to connect to the TELNET port as in-
     dicated by the _/_e_t_c_/_s_e_r_v_i_c_e_s file (see services(5)).  The --ddeebbuugg option
     may be used to start up tteellnneettdd manually, instead of through inetd(8).
     If started up this way, _p_o_r_t may be specified to run tteellnneettdd on an alter-
     nate TCP port number.

     The tteellnneettdd command accepts the following options:

     --aa _a_u_t_h_m_o_d_e  This option may be used for specifying what mode should be
                  used for authentication.  Note that this option is only use-
                  ful if tteellnneettdd has been compiled with support for the
                  AUTHENTICATION option.  There are several valid values for
                  _a_u_t_h_m_o_d_e_:

                  debug  Turns on authentication debugging code.

                  user   Only allow connections when the remote user can pro-
                         vide valid authentication information to identify the
                         remote user, and is allowed access to the specified
                         account without providing a password.

                  valid  Only allow connections when the remote user can pro-
                         vide valid authentication information to identify the
                         remote user.  The login(1) command will provide any
                         additional user verification needed if the remote us-
                         er is not allowed automatic access to the specified
                         account.

                  other  Only allow connections that supply some authentica-
                         tion information.  This option is currently not sup-
                         ported by any of the existing authentication mecha-
                         nisms, and is thus the same as specifying --aa vvaalliidd.

                  none   This is the default state.  Authentication informa-
                         tion is not required.  If no or insufficient authen-
                         tication information is provided, then the login(1)
                         program will provide the necessary user verification.

                  off    This disables the authentication code.  All user ver-
                         ification will happen through the login(1) program.

     --BB           Specifies bftp server mode.  In this mode, tteellnneettdd causes
                  login to start a bftp(1) session rather than the user's nor-
                  mal shell.  In bftp daemon mode normal logins are not sup-
                  ported, and it must be used on a port other than the normal
                  TELNET port.

     --DD _d_e_b_u_g_m_o_d_e
                  This option may be used for debugging purposes.  This allows
                  tteellnneettdd to print out debugging information to the connec-
                  tion, allowing the user to see what tteellnneettdd is doing.  There

                  are several possible values for _d_e_b_u_g_m_o_d_e_:

                  ooppttiioonnss   Prints information about the negotiation of TELNET
                            options.

                  rreeppoorrtt    Prints the ooppttiioonnss information, plus some addi-
                            tional information about what processing is going
                            on.

                  nneettddaattaa   Displays the data stream received by tteellnneettdd..

                  ppttyyddaattaa   Displays data written to the pty.

                  eexxeerrcciissee  Has not been implemented yet.

     --ddeebbuugg       Enables debugging on each socket created by tteellnneettdd (see
                  SO_DEBUG in socket(2)).

     --eeddeebbuugg      If tteellnneettdd has been compiled with support for data encryp-
                  tion, then the --eeddeebbuugg option may be used to enable encryp-
                  tion debugging code.

     --hh           Disables the printing of host-specific information before
                  login has been completed.

     --II _i_n_i_t_i_d    This option is only applicable to UNICOS systems prior to
                  7.0.  It specifies the ID from _/_e_t_c_/_i_n_i_t_t_a_b to use when init
                  starts login sessions.  The default ID is fe.

     --kk           This option is only useful if tteellnneettdd has been compiled with
                  both linemode and kludge linemode support.  If the --kk option
                  is specified, then if the remote client does not support the
                  LINEMODE option, then tteellnneettdd will operate in character at a
                  time mode.  It will still support kludge linemode, but will
                  only go into kludge linemode if the remote client requests
                  it.  (This is done by by the client sending DONT SUPPRESS-
                  GO-AHEAD and DONT ECHO.) The --kk option is most useful when
                  there are remote clients that do not support kludge
                  linemode, but pass the heuristic (if they respond with WILL
                  TIMING-MARK in response to a DO TIMING-MARK) for kludge
                  linemode support.

     --ll           Specifies line mode.  Tries to force clients to use line-
                  at-a-time mode.  If the LINEMODE option is not supported, it
                  will go into kludge linemode.

     --nn           Disable TCP keep-alives.  Normally tteellnneettdd enables the TCP
                  keep-alive mechanism to probe connections that have been
                  idle for some period of time to determine if the client is
                  still there, so that idle connections from machines that
                  have crashed or can no longer be reached may be cleaned up.

     --rr _l_o_w_p_t_y_-_h_i_g_h_p_t_y
                  This option is only enabled when tteellnneettdd is compiled for
                  UNICOS. It specifies an inclusive range of pseudo-terminal
                  devices to use.  If the system has sysconf variable
                  _SC_CRAY_NPTY configured, the default pty search range is 0
                  to _SC_CRAY_NPTY; otherwise, the default range is 0 to 128.
                  Either _l_o_w_p_t_y or _h_i_g_h_p_t_y may be omitted to allow changing
                  either end of the search range.  If _l_o_w_p_t_y is omitted, the -
                  character is still required so that tteellnneettdd can differenti-
                  ate _h_i_g_h_p_t_y from _l_o_w_p_t_y.

     --ss           This option is only enabled if tteellnneettdd is compiled with sup-
                  port for SecurID cards.  It causes the --ss option to be
                  passed on to login(1),  and thus is only useful if login(1)
                  supports the --ss flag to indicate that only SecurID validated
                  logins are allowed, and is usually useful for controlling
                  remote logins from outside of a firewall.

     --SS _t_o_s

     --uu _l_e_n       This option is used to specify the size of the field in the
                  utmp structure that holds the remote host name.  If the re-
                  solved host name is longer than _l_e_n, the dotted decimal val-
                  ue will be used instead.  This allows hosts with very long
                  host names that overflow this field to still be uniquely
                  identified.  Specifying --uu00 indicates that only dotted deci-
                  mal addresses should be put into the _u_t_m_p file.

     --UU           This option causes tteellnneettdd to refuse connections from ad-
                  dresses that cannot be mapped back into a symbolic name via
                  the gethostbyaddr(3) routine.

     --XX _a_u_t_h_t_y_p_e  This option is only valid if tteellnneettdd has been built with
                  support for the authentication option.  It disables the use
                  of _a_u_t_h_t_y_p_e authentication, and can be used to temporarily
                  disable a specific authentication type without having to re-
                  compile tteellnneettdd.

     TTeellnneettdd operates by allocating a pseudo-terminal device (see pty(4))  for
     a client, then creating a login process which has the slave side of the
     pseudo-terminal as stdin, stdout and stderr. TTeellnneettdd manipulates the mas-
     ter side of the pseudo-terminal, implementing the TELNET protocol and
     passing characters between the remote client and the login process.

     When a TELNET session is started up, tteellnneettdd sends TELNET options to the
     client side indicating a willingness to do the following TELNET options,
     which are described in more detail below:

           DO AUTHENTICATION
           WILL ENCRYPT
           DO TERMINAL TYPE
           DO TSPEED
           DO XDISPLOC
           DO NEW-ENVIRON
           DO ENVIRON
           WILL SUPPRESS GO AHEAD
           DO ECHO
           DO LINEMODE
           DO NAWS
           WILL STATUS
           DO LFLOW
           DO TIMING-MARK

     The pseudo-terminal allocated to the client is configured to operate in
     cooked mode, and with XTABS and CRMOD enabled (see tty(4)).

     TTeellnneettdd has support for enabling locally the following TELNET options:

     WILL ECHO          When the LINEMODE option is enabled, a WILL ECHO or
                        WONT ECHO will be sent to the client to indicate the
                        current state of terminal echoing.  When terminal echo
                        is not desired, a WILL ECHO is sent to indicate that
                        telnetd will take care of echoing any data that needs
                        to be echoed to the terminal, and then nothing is
                        echoed.  When terminal echo is desired, a WONT ECHO is
                        sent to indicate that telnetd will not be doing any
                        terminal echoing, so the client should do any terminal


                        echoing that is needed.

     WILL BINARY        Indicates that the client is willing to send a 8 bits
                        of data, rather than the normal 7 bits of the Network
                        Virtual Terminal.

     WILL SGA           Indicates that it will not be sending IAC GA, go
                        ahead, commands.

     WILL STATUS        Indicates a willingness to send the client, upon re-
                        quest, of the current status of all TELNET options.

     WILL TIMING-MARK   Whenever a DO TIMING-MARK command is received, it is
                        always responded to with a WILL TIMING-MARK

     WILL LOGOUT        When a DO LOGOUT is received, a WILL LOGOUT is sent in
                        response, and the TELNET session is shut down.

     WILL ENCRYPT       Only sent if tteellnneettdd is compiled with support for data
                        encryption, and indicates a willingness to decrypt the
                        data stream.

     TTeellnneettdd has support for enabling remotely the following TELNET options:

     DO BINARY          Sent to indicate that telnetd is willing to receive an
                        8 bit data stream.

     DO LFLOW           Requests that the client handle flow control charac-
                        ters remotely.

     DO ECHO            This is not really supported, but is sent to identify
                        a 4.2BSD telnet(1) client, which will improperly re-
                        spond with WILL ECHO. If a WILL ECHO is received, a
                        DONT ECHO will be sent in response.

     DO TERMINAL-TYPE   Indicates a desire to be able to request the name of
                        the type of terminal that is attached to the client
                        side of the connection.

     DO SGA             Indicates that it does not need to receive IAC GA, the
                        go ahead command.

     DO NAWS            Requests that the client inform the server when the
                        window (display) size changes.

     DO TERMINAL-SPEED  Indicates a desire to be able to request information
                        about the speed of the serial line to which the client
                        is attached.

     DO XDISPLOC        Indicates a desire to be able to request the name of
                        the X windows display that is associated with the tel-
                        net client.

     DO NEW-ENVIRON     Indicates a desire to be able to request environment
                        variable information, as described in RFC 1572.

     DO ENVIRON         Indicates a desire to be able to request environment
                        variable information, as described in RFC 1408.

     DO LINEMODE        Only sent if tteellnneettdd is compiled with support for
                        linemode, and requests that the client do line by line
                        processing.

     DO TIMING-MARK     Only sent if tteellnneettdd is compiled with support for both
                        linemode and kludge linemode, and the client responded
                        with WONT LINEMODE. If the client responds with WILL
                        TM, the it is assumed that the client supports kludge
                        linemode.  Note that the [--kk] option can be used to
                        disable this.

     DO AUTHENTICATION  Only sent if tteellnneettdd is compiled with support for au-
                        thentication, and indicates a willingness to receive
                        authentication information for automatic login.

     DO ENCRYPT         Only sent if tteellnneettdd is compiled with support for data
                        encryption, and indicates a willingness to decrypt the
                        data stream.

EENNVVIIRROONNMMEENNTT
FFIILLEESS
     _/_e_t_c_/_s_e_r_v_i_c_e_s
     _/_e_t_c_/_i_n_i_t_t_a_b (UNICOS systems only)
     _/_e_t_c_/_i_p_t_o_s (if supported)
     _/_u_s_r_/_u_c_b_/_b_f_t_p (if supported)

SSEEEE AALLSSOO
     telnet(1),  login(1),  bftp(1) (if supported)

SSTTAANNDDAARRDDSS
     RRFFCC--885544   TELNET PROTOCOL SPECIFICATION
     RRFFCC--885555   TELNET OPTION SPECIFICATIONS
     RRFFCC--885566   TELNET BINARY TRANSMISSION
     RRFFCC--885577   TELNET ECHO OPTION
     RRFFCC--885588   TELNET SUPPRESS GO AHEAD OPTION
     RRFFCC--885599   TELNET STATUS OPTION
     RRFFCC--886600   TELNET TIMING MARK OPTION
     RRFFCC--886611   TELNET EXTENDED OPTIONS - LIST OPTION
     RRFFCC--888855   TELNET END OF RECORD OPTION
     RRFFCC--11007733  Telnet Window Size Option
     RRFFCC--11007799  Telnet Terminal Speed Option
     RRFFCC--11009911  Telnet Terminal-Type Option
     RRFFCC--11009966  Telnet X Display Location Option
     RRFFCC--11112233  Requirements for Internet Hosts -- Application and Support
     RRFFCC--11118844  Telnet Linemode Option
     RRFFCC--11337722  Telnet Remote Flow Control Option
     RRFFCC--11441166  Telnet Authentication Option
     RRFFCC--11441111  Telnet Authentication: Kerberos Version 4
     RRFFCC--11441122  Telnet Authentication: SPX
     RRFFCC--11557711  Telnet Environment Option Interoperability Issues
     RRFFCC--11557722  Telnet Environment Option

BBUUGGSS
     Some TELNET commands are only partially implemented.

     Because of bugs in the original 4.2 BSD telnet(1),  tteellnneettdd performs some
     dubious protocol exchanges to try to discover if the remote client is, in
     fact, a 4.2 BSD telnet(1).

     Binary mode has no common interpretation except between similar operating
     systems (Unix in this case).

     The terminal type name received from the remote client is converted to
     lower case.

     TTeellnneettdd never sends TELNET IAC GA (go ahead) commands.

4.2 Berkeley Distribution        March 1, 1994                               5






