/* tpb.h 1994.5.16 */

#define TPB_VER "1.02"
#define TPB_ID  "[19940516]"

#define CTRL_A  0x01
#define CTRL_B  0x02
#define CTRL_C	0x03

#define MAXACT     8
#define MAXACTPFH  3

#define MAXPFHSIZE  500
#define MAXSLIST   1000

#define FNSLIST "slist.dat"
#define FNLOG   "tpb.log"

#define F_GRABA	0x00000000
#define F_DL	0x00000001
#define F_AUTO  0x00000002
#define F_NEVER 0x00000004
#define F_PRI   0x00000008
#define F_ERROR 0x00000010

struct stslist {
    u_long file_id;
    u_long status;
    u_long timestamp;
};

/* mode */

#define M_MON	0
#define M_DIR	1
#define M_TERM	2

struct stdirent {
    u_long file_id;
    u_long upload_time;
    int len;
    u_char FAR *pfh;
};

#define MAXDENT 2000

struct stact {		    /* active file */
    struct stact *next;
    struct stqueue hole;
    int    nhole;
    u_long file_id;
    u_long file_size;
    int    rcvd;
    FILE   *fp;
    BOOL   f_pfh;
    int    pfh_size;
    u_char pfh[MAXPFHSIZE];
};

struct stmhole {	    /* message hole */
    struct stmhole *next;
    u_long start,end;
};

/* -------------------------------------------------------------- */

/* function */

						/* tpb.c */
extern int log_write(char*);
						/* tpbslist.c */
extern int get_slist(int,struct stslist*);
extern int put_slist(int,struct stslist*);
extern int put_new_slist(struct stslist*);
extern int cnt_slist();
						/* tpbdirf.c */
extern int get_dirent(int,struct stdirent*);
extern int put_dirent(int,struct stdirent*);
extern int put_new_dirent(struct stdirent*);
extern int cnt_dirent();
extern BOOL ck_new_pfh(u_long);
						/* tpbrcvd.c */
extern int get_rcvd(u_long);
extern int put_rcvd(u_long,int);

/* tpb.h */
