/* pbrs232c.c 1994.1.15 */

#include <stdio.h>
#include <dos.h>

#include "pbdef.h"

/*
 * < initrs > initialize RS232C
 */
int initrs(port)
int port;
{
    VOID set_rts(int,BOOL);
    BOOL get_status(int);

    union REGS in,out;

    in.h.ah = 4;
    in.x.dx = port;
    int86(0x14,&in,&out);
    if (out.x.ax != 0xaa55)
        return(3);		/* Error: COMBIOS not exist */
    set_rts(port,ON);		/* RTS on */
    if (get_status(port))
        return(1);
    else
        return(2);		/* Error: port not active */
}

/*
 * < get_status >
 */
BOOL get_status(port)
int port;
{
    union REGS in,out;

    in.h.ah = 0x03;
    in.x.dx = port;
    int86(0x14,&in,&out);
    return((out.h.al & 0x20) == 0x20);
}

/*
 * < set_rts > RTS on/off
 */
VOID set_rts(port,flag)
int port;
BOOL flag;
{
    union REGS in,out;

	if (flag)
        in.h.ah = 6;
    else
        in.h.ah = 5;
    in.x.dx = port;
    int86(0x14,&in,&out);
}

/*
 * < send_break > Send Break
 */
VOID send_break(port)
int port;
{
    union REGS in,out;

    in.h.ah = 7;
    in.x.dx = port;
    int86(0x14,&in,&out);
}

/*
 * < exitrs > exit RS232C
 */
VOID exitrs(port)
int port;
{

}

/*
 * < rsgetc > get RS232C
 */
int rsgetc(port)
int port;
{
    int  c;
    union REGS in,out;

    in.h.ah = 2;
    in.x.dx = port;
    int86(0x14,&in,&out);
    c = out.h.al;
    return(c);
}

/*
 * < rsputc > put RS232C
 */
int rsputc(port,c)
int port;
char c;
{
    union REGS in,out;

    in.h.ah = 1;
    in.h.al = c;
    in.x.dx = port;
    int86(0x14,&in,&out);
}

/*
 * < rsputs > put string RS232C
 */
int rsputs(port,s)
int port;
char *s;
{
    while(*s)
        rsputc(port,*s++);
}

/*
 * < check_port > check port
 */
BOOL check_port(port)
int port;
{
    union REGS in,out;

    in.h.ah = 0x03;
    in.x.dx = port;
    int86(0x14,&in,&out);
    return((out.h.ah & 0x01) > 0);
}

/*
 * < check_send > check send data
 */
BOOL check_send(port)
int port;
{
    union REGS in,out;

    in.h.ah = 0x03;
    in.x.dx = port;
    int86(0x14,&in,&out);
    return((out.x.ax & 0x2010) == 0x2010);
}

/* pbrs232c.c */
