/* pblib.c 1995.3.11 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "pbdef.h"

extern int calc_crc();			/* crc.c */

/*
 * < initq > initialize queue
 */
VOID initq(q)
struct stqueue *q;
{
    q->head = q->tail = NULL;
}

/*
 * < putq > put queue
 */
VOID putq(q,d)
struct stqueue *q;
struct stqcell *d;
{
    if (q == NULL || d == NULL) {
        assert(0);
    }
    d->next = NULL;
    if (q->head == NULL) {
        q->head = q->tail = d;
    } else {
        q->tail->next = d;
	q->tail = d;
    }
}

/*
 * < insq > insert queue
 */
VOID insq(q,d)
struct stqueue *q;
struct stqcell *d;
{
    if (q->head == NULL) {
        putq(q,d);
	return;
    }
    d->next = q->head;
    q->head = d;
}

/*
 * < getq > get queue
 */
struct stqcell *getq(q)
struct stqueue *q;
{
    struct stqcell *r;

    if (q == NULL) {
        assert(0);
    }
    r = q->head;
    if (r != NULL) {
        q->head = r->next;
    }
    if (q->head == NULL) {
        q->tail = NULL;
    }
    return(r);
}

/*
 * < delq > delete queue
 */
VOID delq(q,d)
struct stqueue *q;
struct stqcell *d;
{
    struct stqcell *d2;
    struct stqueue temp;

    initq(&temp);
    while(d2 = getq(q)) {
	if (d2 != d) {
	    putq(&temp,d2);
	}
    }
    *q = temp;
}

/*
 * < addq > add queue
 */
VOID addq(q1,q2)
struct stqueue *q1,*q2;
{
    struct stqcell *d;

    while(d = getq(q2))
        putq(q1,d);
}

/*
 * < cntq > count queue
 */
int cntq(q)
struct stqueue *q;
{
    struct stqcell *r;
    int n;

    n = 0;
    r = q->head;
    while(r) {
        r = r->next;
	n++;
    }
    return(n);
}

/*
 * < ca2ad > call -> adrs
 */
VOID ca2ad(ca,ad)
char *ca,ad[];
{
    int c,i;

    for (i = 0; i < 6; i++)
        ad[i] = ' ' << 1;
    ad[6] = 0x60;		/* RR */
    for (i = 0; i < 7; i++) {
        c = *ca++;
	if (c == '\0') {
	    break;
	} else if (isalpha(c) || isdigit(c)) {	/* A-Z, 0-9 */
	    ad[i] = c << 1;
	} else if (c == '-') {
	    ad[6] |= atoi(ca) << 1;	/* ssid */
	    break;
	}
    }
}

/*
 * < ad2ca > adrs -> call
 */
VOID ad2ca(ad,ca)
char ad[],*ca;
{
    char buf[4];
    int c,i;

    for (i = 0; i < 6; i++) {
        c = (ad[i] & 0xff) >> 1;
	if (isalpha(c) || isdigit(c)) {
	    *ca++ = c;
	} else
	    break;
    }
    *ca = '\0';
    c = (ad[6] >> 1) & 0x0f;
    if (c != 0) {
	sprintf(buf,"-%d",c);
	strcat(ca,buf);
    }
}

/*
 * < cmpadr > cmp adrs
 */
int cmpadr(s1,s2)
char *s1,*s2;
{
    int i;

    for (i = 0; i < 6; i++) {
        if ((*s1 & 0xfe) != (*s2 & 0xfe))
	    return(-1);
	s1++;
	s2++;
    }
    if ((*s1 & 0x1e) != (*s2 & 0x1e))	/* SSID */
        return(-1);
    return(0);
}

/*
 * < adrscpy > copy adrs
 */
int adrscpy(s1,s2)
char *s1,*s2;
{
    int i;

    for (i = 0; i < 6; i++)
        *s1++ = *s2++ & 0xfe;
    *s1 = *s2 & 0x1e;
}

/*
 * < ckcrc > check CRC
 */
ckcrc(buf,len)
char buf[];
int len;
{
    u_int gen_crc();

    u_int crc;
    char *p;
    int i;

    crc = 0;
    p = &buf[17];
    for(i = 17; i < len-2; i++)
        crc = gen_crc(crc,*p++);
    crc = gen_crc(crc, *p++);  /* 1st crc byte */
    if (gen_crc(crc, *p)) {	    /* 2nd crc byte */
	return(NG);
    }
    return(OK);
}

u_int gen_crc(crc,data)
u_int crc;
u_char data;
{
    int y;

    crc ^= ((u_int)data) << 8;
    for(y=0; y < 8; y++)
        if( crc & 0x8000)
            crc = crc << 1 ^ 0x1021;
        else
            crc <<= 1;
    return(crc);
}

/*
 * < frmalloc > frame alloc
 */
struct stframe *frmalloc(size)
int size;
{
    struct stframe *frame;

    frame = malloc(sizeof(struct stframe)+size);
    if (frame) {
        frame->size = size;
	frame->frmlen = 0;
    }
    return(frame);
}

VOID add_frm(frame,p,n)
struct stframe *frame;
char *p;
int n;
{
    while(n-- > 0) {
	if (frame->frmlen > frame->size) {
	    assert(0);
	}
        frame->data[frame->frmlen++] = *p++;
    }
}

VOID add_frm_val(frame,val,n)
struct stframe *frame;
u_long val;
int n;
{
    if (sizeof(u_long) < n || n < 0) {
        assert(0);
    }
    while(n-- > 0) {
	if (frame->frmlen > frame->size) {
	    assert(0);
	}
        frame->data[frame->frmlen++] = val & 0xff;
	val >>= 8;
    }
}

VOID add_crc(frame)
struct stframe *frame;
{
    int j,crc;

    for (j = HDRSIZE, crc = 0; j < frame->frmlen; j++)
        crc = calc_crc(frame->data[j],crc);
    frame->data[frame->frmlen++] = (crc >> 8) & 0xff;
    frame->data[frame->frmlen++] = crc & 0xff;
    ckcrc(frame->data,frame->frmlen);
}

u_long peek_mem(s,n)
u_char s[];
int n;
{
    u_long val;
    int i;

    val = 0;
    for (i = 0; i < n; i++) {
        val |= ((u_long)s[i]) << (8*i);
    }
    return(val);
}

u_long get_val(char *s, int n)
{
    return(peek_mem(s,n));
}

VOID poke_mem(s,val,n)
char *s;
u_long val;
int n;
{
    while(n-- > 0) {
        *s++ = val & 0xff;
	val >>= 8;
    }
}

/* pblib.c */
