/* pbkiss.c 1994.4.30 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <memory.h>
#include <string.h>
#include <assert.h>
#include <conio.h>

#include "pbdef.h"
#include "kiss.h"
#include "pblib.h"
#include "ax25.h"

struct stqueue rkssfrm = {NULL,NULL};
struct stqueue skssfrm = {NULL,NULL};

BOOL f_mon     = ON;

BOOL f_hex     = OFF;
BOOL f_headers = OFF;
BOOL f_xmitok  = ON;
BOOL f_ksslog  = OFF;
BOOL f_kanji   = OFF;

BOOL f_bpq     = OFF;		/* G8BPQ switch */

/* kiss mode parm */
int txd         = 300;		/* 300m sec */
int persist     = NOT_DEFINE;
int slottime    = NOT_DEFINE;
int txtail      = NOT_DEFINE;
int fullduplex  = NOT_DEFINE;
int softdcd     = NOT_DEFINE;
#define MAXSETHW 8
int sethardware[MAXSETHW] = {NOT_DEFINE,NOT_DEFINE,NOT_DEFINE,NOT_DEFINE,
                             NOT_DEFINE,NOT_DEFINE,NOT_DEFINE,NOT_DEFINE};

TINY port    = 0;	/* COM1 */
TINY kisstnc = 0;
TINY tncid   = 0;

/* kiss log */
FILE *fpkss = NULL;

BOOL f_kssin = OFF;
char kssiname[32];	/* in kiss file */
FILE *fpkssin;

extern int initrs(int);			    /* pbrs232c.c */
extern int rsgetc(int),rsputc(int,char);
extern int rsputs(int,char*);
extern BOOL check_port(int),check_send(int);

/*
 * < inikss > initialize KISS mode
 */
VOID inikss()
{
    VOID montnc(int),kissparm(int,int),ksslog(BOOL);

    int i,r;

    r = initrs(port);		/* init RS232C */
    switch(r) {
        case 1:
	    printf("OK port[COM%d]\n",port+1);
	    if (kisstnc == 0) {
	        rsputs(port,"\r");
		montnc(1);
		printf("KISS ON\n");
	        rsputs(port,"KISS ON\r");
		montnc(1);
		printf("RESTART\n");
		rsputs(port,"RESTART\r");
		montnc(4);
	        printf("\n");

		if (txd != NOT_DEFINE) {
		    kissparm(1,txd/10);
		}
		if (persist != NOT_DEFINE) {
		    kissparm(2,persist/10);
		}
		if (slottime != NOT_DEFINE) {
		    kissparm(3,slottime/10);
		}
		if (txtail != NOT_DEFINE) {
		    kissparm(4,txtail/10);
		}
		kissparm(5,fullduplex);
		for (i = 0; i < MAXSETHW; i++) {
		    kissparm(6,sethardware[i]);
		}
		kissparm(7,softdcd);
	    }
	    break;
	case 2:
	    if (!f_bpq) {
	        printf("Error: port not active[COM%d]\n",port+1);
	        exit(1);
	        /* NOT REACHED */
	    }
	    printf("OK BPQ:port[COM%d]\n",port+1);
	    break;
	case 3:
	    printf("Error: COMBIOS not exist[COM%d]\n",port+1);
	    exit(1);
    	    /* NOT REACHED */

	default:
	    break;
    }
    ksslog(f_ksslog);			/* kiss log */
    if (f_kssin) {
        if ((fpkssin = fopen(kssiname,READ_BIN)) == NULL) {
	    printf("Error: in Kiss file open error\n");
	    f_kssin = OFF;
	}
    }
}

/*
 * < exitkss > exit KISS mode
 */
VOID exitkss()
{
    VOID montnc(int),ksslog(BOOL);

    if (kisstnc == 0) {
        rsputc(port,(char)0xff);
        rsputc(port,(char)0xc0);
        rsputc(port,(char)0xff);
	montnc(2);
        rsputc(port,(char)0xff);
        rsputc(port,(char)0xc0);
        rsputc(port,(char)0xff);
        rsputc(port,'\r');
	montnc(8);
	printf("\n");
    }
    ksslog(OFF);
}

/*
 * < montnc > monitor TNC
 */
VOID montnc(int t)
{
    int c;
    clock_t t1;

    t1 = clock(); 
    while((u_long)(clock() - t1) <= (u_long)t) {
	if (check_port(port)) {
            c = rsgetc(port);
            if (c == '\r')
	        putch('\n');
	    if (isprint(c) || c == '\r' || c == '\n') {
	        putch(c);
	    } else {
	        putch('.');
	    }
	}
    }
}

/*
 * < rcvkss > recive KISS frame
 */
VOID rcvkss()
{
    VOID dsphdr(char*,int),dspifrm(char*,int),hexdump(char*,int);

    static int seq = 0;
    static int lnrkss = 0;
    static char rkss[FRMSIZE];

    int i,c;
    struct stframe *frame;

    if (!f_kssin) {
        if (!check_port(port)) {
            return;
        }
    }

    if (cntq(&rkssfrm) > 20)	/* rcv buffer full ? */
        return;

    for (i = 0; i < FRMSIZE; i++) {
	if (f_kssin) {
	    c = fgetc(fpkssin);
	    if (c == EOF) {
	        f_kssin = OFF;
		fclose(fpkssin);
		return;
	    }
	} else {
            if (!check_port(port))
                return;

            c = rsgetc(port);
	}
	if (fpkss) {	    /* kiss log ? */
	    fputc(c,fpkss);
	}

        switch(seq) {
            case 0:
	        lnrkss = 0;
	        if (c == FEND)
	            seq++;
	        break;
	    case 1:
	        if (c == FEND) {
	            if (lnrkss > 0) {
		        frame = frmalloc(lnrkss);
		        if (frame == NULL) {
		             assert(0);
		        }
		        add_frm(frame,rkss,lnrkss);
		        putq(&rkssfrm,frame);
		        seq = 0;
			if (f_mon) {
		            if (f_headers)
		                dsphdr(frame->data,frame->frmlen);
			    dspifrm(frame->data,frame->frmlen);
		            if (f_hex)
		                hexdump(frame->data,frame->frmlen);
			}
		        return;
		    }
	        } else if (c == FESC) {
	            seq++;
	        } else {
	            if (lnrkss >= FRMSIZE) {
		        seq = 0;
		        return;
		    }
	            rkss[lnrkss++] = c;
	        }
	        break;
	    case 2:
	        if (c == TFEND) {
	            c = FEND;
	        } else if (c == TFESC) {
	            c = FESC;
	        } else {
	            seq = 0;
		    return;
	        }
                if (lnrkss >= FRMSIZE) {
	            seq = 0;
		    return;
	        }
	        rkss[lnrkss++] = c;
	        seq--;
	        break;
	    default:
	        break;
        }
    }
}

/*
 * < sndkss > send KISS frame
 */
VOID sndkss()
{
    VOID dsphdr(char*,int),dspifrm(char*,int),hexdump(char*,int);

    static struct stframe *frame;
    static int seq = 0;
    static int pos;
    static char nc;

    int i,c;

    for (i = 0; i < FRMSIZE; i++) {
	if (seq > 0 && !f_bpq) {
	    if (!check_send(port))
	        return;
	}
        switch(seq) {
            case 0:
	        if (skssfrm.head == NULL)
		    return;

	        frame = (struct stframe*)getq(&skssfrm);
		if (f_mon) {
	            if (f_headers)
		        dsphdr(frame->data,frame->frmlen);
		    dspifrm(frame->data,frame->frmlen);
	            if (f_hex)
                        hexdump(frame->data,frame->frmlen);
		}
		if (f_xmitok) {
	            pos = 0;
	            seq++;
		} else {
		    free(frame);
		    seq = 0;
		}
	        break;
	    case 1:
	        rsputc(port,(char)FEND);
	        seq++;
	        break;
	    case 2:
	        if (pos >= frame->frmlen) {
	            seq += 2;
		    break;
	        }
	        c = frame->data[pos++];
                switch(c) {
	            case FEND:
	                c  = FESC;
		        nc = TFEND;
		        seq++;
	                break;
	            case FESC:
	                c  = FESC;
		        nc = TFESC;
		        seq++;
	                break;
	            default:
		        break;
	        }
                rsputc(port,(char)c);
	        break;
	    case 3:
	        rsputc(port,nc);
	        seq--;
	        break;
	    case 4:
                rsputc(port,(char)FEND);
	        seq = 0;
	        free(frame);
	        return;

	    default:
	        break;
	}
    }
}

/*
 * < kissparm > KISS mode parm
 */
VOID kissparm(cmd,parm)
int cmd,parm;
{
    struct stframe *frame;

    if (parm == NOT_DEFINE)
        return;

    frame = frmalloc(2);
    if (frame == NULL) {
        assert(0);
    }
    frame->data[0] = (tncid<<4) | (cmd & 0x0f);
    frame->data[1] = parm;
    frame->frmlen = 2;
    putq(&skssfrm,frame);
}

/*
 * < dsphdr > display Header
 */
VOID dsphdr(p,n)
char p[];
int n;
{
    VOID dspctl(char*,u_char,u_char);

    char to[AXBUF],from[AXBUF];
    char tmp[AXBUF],digi[128],ctlstr[16];
    u_char m,cr,ctl,pid;
    int i,j,len;

    i = 0;
    m = p[i];
    i++;
    ad2ca(p+i,to);
    cr = (p[i+AXALEN-1] >> 2) & 0x38;
    i += AXALEN;
    ad2ca(p+i,from);
    cr |= (p[i+AXALEN-1] >> 5) & 0x07;
     i += AXALEN;
    if (i >= n)
        return;
    digi[0] = '\0';    /* digi */
    for (j = 0; j < MAXDIGIS; j++) {
        if (!(p[i-1] & E)) {    /* digi ? */
            ad2ca(p+i,tmp);
	    strcat(digi,j == 0 ? " VIA " : ",");
	    strcat(digi,tmp);
	    if (p[i+AXALEN-1] & REPEATED) {
	        strcat(digi,"*");
	    }
	    i += AXALEN;
            if (i >= n)
                return;
        } else {
	    break;
	}
    }
    ctl = p[i]; i++;
    if (i < n) {
        pid = p[i];
	len = n-i-1;
    } else
        pid = 0;
    dspctl(ctlstr,cr,ctl);
    if ((ctl&0x01) == I || (ctl&0xef) == UI) {
        printf("[%x %s>%s%s cr=%02o,ctl=%02x,%s,pid=%02x,len=%d]\n",
			(m>>4)&0x0f,from,to,digi,cr,ctl,ctlstr,pid,len);
    } else {
        printf("[%x %s>%s%s cr=%02o,ctl=%02x,%s]\n",
			(m>>4)&0x0f,from,to,digi,cr,ctl,ctlstr);
    }
}

VOID dspctl(buf,cr,ctl)
char buf[];
u_char cr;
u_char ctl;
{
    TINY nr,ns,pf;
    char *crstr,*pfstr;

    nr = (ctl>>5) & 0x07;
    ns = (ctl>>1) & 0x07;
    pf = (ctl>>4) & 0x01;

    crstr = pfstr = "";
    if (cr & 040) {	/* cmd */
        crstr = " C";
	if (pf)
	    pfstr = " P";
    } else if (cr & 004) {
        crstr = " R";	/* res */
	if (pf)
	    pfstr = " F";
    }

    if ((ctl & 0x01) == I) {
        sprintf(buf,"<I%s%s R%d S%d>", crstr, pfstr, nr, ns);
    } else if ((ctl & 0x0f) == RR) {
        sprintf(buf,"<RR%s%s R%d>", crstr, pfstr, nr);
    } else if ((ctl & 0x0f) == RNR) {
        sprintf(buf,"<RNR%s%s R%d>", crstr, pfstr, nr);
    } else if ((ctl & 0x0f) == REJ) {
        sprintf(buf,"<REJ%s%s R%d>", crstr, pfstr, nr);
    } else if ((ctl & 0xef) == SABM) {
        sprintf(buf,"<SABM%s%s>", crstr, pfstr);
    } else if ((ctl & 0xef) == DISC) {
        sprintf(buf,"<DISC%s%s>", crstr, pfstr);
    } else if ((ctl & 0xef) == DM) {
        sprintf(buf,"<DM%s%s>", crstr, pfstr);
    } else if ((ctl & 0xef) == UA) {
        sprintf(buf,"<UA%s%s>", crstr, pfstr);
    } else if ((ctl & 0xef) == FRMR) {
        sprintf(buf,"<FRMR%s%s>", crstr, pfstr);
    } else if ((ctl & 0xef) == UI) {
        sprintf(buf,"<UI%s%s>", crstr, pfstr);
    } else {
        sprintf(buf,"<???%s%s>", crstr, pfstr);
    }
}

/*
 * <dspifrm > display I frame
 */
VOID dspifrm(p,n)
char p[];
int n;
{
    char c;
    u_char ctl,pid;
    int i,j;

    i = 1+AXALEN*2;
    for (j = 0; j < MAXDIGIS; j++) {
        if (p[i-1] & E) {
	    break;
	} else {
	    i += AXALEN;
	}
        if (n < i)
            return;
    }
    ctl = p[i++];	    /* ctl */
    if (!((ctl & 0x01) == I || (ctl & 0xef) == UI)) {
        return;
    }
    pid = p[i++];
    if (!(pid == 0xf0 || pid == 0xbb)) {
        return;
    }
    if (!(pid == 0xf0 && f_kanji)) {
        for (j = i; j < n; j++) {
	    if (!(isprint(p[j]) || isspace(p[j])))
	        return;
        }
    }
    c = 0;
    for (j= i; j < n; j++) {
        c = p[j];
	if (pid == 0xf0 && f_kanji) {
	    if (c == '\r' || c == '\n' || c == '\t' || c >= ' ') {
                printf("%c",c);
	    } else {
	        printf(".");
	    }
        } else {
	    if (isprint(c) || isspace(c)) {
                printf("%c",c);
	    } else {
	        printf(".");
	    }
	}
	if (c == '\r')
	    printf("\n");
    }
    if (c != '\r')
        printf("\n");
}

/*
 * < hexdump > Hex dump display
 */
VOID hexdump(p,n)
char p[];
int n;
{
    static char *buf =
"000: 00010203 04050607 08090A0B 0C0D0E0F 0123456789ABCDEF 0123456789ABCDEF";

    char tmp[5];
    int c,c2,i,j,p1;

    for (i = j = 0; i < n; i++) {
        if (j == 0) {
	    memset(buf,' ',74);
	    buf[74] = '\0';
	    sprintf(tmp,"%03X:",i);
	    memcpy(buf,tmp,4);
	    p1 = 5;
	}
	c = p[i];
	c2 = c>>1;
	sprintf(tmp,"%02X",(c & 0xff));
	memcpy(buf+p1,tmp,2);
	p1 += 2;
	if ((j&3) == 3)
	    p1++;
	if (!isprint(c2))
	    c2 = '.';
	buf[j+41] = c2;
	if (!isprint(c))
	    c = '.';
	buf[j+58] = c;
	if (++j == 16) {
	    j = 0;
	    printf("%s\n",buf);
	}
    }
    if (j != 0)
        printf("%s\n",buf);
}

/*
 * < ksslog > kiss log
 */
VOID ksslog(ctl)
BOOL ctl;
{
    static char kssname[16];
    time_t t;
    struct tm *ptm;

    if (ctl == ON) {
        if (fpkss == NULL) {
	    t = clock();
	    ptm = localtime(&t);
			   /* 93091912.KSS */
	    sprintf(kssname,"%02d%02d%02d%02d.kss",
	        ptm->tm_year,ptm->tm_mon+1,ptm->tm_mday,ptm->tm_hour);
	    if ((fpkss = fopen(kssname,APPEND_BIN)) == NULL) {
	        printf("Error: KissLog file can't open[%s]\n",kssname);
	    }
	    printf("KissLog start[%s]\n",kssname);
	}
    } else {
        if (fpkss != NULL) {
	    fclose(fpkss);
	    printf("KissLog stop[%s]\n",kssname);
	    fpkss = NULL;
	}
    }
}

/*
 * < kiss_cfg > kiss parm config
 */
kiss_cfg(av1,av2)
char *av1,*av2;
{
    int i;

    if (EQ(av1,"TXD")) {
        txd = atoi(av2);
        printf("OK txd [%d]\n",txd);
        return(OK);

    } else if (EQ(av1,"PERSIST")) {
        persist = atoi(av2);
        printf("OK persist [%d]\n",persist);
        return(OK);

    } else if (EQ(av1,"SLOTTIME")) {
        slottime = atoi(av2);
        printf("OK slottime [%d]\n",slottime);
        return(OK);

    } else if (EQ(av1,"TXTAIL")) {
        txtail = atoi(av2);
        printf("OK txtail [%d]\n",txtail);
        return(OK);

    } else if (EQ(av1,"FULLDUPLEX")) {
        fullduplex = atoi(av2);
        printf("OK fullduplex [%d]\n",fullduplex);
        return(OK);

    } else if (EQ(av1,"SETHARDWARE")) {
        for (i = 0; i < MAXSETHW; i++) {
	    if (sethardware[i] == NOT_DEFINE) {
                sethardware[i] = atoi(av2);
	        printf("OK sethardware%d[%d]\n",i,sethardware[i]);
		return(OK);
	    }
	}

    } else if (EQ(av1,"SOFTDCD")) {
        softdcd = atoi(av2);
        printf("OK softdcd [%d]\n",softdcd);
        return(OK);

    } else if (EQ(av1,"KISSTNC")) {
        kisstnc = atoi(av2);
        printf("OK kisstnc [%d]\n",(int)kisstnc);
        return(OK);

    } else if (EQ(av1,"TNCID")) {
        tncid = atoi(av2);
        printf("OK tncid [%d]\n",(int)tncid);
        return(OK);

    }
    return(NG);
}

/* pbkiss.c */
