/* pbdef.h 1994.1.16 */

#define _PBDEF_H

typedef unsigned char u_char;
typedef unsigned int  u_int;
typedef unsigned long u_long;

typedef char VOID;
typedef char BOOL;
typedef char TINY;

#ifdef LSI_C
#define FAR far
#define FAR_MALLOC farmalloc
#define FAR_FREE   farfree
#define FAR_MEMCPY far_memcpy
#else
#define FAR
#define FAR_MALLOC malloc
#define FAR_FREE   free
#define FAR_MEMCPY memcpy
#endif

#ifdef UNIX
#define READ_BIN    "r"
#define WRITE_BIN   "w"
#define RDWR_BIN    "w+"
#define APPEND_BIN  "a"
#else
#define READ_BIN    "rb"
#define WRITE_BIN   "wb"
#define RDWR_BIN    "w+b"
#define APPEND_BIN  "ab"
#endif

#define ESC 0x1b
#define CR  0x0d
#define LF  0x0a
#define BS  0x08

#define OK  1
#define NG  0

#define ON  1
#define OFF 0

#define YES 1
#define NO  0

#define NOT_DEFINE (-1)

#define MAXUSER	    20
#define MAXBLKSIZE  244

#define EQ(A,B) (strcmp((A),(B))==0)

#define HDRSIZE  1+7+7+1+1
#define FRMSIZE	 2048

struct stqcell {
    struct stqcell *next;
};

struct stqueue {
    struct stqcell *head;
    struct stqcell *tail;
};

struct stframe {
    struct stframe *next;
    int size;
    int frmlen;
    char data[0];
};

struct stpfh {
    u_long file_number;		/* 0x01 */
    char   file_name[8];	/* 0x02 */
    char   file_ext[3];		/* 0x03 */
    u_long file_size;		/* 0x04 */
    u_long create_time;		/* 0x05 */
    u_long last_modified_time;	/* 0x06 */
    u_char seu_flag;		/* 0x07 */
    u_char file_type;		/* 0x08 */
    u_int  body_checksum;	/* 0x09 */
    u_int  header_checksum;	/* 0x0a */
    u_int  body_offset;		/* 0x0b */
    char   ax25_uploader[6];	/* 0x11 */
    u_long upload_time;		/* 0x12 */
    u_long expire_time;		/* 0x17 */
    u_char compression_technique; /* 0x19 */
    char   bbs_message_type;	/* 0x20 */
};

struct stpfhvar {
    char source[256];		/* 0x10 */
    char destination[256];	/* 0x14 */
    char title[256];		/* 0x22 */
    char bid[256];		/* 0x21 */
    char keywords[256];		/* 0x23 */
    char user_file_name[256];	/* 0x26 */
};

/* pbdef.h */
