/* fnpetpk.c 1994.7.4 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <assert.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "pblib.h"
#include "ax25.h"

#include "fnpe.h"

extern BOOL ckprompt(char*,int);		/* fnpelib.c */

extern int  lzhuf2k_encode(char*,char*);	/* lzhuf2k.c */
extern int  lzhuf2k_decode(char*,char*);

BOOL f_man_down = OFF;

char ctl_file[128] = "fnpe.ctl";
char lst_file[128] = "fnpe.lst";
char ttl_file[128] = "fnpe.ttl";

char ctl_line[256];

/*
 * < tpk_rcv_prompt >
 */
int tpk_rcv_prompt(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
	fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    fwd_get_init(fwd);
	    set_timeout(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
	        if (ckprompt(fwd->buf,fwd->buflen)) {	/* ">" ? */
		    fwd->seq = SEQ_TPK_SND_FCMD;
	        } else {
		    fwd_error(fwd,ERR_SYNTAX);
		    fwd->seq = SEQ_DISC_REQ;
		}
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

/*
 * < tpk_snd_fcmd >
 */
int tpk_snd_fcmd(fwd)
struct stfwdcb *fwd;
{
    int tpk_get_msg_no();

    char buf[256];
    int  r;

    if (check_logintime(fwd,2*60)) {
        fwd_error(fwd,ERR_LOGINOVER);
        fwd->seq = SEQ_DISC_REQ;
	return;
    }
    r = tpk_get_msg_no(fwd);
    if (r == NG) {
        fwd->seq = SEQ_DISC_REQ;
	return;
    }
    sprintf(buf,"F< %ld\r",fwd->msg_no);
    fwd_puts(fwd,buf);		    /* send F< #Msg command */
    fwd->seq = SEQ_TPK_RCV_MSG;
}

/*
 * < tpk_rcv_msg >
 */
int tpk_rcv_msg(fwd)
struct stfwdcb *fwd;
{
    int tpk_del_ctl();

    struct stax25cb *ax25;
    FILE *fp1,*fp2;
    int  i,len;
    char buf[256];
    char fname1[128];

    ax25 = fwd->ax25;

    switch(fwd->sub_seq) {
        case 0:
	    fwd->sub_seq++;
	    break;
	case 1:
	    set_timeout(fwd);
	    fwd_get_init(fwd);
	    fwd->sub_seq++;
	    break;
	case 2:					/* subject */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
	        fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_get_yapp(fwd)) {
	        if (fwd->buf[0] == 0x18) {
		    log_printf("ERR: Msg #%ld does not exist !",fwd->msg_no);
		    tpk_del_ctl();
		    fwd->seq = SEQ_TPK_RCV_PROMPT;
		    break;
		}
	        if (fwd->buf[0] != 0x01) {
		    log_printf("ERR: yapp 01 frame error");
		    fwd_error(fwd,ERR_YAPP01);
		    fwd->seq = SEQ_DISC_REQ;
		    break;
		}
		strncpy(fwd->rcvsubject,fwd->buf+2,80);
		printf("FWD: YAPP[01:sj=%s]\n",fwd->rcvsubject);
	        if ((fwd->fp = fopen("RCVARC.TMP","wb")) == NULL) {
	            assert(0);
	            exit(1);
	        }
	        fwd_get_init(fwd);
		set_timeout(fwd);
		fwd->checksum = 0;
		fwd->sub_seq++;
	    }
	    break;
	case 3:					/* body */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fclose(fwd->fp);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_get_yapp(fwd)) {
		switch(fwd->buf[0]) {
		    case 0x02:		    /* data */
		        len = fwd->buf[1] & 0xff;
			if (len == 0) {	    /* length adjust */
			    len = 256;
			}
			for (i = 0; i < len; i++) {
			    fwd->checksum += fwd->buf[i+2];
			}
			fwrite(fwd->buf+2,len,1,fwd->fp);
			printf("FWD: YAPP[02:size=%d]\n",len);
			break;
		    case 0x04:		    /* check sum */
		        fclose(fwd->fp);
			printf("FWD: YAPP[04:checksum=%02x]\n",fwd->buf[1]);

		        if ((0x00-fwd->checksum) != fwd->buf[1]) {
			    log_printf("ERR: checksum error[%02x]",
				    (0x00-fwd->checksum));
			    fwd_error(fwd,ERR_CKSUM2);
			    fwd->seq = SEQ_DISC_REQ;
			    break;
			} else {
			    printf("FWD: checksum ok\n");
			}

			/* RCVARC ->RCVTXT */
			lzhuf2k_decode("RCVARC.TMP", "RCVTXT.TMP");

			sprintf(fname1,"%ld",fwd->msg_no);

			if ((fp1 = fopen(fname1,"w")) == NULL) {
			    assert(0);
			}
			fprintf(fp1,"%s\n",ctl_line);
			fprintf(fp1,"%s\n",fwd->rcvsubject);

			if ((fp2 = fopen("RCVTXT.TMP","r")) == NULL) {
			    assert(0);
			}
			while(fgets(buf,256,fp2) != NULL) {
			   fprintf(fp1,"%s",buf);
			}
			fclose(fp2);
			fclose(fp1);

			tpk_del_ctl();
			append_file_string(lst_file,ctl_line);

		        fwd->sub_seq++;
			break;
		    default:
		        fclose(fwd->fp);
		        log_printf("ERR: yapp 02,04 frame error[%02x]",
					    fwd->buf[0]);
			fwd_error(fwd,ERR_YAPP);
			fwd->seq = SEQ_DISC_REQ;
			break;
		}
	        fwd_get_init(fwd);
		set_timeout(fwd);
	    }
	    break;

	case 4:
	    fwd->seq = SEQ_TPK_RCV_PROMPT;
	    break;
	default:
	    break;
    }
}

int tpk_get_msg_no(fwd)
struct stfwdcb *fwd;
{
    char *p,buf[256];

    if (head_file(buf,ctl_file) == NULL) {
        return(NG);
    }
    strcpy(ctl_line,buf);
    p = strtok(buf," \t\r\n");
    if (p == NULL) {
        return(NG);
    }
    fwd->msg_no = strtoul(p,NULL,10);
    return(OK);
}

int tpk_del_ctl()
{
    FILE *fp1,*fp2;
    int line;
    char buf[256];

    copy_file("CTLBAK.TMP",ctl_file);

    if ((fp1 = fopen(ctl_file,"w")) == NULL) {
        assert(0);
    }
    if ((fp2 = fopen("CTLBAK.TMP","r")) == NULL) {
        assert(0);
    }
    line = 0;
    while(fgets(buf,256,fp2) != NULL) {
        if (line > 0) {
            fprintf(fp1,"%s",buf);
	}
	line++;
    }
    fclose(fp1);
    fclose(fp2);
}

/* fnpetpk.c */
