/* fnperli.c 1994.5.6 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <assert.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "pblib.h"
#include "ax25.h"

#include "fnpe.h"

extern int  cnv_out2xul(),cnv_out2ul(),mksndmsg();
extern int  entry_out_bid();

extern BOOL ckprompt(char*,int);		/* fnpelib.c */

/*
 * < rli_rcv_prompt >
 */
int rli_rcv_prompt(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
	fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    fwd_get_init(fwd);
	    set_timeout(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
	        if (ckprompt(fwd->buf,fwd->buflen)) {	/* ">" ? */
		    entry_out_bid(fwd);
		    cnv_out2ul(fwd);
		    fwd->sndcnt = 0;
		    if (fwd->f_valid_call) {
	                fwd->seq = SEQ_RLI_SND_BID;
		    } else {
	                fwd->seq = SEQ_RLI_RCV_MSG;
		    }
	        } else {
		    fwd_error(fwd,ERR_SYNTAX);
		    fwd->seq = SEQ_DISC_REQ;
		}
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

/*
 * < rli_snd_bid >
 */
int rli_snd_bid(fwd)
struct stfwdcb *fwd;
{
    struct find_t buffer;
    struct stmail_ele mail_ele;
    int r,t;
    char buf[256];
    FILE *fp;

    if (check_logintime(fwd,10*60)) {
        fwd_error(fwd,ERR_LOGINOVER);
	fwd->seq = SEQ_RLI_RCV_MSG;
	return;
    }

    r = _dos_findfirst("*.OUT",_A_NORMAL,&buffer);
    if (r != 0) {
        fwd->seq = SEQ_RLI_RCV_MSG;
	return;
    }
    strcpy(fwd->snd[0].fname,buffer.name);
    if ((fp = fopen(fwd->snd[0].fname,"r")) == NULL) {
	    printf("FWD: ERROR: file open error[%s]\n",fwd->snd[0].fname);
	    fwd_error(fwd,ERR_FILE);
            fwd->seq = SEQ_DISC_REQ;
	    return;
    }
    fgets(buf,256,fp);
    fclose(fp);
    t = strlen(buf)-1;
    if (buf[t] == '\n') {	    /* LF -> CR */
        buf[t] = '\r';
    }
    fwd_puts(fwd,buf);		    /* send SP/SB command */
    r= get_mail_ele_rli(&mail_ele,buf);
    strcpy(fwd->snd[0].bid,mail_ele.bid);
    fwd->seq = SEQ_RLI_RCV_STAT;
}

/*
 * < rli_rcv_status >
 */
int rli_rcv_status(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
	fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    fwd_get_init(fwd);
	    set_timeout(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
		if (strncmp(fwd->buf,"OK",2) == 0) {
		    fwd->snd[0].stat = '+';
		    fwd->sndcnt = 1;
		    fwd->seq = SEQ_RLI_SND_MSG;
		} else if (strncmp(fwd->buf,"NO",2) == 0) {
		    fwd->snd[0].stat = '-';
		    fwd->sndcnt = 1;
		    cnv_out2xul(fwd);
		    entry_bid(fwd->snd[0].bid);
		    fwd->seq = SEQ_RLI_SND_BID;
		} else {
		    fwd_error(fwd,ERR_SYNTAX);
		    fwd->seq = SEQ_DISC_REQ;
		}
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

/*
 * < rli_snd_msg >
 */
int rli_snd_msg(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;
    int i,c;
    char buf[256];

    switch(fwd->sub_seq) {
        case 0:
	    mksndmsg(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if ((fwd->fp = fopen(fwd->fname,READ_BIN)) == NULL) {
		fwd_error(fwd,ERR_FILE);
	        assert(0);
	    }
	    fwd->sub_seq++;
	    break;
	case 2:
	    ax25 = fwd->ax25;
	    if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
		fwd->seq = SEQ_DISC;
		break;
	    }
	    if (cntq(&ax25->sndifrm) > 10) {
	        break;
	    }
	    for (i = 0; i < ax25->paclen; i++) {
	        c = fgetc(fwd->fp);
		if (c == EOF) {
		    fwd->sub_seq++;
		    break;
		}
		buf[i] = c;
	    }
	    fwd_putn(fwd,buf,i);
	    set_timeout(fwd);
	    break;
	case 3:
	    fclose(fwd->fp);
	    fwd->seq = SEQ_RLI_RCV_PROMPT;
	    break;
	default:
	    break;
    }
}

/*
 * < rli_rcv_msg >
 */
int rli_rcv_msg(fwd)
struct stfwdcb *fwd;
{
    struct stmail_ele mail_ele;
    struct stax25cb *ax25;
    int r;

    ax25 = fwd->ax25;

    switch(fwd->sub_seq) {
        case 0:
	    fwd_puts(fwd,"F>\r");
	    fwd_get_init(fwd);
	    set_timeout(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
            if (ax25->status == S1) {
                fwd->seq = SEQ_DISC;
	        break;
            }
	    if (fwd_gets(fwd)) {
		if (strncmp(fwd->buf,"S",1) == 0) { /* S command ? */
		    r = get_mail_ele_rli(&mail_ele,fwd->buf);
		    if (r == NG) {
		        fwd_error(fwd,ERR_SYNTAX);
			fwd->seq = SEQ_DISC_REQ;
			break;
		    }
		    strcpy(fwd->rcv[0].bidlist,fwd->buf);
		    strcpy(fwd->rcv[0].bid,mail_ele.bid);
		    if (check_bid(fwd->rcv[0].bid) == NO) {
		        fwd_puts(fwd,"NO\rF>\r");	/* |NO */
							/* |F> */
		    } else {
		        fwd_puts(fwd,"OK\r");		/* |OK */
			strcpy(fwd->fname,"RCVMSG.TMP");
		        if ((fwd->fp = fopen(fwd->fname,"w")) == NULL) {
		            assert(0);
		        }
		        fix_cr(fwd->buf);
		        fprintf(fwd->fp,"%s",fwd->buf);
		        fwd->sub_seq++;
		    }
		} else {
		    fwd_error(fwd,ERR_SYNTAX);
		    fwd->seq = SEQ_DISC_REQ;
		}
	        fwd_get_init(fwd);
		set_timeout(fwd);
	    }
	    break;
        case 2:
	    if (check_timeout(fwd,180)) {
		fclose(fwd->fp);
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
            if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        return;
            }
	    if (fwd_gets(fwd)) {
		if (ck_ex(fwd->buf) || EQ(fwd->buf,"\x1a\r")) {
		    fprintf(fwd->fp,"/EX\n");
		    fclose(fwd->fp);
		    append_file(MAIL_IN,"RCVMSG.TMP");
		    entry_bid(fwd->rcv[0].bid);
		    fwd->sub_seq = 0;
		} else {
		    fix_cr(fwd->buf);
		    fprintf(fwd->fp,fwd->buf);
		}
	        fwd_get_init(fwd);
		set_timeout(fwd);
	    }
	    break;
	default:
	    break;
    }
}

/* fnperli.c */
