/* fnpemtr.c 1994.5.22 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#include <time.h>

#include "pbdef.h"
#include "ax25.h"
#include "pbkiss.h"
#include "pblib.h"

extern char myadrs[];

#define MAX_MTRFILE	2

char mtcall[AXBUF] = "NOCALL";

u_char mtadrs[AXALEN];
struct stqueue mtrfile = {NULL,NULL};	    /* active files   */

struct stmtr {
    struct stmtr *next;
    char to[AXBUF];
    int  vs;
    FILE *fp;
    char fname[32];
};

/*
 * < rcv_mtr >
 */
int rcv_mtr()
{
    struct stmtr *sch_mtr(char*),*alloc_mtr(char*);
    int free_mtr();
    int proc_mtr(struct stmtr*,u_char,u_char,u_char*,int);

    struct stframe *frame;
    struct stmtr   *mtr;
    char to[AXBUF];
    u_char pid,ctl;
    u_char *dat;
    int    len,i,j;

    if (rkssfrm.head == NULL) {
        return(-1);
    }
    frame = (struct stframe*)getq(&rkssfrm);
    if ((frame->frmlen < (1+AXALEN+AXALEN+1)) ||
        (cmpadr(frame->data+1,myadrs) == 0)  ||
        (cmpadr(frame->data+8,mtadrs) != 0)) {
        insq(&rkssfrm,frame);
        return(-1);
    }
    ad2ca(frame->data+1,to);
    mtr = sch_mtr(to);
    if (mtr == NULL) {
        if (cntq(&mtrfile) >= MAX_MTRFILE) {
	    mtr = (struct stmtr*)mtrfile.tail;
	    delq(&mtrfile,mtr);
	    free_mtr(mtr);
	}
        mtr = alloc_mtr(to);
    } else {
        delq(&mtrfile,mtr);
    }

    i = 1+AXALEN+AXALEN;
    for (j = 0; j < MAXDIGIS; j++) {
        if (frame->data[i-1] & E)	/* adrs end ? */
	    break;
	i += AXALEN;
    }
    ctl = frame->data[i++];
    pid = frame->data[i++];
    dat = frame->data+i;
    len = frame->frmlen - i;
    proc_mtr(mtr,ctl,pid,dat,len);

    insq(&mtrfile,mtr);
    free(frame);
    return(0);
}

proc_mtr(mtr,ctl,pid,dat,len)
struct stmtr *mtr;
u_char ctl,pid;
u_char dat[];
int len;
{
    void mtr_fix_cr(char*,int);
    int write_mtr(struct stmtr*,char*,int);

    int vs;

    if ((ctl & 0x01) == I) {	    /* I frame ? */
        vs = (ctl>>1)&0x07;

        printf("MTR:>%s,ctl=%02x,vs=%d,len=%d\n",mtr->to,ctl,vs,len);

	if (vs == mtr->vs) {
	    mtr->vs = (vs+1)&0x07;	/* V(S) + 1 */
	    mtr_fix_cr(dat,len);
            write_mtr(mtr,dat,len);
	}

    } else if ((ctl & 0xef) == DISC) {
        mtr->vs = 0;
    } else if ((ctl & 0xef) == UA) {
        mtr->vs = 0;
    }
}

void mtr_fix_cr(dat,len)
char dat[];
int len;
{
    int i;

    for (i = 0; i < len; i++) {
        if (dat[i] == '\r')
	    dat[i] = '\n';
    }
}

int write_mtr(mtr,dat,len)
struct stmtr *mtr;
char *dat;
int  len;
{
    if (mtr->fp == NULL) {
        if (strlen(mtr->to) <= 8) {
            sprintf(mtr->fname,"%s",mtr->to);
	} else {
	    strcpy(mtr->fname,mtr->to+1);
	}
        strcat(mtr->fname,".MTR");


	if ((mtr->fp = fopen(mtr->fname,"a")) == NULL) {
	    perror(mtr->fname);
	}
	printf("MTR:Open: %s\n",mtr->fname);
    }
    if (mtr->fp) {
        fwrite(dat,len,1,mtr->fp);
    }
}

struct stmtr *sch_mtr(to)
char to[];
{
    struct stmtr *mtr;

    mtr = (struct stmtr*)mtrfile.head;
    while(mtr) {
        if (strcmp(to,mtr->to) == 0)
	    break;
	mtr = mtr->next;
    }
    return(mtr);
}

struct stmtr *alloc_mtr(to)
char to[];
{
    struct stmtr *mtr;

    mtr = malloc(sizeof(struct stmtr));
    if (mtr) {
        strcpy(mtr->to,to);
	mtr->vs = 0;
	mtr->fp = NULL;
	strcpy(mtr->fname,"--------.---");
    }
    return(mtr);
}

free_mtr(mtr)
struct stmtr *mtr;
{
    if (mtr->fp) {
        fclose(mtr->fp);
	printf("MTR:Close: %s\n",mtr->fname);
    }
    free(mtr);
}

/*
 * < init_mtr >
 */
void init_mtr()
{
    ca2ad(mtcall,mtadrs);
}

/*
 * < exit_mtr >
 */
void exit_mtr()
{
    struct stmtr *mtr;

    while(mtr = (struct stmtr*)getq(&mtrfile)) {
        free_mtr(mtr);
    }
}

void mtr_status()
{
    struct stmtr *mtr;

/*          01234567890123456789012345678901234567890 */
    printf("--- MTR Status -----------------------\n");
    printf("Call        :V(S):fileName\n");
    for (mtr = (struct stmtr*)mtrfile.head; mtr; mtr = mtr->next) {
        printf("%-12s:%d   :%s\n",mtr->to,mtr->vs,mtr->fname);
    }
    printf("--- MTR Status -----------------------\n");
}

/* fnpemtr.c */
