/* fnpelib.c 1994.6.23 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <assert.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "pblib.h"
#include "ax25.h"

#include "fnpe.h"

/*
 * < fwd_putn > putn
 */
int fwd_putn(fwd,s,n)
struct stfwdcb *fwd;
char *s;
int n;
{
    struct stax25cb *ax25;
    struct stframe *frame;

    ax25 = fwd->ax25;
    if((frame = frmalloc(n)) == NULL) {
        assert(0);
    }
    add_frm(frame,s,n);
    putq(&ax25->sndifrm,frame);
}

/*
 * < fwd_puts > puts
 */
int fwd_puts(fwd,s)
struct stfwdcb *fwd;
char *s;
{
    fwd_putn(fwd,s,strlen(s));
}

/*
 * < fwd_getc > getc
 *			return: (-1)...no data
 */
int fwd_getc(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;
    struct stframe *frame;
    int c;

    ax25 = fwd->ax25;

    frame = (struct stframe*)ax25->rcvifrm.head;
    if (frame == NULL)
        return(-1);
    if (frame->frmlen == 0) {
        frame = (struct stframe*)getq(&ax25->rcvifrm);
	free(frame);
	return(-1);
    }
    c = frame->data[0] & 0xff;
    frame->frmlen--;
    if (frame->frmlen > 0) {
        memmove(frame->data,frame->data+1,frame->frmlen);
    }
    return(c);
}

/*
 * < fwd_gets > gets
 *			0...idol, not 0...buffer length
 */
int fwd_gets(fwd)
struct stfwdcb *fwd;
{
    int c;

    c = fwd_getc(fwd);
    if (c == (-1)) {
        return(0);
    }
    fwd->buf[fwd->buflen++] = c;
    fwd->buf[fwd->buflen]   = '\0';
    if (c == '\r' || fwd->buflen >= 255) {
        return(fwd->buflen);
    }
    return(0);
}

/*
 * < fwd_get_yapp > get yapp
 *			return: 0...idol nit 0 ... length
 */
int fwd_get_yapp(fwd)
struct stfwdcb *fwd;
{
    int c,len;

    c = fwd_getc(fwd);
    if (c == (-1)) {
        return(0);
    }
    fwd->buf[fwd->buflen++] = c;
    if (fwd->buflen <= 1) {
        return(0);
    }
    if (fwd->buflen == 2 && fwd->buf[0] == 0x04) {  /* yapp 04 */
        return(fwd->buflen);
    }
    if (fwd->buflen <= 2) {
        return(0);
    } else if (fwd->buflen > (256+2)) {
        assert(0);
    }
    len = fwd->buf[1] & 0xff;
    if (len == 0)	/* length adjust */
        len = 256;
    if ((fwd->buflen-2) != len) {
        return(0);
    }
    return(fwd->buflen);
}

VOID fwd_get_init(fwd)
struct stfwdcb *fwd;
{
    fwd->buflen = 0;
}

/*
 * < ck_ex > check "/EX"
 */
BOOL ck_ex(s)
char s[];
{
    if ((s[0] == '/') && 
        (s[1] == 'e' || s[1] == 'E') &&
	(s[2] == 'x' || s[2] == 'X')) {
	return(ON);
    }
    return(OFF);
}

BOOL ckprompt(s,n)
char s[];
int n;
{
    if (n >= 2) {
        if (s[n-2] == '>' && s[n-1] == '\r') {
            return(ON);
	}
    }
    return(OFF);
}

/*
 * < fwdtype > FWD type
 */
int fwdtype(sid)
char sid[];
{
    int type,i;

    type = T_RLI;
    for (i = strlen(sid); i >= 0; i--) {
        switch(sid[i]) {
	    case 'F':
	        if (type == T_RLI)
	            type = T_FBB_TXT;
		break;
	    case 'B':
		if (type == T_FBB_TXT)
	            type = T_FBB_BIN;
		break;
	    case '-':
	    case '[':
	        return(type);
	}
    }
    return(type);
}

VOID print_fwdtype(type)
int type;
{
    switch(type) {
        case T_RLI:     
	    printf("FWD: RLI protocol\n"); 
	    break;
	case T_FBB_TXT: 
	    printf("FWD: FBB text protocol\n"); 
	    break;
	case T_FBB_BIN:
	    printf("FWD: FBB binary protocol\n");
	    break;
	case T_TPK:
	    printf("FWD: TPK(?) protocol\n");
	    break;
    }
}

int fput_yapp_01(fp,subject)
FILE *fp;
char subject[];
{
    int len;

    len = strlen(subject);

    fputc(0x01,fp);
    fputc(len+1+6+1,fp);
    if (len > 0) {
        fwrite(subject,len,1,fp);
    }
    fputc(0x00,fp);
    fwrite("     0",6,1,fp);
         /* 123456 */
    fputc(0x00,fp);
}

int fput_yapp_02(fp,dat,len)
FILE *fp;
char dat[];
int  len;
{
    fputc(0x02,fp);
    fputc(len,fp);
    fwrite(dat,len,1,fp);
}

int fput_yapp_04(fp,checksum)
FILE *fp;
u_char checksum;
{
    fputc(0x04,fp);
    fputc(0-checksum,fp);
}

int append_file(name1,name2)
char name1[],name2[];
{
    FILE *fp1,*fp2;
    char buf[256];

    if ((fp1 = fopen(name1,"a")) == NULL) {
        assert(0);
    }
    if ((fp2 = fopen(name2,"r")) == NULL) {
        assert(0);
    }

    while(fgets(buf,256,fp2) != NULL) {
        fprintf(fp1,"%s",buf);
    }

    fclose(fp1);
    fclose(fp2);
}

int append_file_string(name,buf)
char name[];
char buf[];
{
    FILE *fp;

    if ((fp = fopen(name,"a")) == NULL) {
        assert(0);
    }
    fprintf(fp,"%s",buf);
    fclose(fp);
}

int copy_file(name1,name2)
char name1[],name2[];
{
    FILE *fp1,*fp2;
    char buf[256];

    if ((fp1 = fopen(name1,"w")) == NULL) {
        assert(0);
    }
    if ((fp2 = fopen(name2,"r")) == NULL) {
        assert(0);
    }

    while(fgets(buf,256,fp2) != NULL) {
        fprintf(fp1,"%s",buf);
    }

    fclose(fp1);
    fclose(fp2);
}

char *head_file(buf,name)
char buf[];
char name[];	/* file name */
{
    FILE *fp;

    if ((fp = fopen(name,"r")) == NULL) {
        return(NULL);
    }
    if (fgets(buf,256,fp) == NULL) {
        return(NULL);
    }
    fclose(fp);
    return(buf);
}

int fix_cr(s)
char *s;
{
    while(*s) {
        if (*s == '\r')
	    *s = '\n';
	s++;
    }
}

/*
 * < del_eol > delete CR,LF
 */
int del_eol(s)
char s[];
{
    char c;
    int  i;

    for (i = strlen(s)-1; i >= 0; i--) {
        c = s[i];
	if (c == '\r' || c == '\n') {
	    s[i] = '\0';
	} else {
	    break;
	}
    }
}

char *adjust_rli_scmd(char s[])
{
    char c,*d,buf[MAXLBUF];
    int i,l;

    l = strlen(s);
    d = buf;

    for (i = 0; i < l; i++) {
        switch(c = s[i]) {
	    case '@':
	        *d++ = ' ';
		*d++ = '@';
		*d++ = ' ';
	        break;
	    case '<':
	        *d++ = ' ';
		*d++ = '<';
		*d++ = ' ';
	        break;
	    default:
	        *d++ = c;
	        break;
	}
    }
    *d = '\0';
    strcpy(s,buf);
    return(s);
}

int clr_mail_ele(mail_ele)
struct stmail_ele *mail_ele;
{
    mail_ele->type = 'P';	/* default P-mail */
    strcpy(mail_ele->to,  "");
    strcpy(mail_ele->at,  "");
    strcpy(mail_ele->from,"");
    strcpy(mail_ele->bid, "");
    mail_ele->size = 0;
    mail_ele->checksum = 0;
}

int get_mail_ele_rli(mail_ele,s)
struct stmail_ele *mail_ele;
char s[];
{
    char *p,buf[MAXLBUF];

    strcpy(buf,s);

    adjust_rli_scmd(buf);

    p = strtok(buf," \n\r\t");
    if (p == NULL)
        return(NG);
    strupr(p);
    mail_ele->type = p[1];	/* P or B */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strupr(p);
    strcpy(mail_ele->to,p);	/* To */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);		/* @ skip */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strupr(p);
    strcpy(mail_ele->at,p);	/* At */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);		/* < skip */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strupr(p);
    strcpy(mail_ele->from,p);	/* From */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strcpy(mail_ele->bid,p+1);	/* Bid */
    return(OK);
}

int put_mail_ele_rli(mail_ele,s)
struct stmail_ele *mail_ele;
char s[];
{
    sprintf(s,"S%c %s @ %s < %s $%s",
        mail_ele->type,
	mail_ele->to,
	mail_ele->at,
	mail_ele->from,
	mail_ele->bid);
}

int get_mail_ele_fbb(mail_ele,s)
struct stmail_ele *mail_ele;
char s[];
{
    char *p,buf[MAXLBUF];

    strcpy(buf,s);

    p = strtok(buf," \n\r\t");
    if (p == NULL)
        return(NG);		/* FA or FB skip */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    mail_ele->type = p[0];	/* P or B */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strcpy(mail_ele->from,p);	/* From */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strcpy(mail_ele->at,p);	/* At */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strcpy(mail_ele->to,p);	/* To */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    strcpy(mail_ele->bid,p);	/* Bid */

    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(NG);
    mail_ele->size = atol(p);	/* Size */
    return(OK);
}

int put_mail_ele_fbb(mail_ele,s)
struct stmail_ele *mail_ele;
char s[];
{
    sprintf(s,"FA %c %s %s %s %s %ld",
        mail_ele->type,
	mail_ele->from,
	mail_ele->at,
	mail_ele->to,
	mail_ele->bid,
	mail_ele->size);
}

/*
 * < check_timeout > checl time out
 */
BOOL check_timeout(fwd,t)
struct stfwdcb *fwd;
int t;
{
    u_long t1;

    t1 = (u_long)clock() - (u_long)fwd->t_timeout;
    return(t1 > (u_long)t);
}

VOID set_timeout(fwd)
struct stfwdcb *fwd;
{
    fwd->t_timeout = clock();
}

/*
 * < check_logintime > check login time
 */
BOOL check_logintime(fwd,t)
struct stfwdcb *fwd;
int t;
{
    u_long t1;

    t1 = (u_long)clock() - (u_long)fwd->t_logintime;
    return(t1 > (u_long)t);
}

VOID set_logintime(fwd)
struct stfwdcb *fwd;
{
    fwd->t_logintime = clock();
}

/*
 * < fwd_error > error
 */
VOID fwd_error(fwd,errcode)
struct stfwdcb *fwd;
int errcode;
{
    switch(errcode) {
        case ERR_TIMEOUT:
	    log_printf("ERR:timeout");
	    break;
	case ERR_LINKOUT:
	    log_printf("ERR:AX.25 linkout");
	    break;
        case ERR_LOGINOVER:
	    log_printf("ERR:login time over");
	    break;
	case ERR_FILE:
	    log_printf("ERR:file access");
	    break;
	case ERR_SYNTAX:
	    log_printf("ERR:syntax");
	    break;
	case ERR_CKSUM1:
	    log_printf("ERR:checksum 1");
	    break;
	case ERR_CKSUM2:
	    log_printf("ERR:checksum 2");
	    break;
	case ERR_YAPP01:
	    log_printf("ERR:yapp 01 frame");
	    break;
	case ERR_YAPP:
	    log_printf("ERR:yapp frame");
	    break;
	default:
	    log_printf("ERR:???");
	    break;
    }
}

/*
 * < str_sid > string SID
 */
VOID str_sid(buf,protocol)
char buf[];
int protocol;
{
    sprintf(buf,"[%s-%s-",AUTHOR_ID,AUTHOR_DATA);
    switch(protocol) {
        case T_RLI:     strcat(buf,"HM$]");   break;
	case T_FBB_TXT: strcat(buf,"FHM$]");  break;
	case T_FBB_BIN: strcat(buf,"BFHM$]"); break;
	case T_TPK:     strcat(buf,"$]");     break;
    }
}

/* fnpelib.c */
