/* fnpefwd.c 1994.6.22 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <assert.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "pblib.h"
#include "ax25.h"

#include "fnpe.h"

extern BOOL f_debug,f_verbose,f_automode;   /* fnpe.c */
extern BOOL f_exit;
extern BOOL f_up_req;
extern BOOL f_down_req;

extern char mycall[];
extern char myadrs[];

extern int  protocol;

extern struct stqueue ax25queue;	    /* ax25lnk.c */

extern int rli_snd_bid(),rli_rcv_status();  /* fnperli.c */
extern int rli_snd_msg(),rli_rcv_prompt();
extern int rli_rcv_msg();

extern int  fwdtype(char*);		    /* fnpelib.c */
extern VOID print_fwdtype(int);
extern BOOL ckprompt(char*,int);

struct stax25cb ax25cb;

BOOL f_man_up = OFF;	    /* upload MAN request flag */
BOOL f_upmon  = ON;	    /* upload monitor */

char bbscall[AXBUF];
char bbsadrs[AXALEN];

char digicall[AXBUF];
int digi = 0;

int paclen = 128;
int maxframe = 2;

/*
 * < make_link > make link
 */
int make_link(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    switch(fwd->sub_seq) {
        case 0:
	    if (f_mon)
	        printf("FWD: Start\n");
	    ax25->f_start = ON;
	    ax25->f_conok = OFF;
	    fwd->sub_seq++;
	    break;
        case 1:
	    if (!ax25->f_start) {
	        fwd->sub_seq++;
	    }
	    break;
	case 2:
	    if (ax25->status == S1) {
		switch(ax25->dreason) {
		    case DISC_BUSY:
		        log_printf("*** %s busy",bbscall);
			break;
		    case DISC_LOCAL:
		    case DISC_REMOTE:
		        log_printf("*** DISCONNECTED");
		        break;
		    case DISC_TIMEOUT:
		        log_printf("*** retry count exceeded");
			break;
		}
		fwd->seq = SEQ_DISC;
	    } else if (ax25->status == S5) {
	            log_printf("*** CONNECTED to %s",bbscall);
		if (cmpadr(ax25->yradrs,bbsadrs) == 0) {
		    fwd->f_valid_call = ON;
		} else {
		    fwd->f_valid_call = OFF;
		}
		set_logintime(fwd);
		fwd->seq = SEQ_WAIT_PROMPT;
	    }
	default:
	    break;
    }
}

/*
 * < snd_open > open message SID
 */
int snd_open(fwd)
struct stfwdcb *fwd;
{
    char buf[80];

    str_sid(buf,protocol);
    strcat(buf,"\r>\r");	    /* add prompt */
    fwd_puts(fwd,buf);
    fwd->seq = SEQ_RCV_SID;
}

/*
 * < rcv_sid > rcv SID
 */
int rcv_sid(fwd)
struct stfwdcb *fwd;
{
    BOOL cksid();
    int fbb_init();

    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
	fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    set_timeout(fwd);
	    fwd_get_init(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
	        if (cksid(fwd->buf,fwd->buflen)) {	/* "[   ]" ? */
		    fbb_init(fwd);
		    strcpy(fwd->sid,fwd->buf);	    /* save SID */
		    fwd->type = fwdtype(fwd->sid);
		    if (fwd->type > protocol) {
		        fwd->type = protocol;
		    }
		    print_fwdtype(fwd->type);
		    if (fwd->type == T_RLI) {
		        fwd->seq = SEQ_RLI_RCV_MSG;
		    } else {
	                fwd->seq = SEQ_FBB_RCV_BID;
		    }
	        }
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

BOOL cksid(s,n)
char s[];
int n;
{
    if (s[0] == '[') {
        return(ON);
    }
    return(OFF);
}

/*
 * < wait_prompt > wait prompt ">"
 */
int wait_prompt(fwd)
struct stfwdcb *fwd;
{
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
        fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    set_timeout(fwd);
	    fwd_get_init(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
		if (cksid(fwd->buf,fwd->buflen)) {
		    strcpy(fwd->sid,fwd->buf);
		}
	        if (ckprompt(fwd->buf,fwd->buflen)) {	/* ">" ? */
		    fwd->type = fwdtype(fwd->sid);
		    if (fwd->type > protocol) {
		        fwd->type = protocol;
		    }
		    if (f_down_req && fwd->type == T_FBB_BIN) {
		        fwd->type = T_TPK;
		    }
		    print_fwdtype(fwd->type);
	            fwd->seq = SEQ_SND_SID;
	        }
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

/*
 * < snd_sid > send SID
 */
int snd_sid(fwd)
struct stfwdcb *fwd;
{
    int fbb_init();

    char buf[80];

    if (fwd->type == T_TPK) {
        str_sid(buf,T_TPK);
    } else {
        str_sid(buf,protocol);
    }
    strcat(buf,"\r");
    fwd_puts(fwd,buf);
    fbb_init(fwd);
    switch(fwd->type) {
        case T_RLI:
            fwd->seq = SEQ_RLI_RCV_PROMPT;
	    break;
	case T_TPK:
            fwd->seq = SEQ_TPK_RCV_PROMPT;
	    break;
	default:
	    fwd->seq = SEQ_FBB_SND_BID;
	    break;
    }
}

/* fnpefwd.c */
