/* fnpefbb.c 1994.6.22 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <assert.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "pblib.h"
#include "ax25.h"

#include "fnpe.h"

extern BOOL f_debug,f_verbose,f_automode;   /* fnpe.c */
extern BOOL f_exit;
extern BOOL f_up_req;
extern BOOL f_down_req;

extern char mycall[];
extern char myadrs[];

extern struct stqueue ax25queue;	    /* ax25lnk.c */

extern int  make_link();		    /* fnpefwd.c */
extern int  snd_open();
extern int  rcv_sid();
extern BOOL cksid(char*,int);
extern int  wait_prompt();
extern int  snd_sid();

extern int  rli_snd_bid(),rli_rcv_status();  /* fnperli.c */
extern int  rli_snd_msg(),rli_rcv_prompt();
extern int  rli_rcv_msg();

extern int  tpk_rcv_prompt();		    /* fnpetpk.c */
extern int  tpk_snd_fcmd();
extern int  tpk_rcv_msg();

extern int  fwdtype(char*);		    /* fnpelib.c */
extern VOID print_fwdtype(int);
extern BOOL ckprompt(char*,int);
extern int  fput_yapp_01(FILE*,char*);
extern int  fput_yapp_02(FILE*,char*,int);
extern int  fput_yapp_04(FILE*,u_char);

extern int  lzhuf2k_encode(char*,char*);    /* lzhuf2k.c */
extern int  lzhuf2k_decode(char*,char*);

extern struct stax25cb ax25cb;
extern BOOL f_man_up;
extern BOOL f_man_down;
extern BOOL f_upmon;
extern char bbscall[];
extern char bbsadrs[];
extern char digicall[];
extern int digi;
extern int paclen;
extern int maxframe;

static struct stfwdcb fwdcb;
static struct stfwdcb *fwd;

/*
 * < ini_fwd > initialize fwd
 */
VOID ini_fwd()
{
    struct stfwdcb *fwd;

    fwd = &fwdcb;
    fwd->ax25 = &ax25cb;
				/* TNC parm */
    ax25cb.maxframe = maxframe;
    ax25cb.paclen   = paclen;
    ax25cb.check    = 60;	/* 60 sec */
    ax25cb.retry    = 10;
    ax25cb.frack    = 8;	/* 8 sec */

    putq(&ax25queue,&ax25cb);
}

/*
 * < check_fwd > check fwding
 */
BOOL check_fwd()
{
    struct stfwdcb *fwd;

    fwd = &fwdcb;

    if (fwd->seq > SEQ_IDOL) {
        return(ON);
    } else {
        return(OFF);
    }
}

/*
 * < proc_fwd > proc fwd
 */
int proc_fwd()
{
    VOID fwdfbb();

    fwdfbb();
}

/*
 * < fwdfbb > FWD FBB protocol
 */
VOID fwdfbb()
{
    int wait_prompt(),snd_sid(),rcv_sid(),snd_open();

    int fbb_snd_bidlist(),fbb_rcv_status(),fbb_snd_msg();
    int fbb_rcv_bidlist(),fbb_snd_status(),fbb_rcv_msg();

    struct stfwdcb  *fwd;
    struct stax25cb *ax25;

    fwd = &fwdcb;
    ax25 = fwd->ax25;

    fwd->sv_seq = fwd->seq;
    switch(fwd->seq) {
        case SEQ_INIT:		    /* Initialize */
            ca2ad(bbscall,ax25->yradrs);
            ca2ad(bbscall,bbsadrs);
            ca2ad(mycall,ax25->myadrs);
            ca2ad(digicall,ax25->digiadrs[0]);
	    ax25->digi    = digi;
	    ax25->tncid   = tncid;
	    ax25->f_conok = ON;
	    set_timeout(fwd);
            fwd->seq = SEQ_IDOL;
	    break;
	case SEQ_IDOL:
	    if (f_man_up) {	    /* MAN up load request */
		f_up_req = ON;
	    }
	    if (f_man_down) {	    /* MAN down load request */
		f_down_req = ON;
	    }
	    if (f_up_req || f_down_req) {/* AUTO up/down load request */
		fwd->seq = SEQ_MAKE_LINK;
	    }
	    ax25 = fwd->ax25;
	    if (ax25->status == S5) {	/* connected ? */
	        if (cmpadr(ax25->yradrs,bbsadrs) == 0) {
		    fwd->f_valid_call = ON;
		} else {
		    printf("FWD: Illegal bbs\n");
		}
	        fwd->seq = SEQ_SND_OPEN;
	    }
	    break;

	case SEQ_SND_OPEN:    snd_open(fwd);	    break;
	case SEQ_RCV_SID:     rcv_sid(fwd);	    break;
	case SEQ_MAKE_LINK:   make_link(fwd);	    break;
	case SEQ_WAIT_PROMPT: wait_prompt(fwd);	    break;
	case SEQ_SND_SID:     snd_sid(fwd);	    break;

/* FBB protocol */

	case SEQ_FBB_SND_BID:  fbb_snd_bidlist(fwd); break;
	case SEQ_FBB_RCV_STAT: fbb_rcv_status(fwd);  break;
	case SEQ_FBB_SND_MSG:  fbb_snd_msg(fwd);     break;
	case SEQ_FBB_RCV_BID:  fbb_rcv_bidlist(fwd); break;
	case SEQ_FBB_SND_STAT: fbb_snd_status(fwd);  break;
	case SEQ_FBB_RCV_MSG:  fbb_rcv_msg(fwd);     break;

/* RLI protocol */

	case SEQ_RLI_RCV_PROMPT: rli_rcv_prompt(fwd);  break;
	case SEQ_RLI_SND_BID:	 rli_snd_bid(fwd);     break;
	case SEQ_RLI_RCV_STAT:   rli_rcv_status(fwd);  break;
	case SEQ_RLI_SND_MSG:    rli_snd_msg(fwd);     break;
	case SEQ_RLI_RCV_MSG:    rli_rcv_msg(fwd);     break;

/* TPK(?) protocol */

	case SEQ_TPK_RCV_PROMPT: tpk_rcv_prompt(fwd);  break;
	case SEQ_TPK_SND_FCMD:   tpk_snd_fcmd(fwd);    break;
	case SEQ_TPK_RCV_MSG:    tpk_rcv_msg(fwd);     break;

	case SEQ_DISC_REQ:
	    if (f_mon)
	        printf("FWD: DISCONNECT REQUEST\n");
	    ax25->f_stop = ON;
	    fwd->seq = SEQ_DISC;
	    break;
	case SEQ_DISC:
	    if (ax25->status == S1 || check_timeout(fwd,180)) {
		if (check_timeout(fwd,180)) {
		    log_printf("DISC TIMEOUT");
		}
		log_printf("*** DISCONNECTED");
		fwd->seq = SEQ_INIT;

	        if (f_up_req) {
	            f_up_req = OFF;
		    if (f_man_up) {
		        f_man_up = OFF;
		    } else {
		        printf("FWD: EXIT...\n");
		        f_exit = ON;	    /* exit program */
		    }
		}
	        if (f_down_req) {
	            f_down_req = OFF;
		    if (f_man_down) {
		        f_man_down = OFF;
		    } else {
		        printf("FWD: EXIT...\n");
		        f_exit = ON;	    /* exit program */
		    }
		}
	    }
	    break;
	default:
	    break;
    }
    if (fwd->sv_seq != fwd->seq) {
        fwd->sv_seq = fwd->seq;
	fwd->sub_seq = 0;
	set_timeout(fwd);
    }
}

/*
 * < fbb_init > FBB protocol initialize
 */
int fbb_init(fwd)
struct stfwdcb *fwd;
{
    fwd->f_msg_empty = OFF;
}

/*
 * < fbb_snd_bidlist > send BID/MID list
 */
int fbb_snd_bidlist(fwd)
struct stfwdcb *fwd;
{
    int mkbidlist();
    u_char cksum_snd_bidlist();

    struct stax25cb *ax25;
    struct find_t buffer;
    int r,i;
    char *p,buf[1024],buf2[32];

    switch(fwd->sub_seq) {
        case 0:
	    fwd->sub_seq++;
	    break;
	case 1:
	    fwd->sndcnt = 0;
    	    for (i = 0; i < 5; i++) {
                if (i == 0) {
                    r = _dos_findfirst("*.OUT",_A_NORMAL,&buffer);
	        } else {
	            r = _dos_findnext(&buffer);
	        }
	        if (r != 0)
	            break;
		strcpy(fwd->snd[i].fname,buffer.name);
		fwd->sndcnt++;
	    }
	    if (!fwd->f_valid_call) {
	        fwd->sndcnt = 0;
	    }
	    if (check_logintime(fwd,10*60)) {
	        fwd_error(fwd,ERR_LOGINOVER);
	        fwd->sndcnt = 0;
	    }
	    if (fwd->sndcnt != 0) {
	        mkbidlist(fwd);
		buf[0] = '\0';
		for (i =0; i < fwd->sndcnt; i++) {
		    strcat(buf,fwd->snd[i].bidlist);
		}
		if (fwd->type == T_FBB_BIN) {
		    sprintf(buf2,"F> %02X\r",cksum_snd_bidlist(fwd));
		} else {
                    strcat(buf2,"F>\r");
		}
		strcat(buf,buf2);

		ax25 = fwd->ax25;
		for (p = buf; *p; ) {
		    i = strlen(p);
		    if (i > ax25->paclen)
		        i = ax25->paclen;
		    fwd_putn(fwd,p,i);
		    p += i;
		}

		fwd->seq = SEQ_FBB_RCV_STAT;
	    } else{
		if (fwd->f_msg_empty) {
		    fwd_puts(fwd,"FQ\r");
		    fwd->seq = SEQ_DISC_REQ;
		} else {
                    fwd_puts(fwd,"FF\r");
                    fwd->seq = SEQ_FBB_RCV_BID;
		}
	    }
            break;
	default:
	    break;
    }
}

int mkbidlist(fwd)
struct stfwdcb *fwd;
{
    struct stmail_ele mail_ele;
    FILE *fp;
    int i,n;
    char buf[256];

    for (i = 0; i < fwd->sndcnt; i++) {
	if ((fp = fopen(fwd->snd[i].fname,"r")) == NULL) {
	    fwd_error(fwd,ERR_FILE);
	    printf("FWD: ERROR: file open error[%s]\n",fwd->snd[i].fname);
	} else {
	    clr_mail_ele(&mail_ele);
	    n = 0;
	    while(fgets(buf,256,fp)) {
		if (n == 0) {
		    get_mail_ele_rli(&mail_ele,buf);
		} else if (ck_ex(buf)) {
		    break;
		} else {
		    mail_ele.size += strlen(buf)+1;
		}
		n++;
	    }
	    fclose(fp);
	    strcpy(fwd->snd[i].bid,mail_ele.bid);
	    put_mail_ele_fbb(&mail_ele,buf);
	    if (fwd->type == T_FBB_BIN) {
	        memcpy(buf,"FA",2);
	    } else {
	        memcpy(buf,"FB",2);
	    }
	    sprintf(fwd->snd[i].bidlist,"%s\r",buf);
	    printf("FWD: %d %s\n",i,fwd->snd[i].bidlist);
	}
    }
}

/*
 * < cksum_snd_bidlist > calc cksum send bidlist
 */
u_char cksum_snd_bidlist(fwd)
struct stfwdcb *fwd;
{
    int    i;
    char   *p;
    u_char cksum;

    cksum = 0;
    for (i = 0; i < fwd->sndcnt; i++) {
        p = fwd->snd[i].bidlist;
	while(*p) {
	    cksum += *p++;
	}
    }
    return((0x00-cksum)&0xff);
}

/*
 * < cksum_rcv_bidlist > calc cksum rcv bidlist
 */
u_char cksum_rcv_bidlist(fwd)
struct stfwdcb *fwd;
{
    int    i;
    char   *p;
    u_char cksum;

    cksum = 0;
    for (i = 0; i < fwd->rcvcnt; i++) {
        p = fwd->rcv[i].bidlist;
	while(*p) {
	    cksum += *p++;
	}
    }
    return((0x00-cksum) & 0xff);
}

/*
 * < fbb_rcv_status > rcv status
 */
int fbb_rcv_status(fwd)
struct stfwdcb *fwd;
{
    BOOL ckfs();
    int  cnv_out2xul();

    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
	fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    set_timeout(fwd);
	    fwd_get_init(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
		if (ckfs(fwd)) {
		    fwd->seq = SEQ_FBB_SND_MSG;
		} else {
		    fwd_error(fwd,ERR_SYNTAX);
		    fwd->seq = SEQ_DISC_REQ;
		}
		cnv_out2xul(fwd);
	        fwd_get_init(fwd);
	    }
	    break;
	default:
	    break;
    }
}

BOOL ckfs(fwd)
struct stfwdcb *fwd;
{
    char c,*p;
    int i;

    p = strtok(fwd->buf," \n\r\t");
    if (!EQ(p,"FS"))
        return(OFF);
    p = strtok(NULL," \n\r\t");
    if (p == NULL)
        return(OFF);
    for (i = 0; i < fwd->sndcnt; i++) {
        c = *p++;
	fwd->snd[i].stat = c;		/* +,-,= */
    }
    return(ON);
}

/*
 * < fbb_snd_msg >
 */
int fbb_snd_msg(fwd)
struct stfwdcb *fwd;
{
    int cntsndmsg();
    int mksndmsg(),mksndbinmsg();

    struct stax25cb *ax25;
    int i,c;
    char buf[256];

    switch(fwd->sub_seq) {
        case 0:
	    if (cntsndmsg(fwd) == 0) {
	        fwd->seq = SEQ_FBB_RCV_BID;
		break;
	    }
	    if (fwd->type == T_FBB_BIN) {
	        mksndbinmsg(fwd);
	    } else {
	        mksndmsg(fwd);
	    }
	    set_timeout(fwd);
	    fwd->sub_seq++;
	    break;
	case 1:
	    if ((fwd->fp = fopen(fwd->fname,READ_BIN)) == NULL) {
		fwd_error(fwd,ERR_FILE);
	        assert(0);
	    }
	    fwd->sub_seq++;
	    break;
	case 2:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
	        fclose(fwd->fp);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    ax25 = fwd->ax25;
	    if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
		fwd->seq = SEQ_DISC;
		break;
	    }
	    if (cntq(&ax25->sndifrm) > 10) {
	        break;
	    }
	    for (i = 0; i < ax25->paclen; i++) {
	        c = fgetc(fwd->fp);
		if (c == EOF) {
		    fwd->sub_seq++;
		    break;
		}
		buf[i] = c;
	    }
	    fwd_putn(fwd,buf,i);
	    set_timeout(fwd);
	    break;
	case 3:
	    fclose(fwd->fp);
	    fwd->seq = SEQ_FBB_RCV_BID;
	    break;
	default:
	    break;
    }
}

int cntsndmsg(fwd)
struct stfwdcb *fwd;
{
    int i,n;

    n = 0;
    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '+')
	    n++;
    }
    return(n);
}

int mksndmsg(fwd)
struct stfwdcb *fwd;
{
    FILE *fp,*fp2;
    char buf[256];
    int i,n,t;

    strcpy(fwd->fname,"SNDMSG.TMP");
    if ((fp2 = fopen(fwd->fname,WRITE_BIN)) == NULL) {
        fwd_error(fwd,ERR_FILE);
        assert(0);
    }
    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '+') {
	    printf("FWD: send[%s]\n",fwd->snd[i].fname);
            if ((fp = fopen(fwd->snd[i].fname,"r")) == NULL) {
		fwd_error(fwd,ERR_FILE);
	        assert(0);
	    } else {
	        n = 0;
	        while(fgets(buf,256,fp)) {
		    if (n != 0) {
		        if (ck_ex(buf)) {
			    break;
			}
			t = strlen(buf)-1;
			if (buf[t] == '\n') {	    /* LF -> CR */
			    buf[t] = '\r';
			}
			fwrite(buf,strlen(buf),1,fp2);
		    }
		    n++;
	        }
	       fclose(fp);
            }
	    fwrite("\x1a\r",2,1,fp2); /* CTRL_Z,CR */
	}
    }
    fclose(fp2);
}

/*
 * < mksndbinmsg > make send binary message
 */
int mksndbinmsg(fwd)
struct stfwdcb *fwd;
{

    FILE *fp,*fp1,*fp2;
    u_char cksum;
    char buf[256];
    int i,c,n,len;

    strcpy(fwd->fname,"SNDBIN.TMP");

    if ((fp2 = fopen(fwd->fname,WRITE_BIN)) == NULL) {
	fwd_error(fwd,ERR_FILE);
        assert(0);
    }
    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '+') {
	    printf("FWD: send[%s]\n",fwd->snd[i].fname);
            if ((fp = fopen(fwd->snd[i].fname,"r")) == NULL) {
		fwd_error(fwd,ERR_FILE);
	        assert(0);
	    } else {
		if ((fp1 = fopen("SNDTXT.TMP","w")) == NULL) {
		    fwd_error(fwd,ERR_FILE);
		    assert(0);
		}
	        n = 0;
	        while(fgets(buf,256,fp)) {
		    if (n == 0) {
		        ;
		    } else if (n == 1) {    /* Subject frame */
			del_eol(buf);
			fput_yapp_01(fp2,buf);
		    } else {		    /* data frame */
		        if (ck_ex(buf)) {
			    break;
			}
			fwrite(buf,strlen(buf),1,fp1);
		    }
		    n++;
	        }
	        fclose(fp);
		fclose(fp1);

		/* SNDTXT -> SNDARC */
		lzhuf2k_encode("SNDTXT.TMP", "SNDARC.TMP");

	        if ((fp = fopen("SNDARC.TMP","rb")) == NULL) {
		    fwd_error(fwd,ERR_FILE);
		    assert(0);
		    exit(1);
		}
		len = 0;
	        cksum = 0;
		while((c = fgetc(fp)) != EOF) {
		    buf[len++] = c;
		    cksum += c;
		    if (len >= 128) {
		        fput_yapp_02(fp2,buf,len);
			len = 0;
		    }
		}
		if (len > 0) {
		    fput_yapp_02(fp2,buf,len);
		}
		fput_yapp_04(fp2,cksum);
		fclose(fp);
            }
	}
    }
    fclose(fp2);
}

/*
 * < fbb_rcv_bidlist >
 */
int fbb_rcv_bidlist(fwd)
struct stfwdcb *fwd;
{
    int entry_out_bid(),cnv_out2ul();

    char *p,buf[128];
    u_char cksum;
    int    r;
    struct stmail_ele mail_ele;
    struct stax25cb *ax25;

    ax25 = fwd->ax25;

    if (ax25->status == S1) {
        fwd_error(fwd,ERR_LINKOUT);
        fwd->seq = SEQ_DISC;
	return;
    }
    switch(fwd->sub_seq) {
        case 0:
	    set_timeout(fwd);
	    fwd_get_init(fwd);
	    fwd->rcvcnt = 0;
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fwd->seq = SEQ_DISC_REQ;
		break;
	    }
	    if (fwd_gets(fwd)) {
	        if (fwd->rcvcnt == 0) {
		    entry_out_bid(fwd);	    /* BID entry   */
		    cnv_out2ul(fwd);	    /* .OUT -> .UL */
		    fwd->sndcnt = 0;
		}
		if (EQ(fwd->buf,"FQ\r")) {
		    fwd->seq = SEQ_DISC_REQ;
		} else if (EQ(fwd->buf,"FF\r")) {
		    fwd->f_msg_empty = ON;
                    fwd->seq = SEQ_FBB_SND_BID;
		} else if (memcmp(fwd->buf,"FA",2) == 0) {
		    r = get_mail_ele_fbb(&mail_ele,fwd->buf);
		    if (r == NG || fwd->rcvcnt >= MAXBIDLST) {
		        fwd_error(fwd,ERR_SYNTAX);
		        fwd->seq = SEQ_DISC_REQ;
		    } else {
		        strcpy(fwd->rcv[fwd->rcvcnt].bidlist,fwd->buf);
		        fwd->rcvcnt++;
		    }
		} else if (memcmp(fwd->buf,"FB",2) == 0) {
		    r = get_mail_ele_fbb(&mail_ele,fwd->buf);
		    if (r == NG || fwd->rcvcnt >= MAXBIDLST) {
		        fwd_error(fwd,ERR_SYNTAX);
		        fwd->seq = SEQ_DISC_REQ;
		    } else {
		        strcpy(fwd->rcv[fwd->rcvcnt].bidlist,fwd->buf);
		        fwd->rcvcnt++;
		    }
		} else if (memcmp(fwd->buf,"F>",2) == 0) {
		    strcpy(buf,fwd->buf+2);
		    p = strtok(buf," \n\r\t");
		    if (p != NULL) {		/* check sum ? */
		        cksum = strtoul(p,NULL,16);
			if (cksum == cksum_rcv_bidlist(fwd)) {
			    printf("FWD: checksum ok\n");
		            fwd->seq = SEQ_FBB_SND_STAT;
			} else {
			    log_printf("ERR: checksum error[%02X]",cksum);
			    fwd_error(fwd,ERR_CKSUM1);
			    fwd->seq = SEQ_DISC_REQ;
			}
		    } else {
		        fwd->seq = SEQ_FBB_SND_STAT;
		    }
		}
		fwd_get_init(fwd);
	    }
	    break;
        default:
	    break;
    }
}

int cnv_out2xul(fwd)
struct stfwdcb *fwd;
{
    char name1[32],name2[32];
    int i;

    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '-') {
	    strcpy(name1,fwd->snd[i].fname);
	    strcpy(name2,name1);
	    strcpy(strchr(name2,'.')+1,"XUL");
	    rename(name1,name2);
	}
    }
}

int cnv_out2ul(fwd)
struct stfwdcb *fwd;
{
    char name1[32],name2[32];
    int i;

    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '+') {
	    strcpy(name1,fwd->snd[i].fname);
	    strcpy(name2,name1);
	    strcpy(strchr(name2,'.')+1,"UL");
	    rename(name1,name2);

	    fwd->snd[i].stat = '-';
	}
    }
}

int entry_out_bid(fwd)
struct stfwdcb *fwd;
{
    char *p;
    int i;

    for (i = 0; i < fwd->sndcnt; i++) {
        if (fwd->snd[i].stat == '+') {
	    entry_bid(p = fwd->snd[i].bid);
	    log_printf("Send Msg [BID:%s]",p);
	}
    }
}

/*
 * < fbb_snd_status >
 */
int fbb_snd_status(fwd)
struct stfwdcb *fwd;
{
    struct stmail_ele mail_ele;
    char c,buf[32];
    int i;

    for (i = 0; i < fwd->rcvcnt; i++) {
        get_mail_ele_fbb(&mail_ele,fwd->rcv[i].bidlist);
	if (check_bid(mail_ele.bid) == OK) {
	    c = '+';
	} else {
	    c = '-';
	}
        fwd->rcv[i].stat = c;
    }

    strcpy(buf,"FS ");
    for (i = 0; i < fwd->rcvcnt; i++) {
        if (fwd->rcv[i].stat == '+') {
	    strcat(buf,"+");
	} else {
	    strcat(buf,"-");
	}
    }
    strcat(buf,"\r");
    fwd_puts(fwd,buf);

    fwd->seq = SEQ_FBB_RCV_MSG;
}
/*
 * < fbb_rcv_msg >
 */
int fbb_rcv_msg(fwd)
struct stfwdcb *fwd;
{
    int fbb_rcv_txtmsg(),fbb_rcv_binmsg();

    if (fwd->type == T_FBB_BIN) {
        fbb_rcv_binmsg(fwd);
    } else {
        fbb_rcv_txtmsg(fwd);
    }
}

/*
 * < fbb_rcv_txtmsg >
 */
int fbb_rcv_txtmsg(fwd)
struct stfwdcb *fwd;
{
    struct stmail_ele mail_ele;
    struct stax25cb *ax25;
    char buf[256];

    ax25 = fwd->ax25;
    switch(fwd->sub_seq) {
        case 0:
	    fwd->rcvcur = 0;
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (fwd->rcv[fwd->rcvcur].stat == '+') {
	        set_timeout(fwd);
	        fwd_get_init(fwd);
	        fwd->sub_seq++;
	    } else {
	        fwd->sub_seq = 4;
	    }
	    break;
	case 2:					/* subject */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
	        fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_gets(fwd)) {
	        if ((fwd->fp = fopen("RCVMSG.TMP","w")) == NULL) {
	            assert(0);
	            exit(1);
	        }
		get_mail_ele_fbb(&mail_ele,fwd->rcv[fwd->rcvcur].bidlist);
		put_mail_ele_rli(&mail_ele,buf);
		fprintf(fwd->fp,"%s\n",buf);

		fix_cr(fwd->buf);
		fprintf(fwd->fp,"%s",fwd->buf);
	        fwd_get_init(fwd);
		set_timeout(fwd);
		fwd->sub_seq++;
	    }
	    break;
	case 3:					/* body */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fclose(fwd->fp);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_gets(fwd)) {
		if (EQ(fwd->buf,"\x1a\r")) {	/* CTRL_Z,CR */
		    fprintf(fwd->fp,"/EX\n");
		    fclose(fwd->fp);
		    append_file(MAIL_IN,"RCVMSG.TMP");
		    get_mail_ele_fbb(&mail_ele,fwd->rcv[fwd->rcvcur].bidlist);
		    entry_bid(mail_ele.bid);
		    fwd->sub_seq++;
	        } else {
		    fix_cr(fwd->buf);
		    fprintf(fwd->fp,"%s",fwd->buf);
		}
	        fwd_get_init(fwd);
		set_timeout(fwd);
	    }
	    break;

	case 4:
	    fwd->rcvcur++;
	    if (fwd->rcvcur == fwd->rcvcnt) {
	        fwd->seq = SEQ_FBB_SND_BID;
	    } else {
	        fwd->sub_seq = 1;
	    }
	    break;
	default:
	    break;
    }
}

/*
 * < fbb_rcv_binmsg >
 */
int fbb_rcv_binmsg(fwd)
struct stfwdcb *fwd;
{
    struct stmail_ele mail_ele;
    struct stax25cb *ax25;
    FILE *fp1,*fp2;
    int  i,len;
    char buf[256];

    ax25 = fwd->ax25;

    switch(fwd->sub_seq) {
        case 0:
	    fwd->rcvcur = 0;
	    fwd->sub_seq++;
	    break;
	case 1:
	    if (fwd->rcv[fwd->rcvcur].stat == '+') {
	        set_timeout(fwd);
	        fwd_get_init(fwd);
	        fwd->sub_seq++;
	    } else {
	        fwd->sub_seq = 4;
	    }
	    break;
	case 2:					/* subject */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
	        fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_get_yapp(fwd)) {
	        if (fwd->buf[0] != 0x01) {
		    log_printf("ERR: yapp 01 frame error");
		    fwd_error(fwd,ERR_YAPP01);
		    fwd->seq = SEQ_DISC_REQ;
		    break;
		}
		strncpy(fwd->rcvsubject,fwd->buf+2,80);
		printf("FWD: YAPP[01:sj=%s]\n",fwd->rcvsubject);
	        if ((fwd->fp = fopen("RCVARC.TMP","wb")) == NULL) {
	            assert(0);
	            exit(1);
	        }
	        fwd_get_init(fwd);
		set_timeout(fwd);
		fwd->checksum = 0;
		fwd->sub_seq++;
	    }
	    break;
	case 3:					/* body */
	    if (check_timeout(fwd,180)) {
	        fwd_error(fwd,ERR_TIMEOUT);
		fclose(fwd->fp);
	        fwd->seq = SEQ_DISC_REQ;
	        break;
	    }
            if (ax25->status == S1) {
		fclose(fwd->fp);
		fwd_error(fwd,ERR_LINKOUT);
                fwd->seq = SEQ_DISC;
	        break;
	    }
	    if (fwd_get_yapp(fwd)) {
		switch(fwd->buf[0]) {
		    case 0x02:		    /* data */
		        len = fwd->buf[1] & 0xff;
			if (len == 0) {	    /* length adjust */
			    len = 256;
			}
			for (i = 0; i < len; i++) {
			    fwd->checksum += fwd->buf[i+2];
			}
			fwrite(fwd->buf+2,len,1,fwd->fp);
			printf("FWD: YAPP[02:size=%d]\n",len);
			break;
		    case 0x04:		    /* check sum */
		        fclose(fwd->fp);
			printf("FWD: YAPP[04:checksum=%02x]\n",fwd->buf[1]);

		        if ((0x00-fwd->checksum) != fwd->buf[1]) {
			    log_printf("ERR: checksum error[%02x]",
				    (0x00-fwd->checksum));
			    fwd_error(fwd,ERR_CKSUM2);
			    fwd->seq = SEQ_DISC_REQ;
			    break;
			} else {
			    printf("FWD: checksum ok\n");
			}

		        get_mail_ele_fbb(&mail_ele,
				    fwd->rcv[fwd->rcvcur].bidlist);
		        put_mail_ele_rli(&mail_ele,buf);

			printf("%s\n",buf);
			printf("%s\n",fwd->rcvsubject);

			/* RCVARC ->RCVTXT */
			lzhuf2k_decode("RCVARC.TMP", "RCVTXT.TMP");

			if ((fp1 = fopen("RCVMSG.TMP","w")) == NULL) {
			    assert(0);
			}
			fprintf(fp1,"%s\n",buf);
			fprintf(fp1,"%s\n",fwd->rcvsubject);

			if ((fp2 = fopen("RCVTXT.TMP","r")) == NULL) {
			    assert(0);
			}
			while(fgets(buf,256,fp2) != NULL) {
			   fprintf(fp1,"%s",buf);
			}

			fclose(fp2);

			fprintf(fp1,"/EX\n");
			fclose(fp1);

			append_file(MAIL_IN,"RCVMSG.TMP");
		        get_mail_ele_fbb(&mail_ele,
			                 fwd->rcv[fwd->rcvcur].bidlist);
		        entry_bid(mail_ele.bid);

		        fwd->sub_seq++;
			break;
		    default:
		        fclose(fwd->fp);
		        log_printf("ERR: yapp 02,04 frame error[%02x]",
					    fwd->buf[0]);
			fwd_error(fwd,ERR_YAPP);
			fwd->seq = SEQ_DISC_REQ;
			break;
		}
	        fwd_get_init(fwd);
		set_timeout(fwd);
	    }
	    break;

	case 4:
	    fwd->rcvcur++;
	    if (fwd->rcvcur == fwd->rcvcnt) {
	        fwd->seq = SEQ_FBB_SND_BID;
	    } else {
	        fwd->sub_seq = 1;
	    }
	    break;
	default:
	    break;
    }
}

/* fnpefbb.c */
