/* fnpecmd.c 1994.6.22 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#include <time.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "pbkiss.h"
#include "ax25.h"

#include "fnpe.h"

extern VOID dspinfo();	    /* tpbcfg.c */

			    /* flags */
extern BOOL f_exit;	    /* tpb.c */
extern BOOL f_debug;
extern BOOL f_verbose,f_automode;
extern TINY mode;
extern BOOL f_man_up;		    /* tpbupld.c */
extern BOOL f_man_down;		    /* fnpetpk.c */
extern struct stax25cb ax25cb;	    /* fwdfbb.c */

/*
 * < fnpe_cmd > command
 */
VOID fnpe_cmd()
{
    VOID dsphelp(),dsp_stat();

    int c;

    if (!kbhit())
        return;

    c = getch();
    switch(c) {
        case 'q': case 'Q': 
	    f_exit = ON;
	    break;
	case ('A'-0x40):
	    f_automode = f_automode ? OFF : ON;
	    dspinfo();
	    break;
	case ('X'-0x40):
	    f_hex = f_hex ? OFF : ON;
	    dspinfo();
	    break;
	case ('H'-0x40):
	    f_headers = f_headers ? OFF : ON;
	    dspinfo();
	    break;
	case ('K'-0x40):
	    f_ksslog = f_ksslog ? OFF : ON;
	    dspinfo();
	    ksslog(f_ksslog);
	    break;
	case ('V'-0x40):
	    f_verbose = f_verbose ? OFF : ON;
	    dspinfo();
	    break;
	case 'u': case 'U':
	    f_man_up = ON;	/* man upload request */
	    break;
	case 'd': case 'D':
	    f_man_down = ON;	/* man download request */
	    break;
	case 'i': case 'I':
	    dspinfo();
	    break;
	case 'h': case 'H': case '?':
	    dsphelp();
	    break;
	case 's': case 'S':
	    dsp_stat();
	    break;
	default:
	    break;
    }
}

VOID dsphelp()
{
    printf("--- Help ----------------------\n");
    printf("Q       Quit\n");
    printf("I       Info\n");
    printf("U       Upload\n");
    printf("D       Download\n");
    printf("S       Status\n");
    printf("ctrl-V  Verbose mode\n");
    printf("ctrl-X  HexDump mode\n");
    printf("ctrl-H  Header mode\n");
    printf("ctrl-K  KissLog mode\n");
    printf("H       Help\n");
    printf("-------------------------------\n");
}

VOID dsp_stat()
{

    printf("--- Status -----------------------------------\n");

    printf("AX25:S%d,T1:%d,T2:%d,T3:%d,RETRY:%d,V(S):%d,V(R):%d,WIN:%d,snd:%lu,rcv:%lu\n",
	ax25cb.status+1, ax25cb.tim_t1, ax25cb.tim_t2, ax25cb.tim_t3,
	ax25cb.retries, ax25cb.vs, ax25cb.vr, ax25cb.win,
	ax25cb.snd_byte,ax25cb.rcv_byte);

    printf("----------------------------------------------\n");
}

/* fnpecmd.c */
