/* fnpecfg.c 1994.5.21 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#include <time.h>
#include <sys\stat.h>

#include "pbdef.h"
#include "fnpe.h"
#include "tpb.h"
#include "pbkiss.h"
#include "pblib.h"

/* config data */

extern char cfgfile[];		    /* fnpe.c */
extern char bdcall[];
extern char bdadrs[];
extern char mycall[];
extern char myadrs[];
extern char mtcall[];		    /* fnpemtr.c */

extern char bbscall[];
extern char digicall[];
extern int digi;
extern int paclen,maxframe;
extern int protocol;

extern BOOL f_debug,f_verbose,f_automode;
extern BOOL f_etim;
extern clock_t tim_3;

extern char bid_file[];	    /* fnpebid.c */

/*
 * < fnpe_cfg > config
 */
int fnpe_cfg()
{
    FILE *fp;
    char buf[128];
    char *av1,*av2;
    int i;

    printf("Reading configuration file <%s>.\n",cfgfile);
    if ((fp = fopen(cfgfile,"r")) == NULL) {
        printf("Error: configuration file not found.\n");
	exit(1);
    }
    while(fgets(buf,128,fp) != NULL) {
	strupr(buf);
	av1 = strtok(buf," \t\r\n");
	if (av1 == NULL)
	    continue;
        av2 = strtok(NULL," \t\r\n");
	if (av2 == NULL)
	    continue;

	if (EQ(av1,"BDCSTCALL")) {
	    strcpy(bdcall,av2);
	    ca2ad(bdcall,bdadrs);
	    printf("OK bdcstcall [%s]\n",bdcall);

	} else if (EQ(av1,"BBSCALL")) {
	    strcpy(bbscall,av2);
	    printf("OK bbscall [%s]\n",bbscall);

	} else if (EQ(av1,"DIGICALL")) {
	    strcpy(digicall,av2);
	    printf("OK digicall [%s]\n",digicall);

	} else if (EQ(av1,"DIGI")) {
            digi = atoi(av2);
	    printf("OK digi [%d]\n",digi);

	} else if (EQ(av1,"MYCALL")) {
	    strcpy(mycall,av2);
	    ca2ad(mycall,myadrs);
	    printf("OK mycall [%s]\n",mycall);

	} else if (EQ(av1,"MTCALL")) {
	    strcpy(mtcall,av2);
	    printf("OK mtcall [%s]\n",mtcall);

	} else if (kiss_cfg(av1,av2)) {
	    ;

        } else if (EQ(av1,"PACLEN")) {
	    i = atoi(av2);
	    if (i < 3 || i > 255) {
	        printf("NG paclen[%d]\n",i);
	    } else {
	        paclen = i;
	        printf("OK paclen [%d]\n",paclen);
	    }

        } else if (EQ(av1,"MAXFRAME")) {
	    maxframe = atoi(av2);
	    printf("OK maxframe [%d]\n",maxframe);

        } else if (EQ(av1,"PORT")) {
	    port = atoi(av2) - 1;
	    printf("OK port [COM%d]\n",(int)port+1);

        } else if (EQ(av1,"DEBUG")) {
	    f_debug = atoi(av2);
	    printf("OK debug [%s]\n",f_debug ? "ON" : "OFF");

        } else if (EQ(av1,"VERBOSE")) {
	    f_verbose = atoi(av2);
	    printf("OK verbose [%s]\n",f_verbose ? "ON" : "OFF");

        } else if (EQ(av1,"HEX")) {
	    f_hex = atoi(av2);
	    printf("OK hex [%s]\n",f_hex ? "ON" : "OFF");

        } else if (EQ(av1,"HEADERS")) {
	    f_headers = atoi(av2);
	    printf("OK headers [%s]\n",f_headers ? "ON" : "OFF");

        } else if (EQ(av1,"KANJI")) {
	    f_kanji = atoi(av2);
	    printf("OK kanji [%s]\n",f_kanji ? "ON" : "OFF");

        } else if (EQ(av1,"AUTOMODE")) {
	    f_automode = atoi(av2);
	    printf("OK automode [%s]\n",f_automode ? "ON" : "OFF");

        } else if (EQ(av1,"XMITOK")) {
	    f_xmitok = atoi(av2);
	    printf("OK xmitok [%s]\n",f_xmitok ? "ON" : "OFF");

        } else if (EQ(av1,"BPQ")) {
	    f_bpq = atoi(av2);
	    printf("OK bpq [%s]\n",f_bpq ? "ON" : "OFF");

        } else if (EQ(av1,"KISSLOG")) {
	    f_ksslog = atoi(av2);
	    printf("OK kisslog [%s]\n",f_ksslog ? "ON" : "OFF");

        } else if (EQ(av1,"KISSIN")) {
	    strcpy(kssiname,av2);
	    f_kssin = ON;
	    printf("OK kissin [%s]\n",kssiname);

	} else if (EQ(av1,"BID_FILE")) {
	    strcpy(bid_file,av2);
	    printf("OK bid_file [%s]\n",bid_file);

        } else if (EQ(av1,"PROTOCOL")) {
	    protocol = atoi(av2);
	    printf("OK protocol [%d]\n",protocol);

	} else {
	    ;
	}
    }
    fclose(fp);
}

/*
 * < dspinfo > display info.
 */
VOID dspinfo()
{
    printf("--- Fwd-Net Protocol Engine info ----------------------------\n");
    printf("fnpe.exe version %s %s\n",FNPE_VER,FNPE_ID);
    printf("port: COM%d\n",port+1);
    if (f_debug)
        printf("DEBUG ");
    if (f_verbose)
        printf("Verbose ");
    if (f_hex)
        printf("hex ");
    if (f_headers)
        printf("Headers ");
    if (f_ksslog)
        printf("KissLog ");
    if (f_kssin)
        printf("Kissin ");
    if (!f_automode)
        printf("automode=0 ");
    if (!f_xmitok)
        printf("xmitok=0 ");
    printf("\n");
    printf("mycall: %s bbscall: %s\n",mycall,bbscall);
    printf("txd: %dmsec. multikiss: %d\n",txd,tncid);
    printf("paclen: %d maxframe: %d\n",paclen,maxframe);
    if (f_etim) {
        printf("exit timer: %ld\n",(long)tim_3);
    }
    printf("-------------------------------------------------------------\n");
}

/* fnpecfg.c */
