/* fnpe.h 1994.7.4 */

#define FNPE_VER "0.27"
#define FNPE_ID  "[19940704]"


/* SID */
#define AUTHOR_ID   "FNPE"
#define AUTHOR_DATA FNPE_VER

#define CTRL_Z	0x1a

#define MAXBIDLST  5
#define MAXLBUF    256

#define MAIL_IN  "mail.in"
#define FNPE_LOG "fnpe.log"

struct stfwdcb {	    /* fwd ctl block */
    struct stfwdcb *next;
    int task;

    int seq;
    int sub_seq;
    int sv_seq;
    struct stax25cb *ax25;  /* AX.25 link */
    char sid[32];	    /* your SID */
    int type;		    /* fwd type */
    int sndcnt;
    struct {
        char bidlist[128];
        char bid[32];
        char stat;
	char fname[32];
    } snd[MAXBIDLST];

    int rcvcur;
    int rcvcnt;
    struct {
        char bidlist[128];
        char bid[32];
        char stat;
	char fname[32];
    } rcv[MAXBIDLST];
    BOOL f_msg_empty;
    BOOL f_valid_call;
    char rcvsubject[128];    /* yapp 01 subject */
    u_char checksum;

    u_long msg_no;	    /* TPK #Msg */

    char fname[64];	    /* temp file */
    FILE *fp;

    char buf[512];	    /* get line */
    int buflen;

    clock_t t_timeout;
    clock_t t_logintime;
};

struct stmail_ele {	    /* mail element */
    char type;		    /* SP,SB */
    char to[7];
    char at[128];
    char from[7];
    char bid[32];
    long size;
    int  checksum;
};

/* fwd type */

#define T_RLI     0
#define T_FBB_TXT 1
#define T_FBB_BIN 2
#define T_FOS     3
#define T_TPK     4

/* FBB protocol */

#define FA 2
#define FB 3
#define FQ 4
#define FS 5
#define FF 6

#define SEQ_INIT         0
#define SEQ_IDOL         1
#define SEQ_SND_OPEN     2
#define SEQ_RCV_SID      3
#define SEQ_MAKE_LINK    4
#define SEQ_WAIT_PROMPT  5
#define SEQ_SND_SID      6

#define SEQ_FBB_SND_BID  10
#define SEQ_FBB_RCV_STAT 11
#define SEQ_FBB_SND_MSG  12
#define SEQ_FBB_RCV_BID  13
#define SEQ_FBB_SND_STAT 14
#define SEQ_FBB_RCV_MSG  15

#define SEQ_RLI_SND_BID    20
#define SEQ_RLI_RCV_STAT   21
#define SEQ_RLI_SND_MSG    22
#define SEQ_RLI_RCV_PROMPT 23
#define SEQ_RLI_SND_REV    24
#define SEQ_RLI_RCV_BID    25
#define SEQ_RLI_SND_STAT   26
#define SEQ_RLI_RCV_MSG    27
#define SEQ_RLI_SND_PMT    28

#define SEQ_TPK_SND_BID    30
#define SEQ_TPK_RCV_PROMPT 31
#define SEQ_TPK_SND_FCMD   32
#define SEQ_TPK_RCV_MSG    33

#define SEQ_DISC_REQ     40
#define SEQ_DISC         41

/* error code */

#define ERR_TIMEOUT	1
#define ERR_LINKOUT     2
#define ERR_LOGINOVER	3
#define ERR_FILE	4
#define ERR_SYNTAX	5
#define ERR_CKSUM1	6
#define ERR_CKSUM2	7
#define ERR_YAPP01	8
#define ERR_YAPP	9

/* function */
					    /* fnpe.c */
extern VOID log_printf(char*, ...);
					    /* fwdfbb.c */
extern BOOL check_fwd();

extern int  fwd_getc(struct stfwdcb*);
extern int  fwd_gets(struct stfwdcb*);
extern int  fwd_putn(struct stfwdcb*,char*,int);
extern int  fwd_puts(struct stfwdcb*,char*);
extern int  fwd_get_yapp(struct stfwdcb*);
extern VOID fwd_get_init(struct stfwdcb*);

extern BOOL ck_ex(char*);
extern int  append_file(char*,char*);
extern int  append_file_string(char*,char*);
extern int  copy_file(char*,char*);
extern char *head_file(char*,char*);
extern int  fix_cr(char*);
extern int  del_eol(char*);

extern int  clr_mail_ele(struct stmail_ele*);
extern int  get_mail_ele_rli(struct stmail_ele*,char*);
extern int  put_mail_ele_rli(struct stmail_ele*,char*);
extern int  get_mail_ele_fbb(struct stmail_ele*,char*);
extern int  put_mail_ele_fbb(struct stmail_ele*,char*);

extern BOOL check_timeout(struct stfwdcb*,int);
extern VOID set_timeout(struct stfwdcb*);
extern BOOL check_logintime(struct stfwdcb*,int);
extern VOID set_logintime(struct stfwdcb*);

extern VOID fwd_error(struct stfwdcb*,int);
extern VOID str_sid(char*,int);

extern BOOL check_bid(char*);
extern VOID entry_bid(char*);

/* fnpe.h */
