/* fnpe.c 1994.6.22 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <assert.h>
#include <io.h>
#include <time.h>

#include "pbdef.h"
#include "ax25.h"
#include "pbkiss.h"
#include "pblib.h"
#include "fnpe.h"

extern int  fnpe_cfg();			    /* fnpecfg.c  */
extern VOID fnpe_cmd();			    /* fnpecmd.c  */
extern VOID ini_fwd(),fwdfbb();		    /* fnpefbb.c  */
extern int  rcv_mtr();			    /* fnpemtr.c  */
extern void init_mtr(),exit_mtr();

extern int  ax25link();			    /* ax25lnk.c */

extern BOOL f_mon;			    /* pbkiss.c  */

/* config data */

char cfgfile[128] = {"fnpe.cfg"};

char bdcall[AXBUF];
char bdadrs[AXALEN];

char mycall[AXBUF];
char myadrs[AXALEN];

/* protocol type */
int protocol = T_FBB_BIN;

/* flags */
BOOL f_debug    = OFF;
BOOL f_exit     = OFF;
BOOL f_verbose  = OFF;
BOOL f_automode = OFF;

BOOL f_up_req   = OFF;
BOOL f_down_req = OFF;

FILE *fp_log;

clock_t tim_0,tim_1,tim_2,tim_3;    /* exit timer */
BOOL f_etim = OFF;
long exit_timer = 60*30;

/*
 * < main > main
 */
VOID main(argc,argv)
int argc;
char *argv[];
{
    VOID fnpe_main();

    int i;

    printf("*** Fwd-Net Protocol Engine for IBM-PC/PC-9801 ***\n");
    printf("    by Norimasa Okamoto\n");
    printf("    JN2LHU @ JN2BDS.19.JNET2.JPN.AS / AO-16\n");

    for (i = 1; i < argc; i++) {
        if (argv[i][0] == '-') {
	    switch(argv[i][1]) {
	        case 'v': case 'V': f_verbose = ON; break;
	        case 'h': case 'H': f_headers = ON; break;
	        case 'x': case 'X': f_hex     = ON; break;
		case 'q': case 'Q':
		    f_exit = ON;
		    break;

		case 'u': case 'U': f_up_req   = ON; break;
		case 'd': case 'D': f_down_req = ON; break;

		case 's': case 'S':
		    exit_timer = (clock_t)atol(&argv[i][2]);
		    f_etim = ON;
		    break;
		default:
		    if (strcmp(&argv[i][1],"debug") == 0) {
		        f_debug = ON;
		    }
		    break;
	    }
	} else {
	    strcpy(cfgfile,argv[i]);
	}
    }

    fnpe_cfg();

    fnpe_main();
}

/*
 * < fnpe_main >
 */
VOID fnpe_main()
{
    int log_start(),log_end();
    VOID timer();

    struct stframe *frame,*svframe;

    log_start();
    inikss();
    init_mtr();
    ini_fwd();

    printf("\nFwd-Net Protocol Engine Start!!!(Help=?,H)\n");

    timer();
    tim_3 = exit_timer;

    for (;;) {
        fnpe_cmd();

	timer();

	svframe = (struct stframe*)rkssfrm.head;

        rcv_mtr();

	ax25link();

	if (svframe == (struct stframe*)rkssfrm.head) {
	    frame = (struct stframe*)getq(&rkssfrm);
	    if (frame != NULL)
	        free(frame);
	}

	rcvkss();
	sndkss();

	fwdfbb();	    /* FWD FBB/RLI protocol */

	if (f_etim && tim_3 == 0) {
	    if (!check_fwd()) {
	        f_exit = ON;
	        if (f_verbose) {
	            printf("exit timer count up\n");
		}
	    }
	}

        if (f_exit) {
	    break;
	}
    }
    exit_mtr();
    exitkss();
    log_end();
}

/*
 * < timer > timer
 */
VOID timer()
{
    static clock_t t1;
    clock_t clk,t;

    clk = clock();
    t = clk - t1;
    t1 = clk;

    if ((u_long)tim_0 > (u_long)t) {
        tim_0 -= t;
    } else
        tim_0 = 0;

    if ((u_long)tim_1 > (u_long)t) {
        tim_1 -= t;
    } else
        tim_1 = 0;

    if ((u_long)tim_2 > (u_long)t) {
        tim_2 -= t;
    } else
        tim_2 = 0;

    if ((u_long)tim_3 > (u_long)t) {
        tim_3 -= t;
    } else
        tim_3 = 0;
}

/*
 * < log_start > log start
 */
int log_start()
{
    if ((fp_log = fopen(FNPE_LOG,"a")) == NULL) {
        printf("Error: log open error[%s]\n",FNPE_LOG);
    } else {
        printf("log start[%s]\n",FNPE_LOG);
	log_printf("Start %s %s",FNPE_VER,FNPE_ID);
    }
}

/*
 * < log_end > log end
 */
int log_end()
{
    if (fp_log) {
        printf("log end[%s]\n",FNPE_LOG);
	log_printf("End");
        fclose(fp_log);
    }
}

/*
 * < log_write > log wrtie
 */
int log_write(s)
char *s;
{
    time_t t;

    if (fp_log) {
        t = clock();
        fprintf(fp_log,"%-24.24s - %s\n",ctime(&t),s);
    }
}

/*
 * < log_printf > log printf
 */
VOID log_printf(char *format, ...)
{
    char buf[256];
    va_list arg;

    va_start(arg, format);
    vsprintf(buf, format, arg);
    va_end(arg);
    log_write(buf);

    printf("%s\n",buf);
}

/* fnpe.c */
