/* ax25.h 1994.4.20 */

#define	MAXDIGIS	1	/* Maximum number of digipeaters */
#define	ALEN		6	/* Number of chars in callsign field */
#define	AXALEN		7	/* Total AX.25 address length, including SSID */
#define	AXBUF		10	/* Buffer size for maximum-length ascii call */

/* Bits within SSID field of AX.25 address */
#define	SSID		0x1e	/* Sub station ID */
#define	REPEATED	0x80	/* Has-been-repeated bit in repeater field */
#define	E		0x01	/* Address extension bit */
#define	C		0x80	/* Command/response designation */

/* AX.25 Level 3 Protocol IDs (PIDs) */
#define PID_X25		0x01	/* CCITT X.25 PLP */
#define	PID_SEGMENT	0x08	/* Segmentation fragment */
#define PID_TEXNET	0xc3	/* TEXNET datagram protocol */
#define	PID_LQ		0xc4	/* Link quality protocol */
#define	PID_APPLETALK	0xca	/* Appletalk */
#define	PID_APPLEARP	0xcb	/* Appletalk ARP */
#define	PID_IP		0xcc	/* ARPA Internet Protocol */
#define	PID_ARP		0xcd	/* ARPA Address Resolution Protocol */
#define	PID_NETROM	0xcf	/* NET/ROM */
#define	PID_NO_L3	0xf0	/* No level 3 protocol */

#define	SEG_FIRST	0x80	/* First segment of a sequence */
#define	SEG_REM		0x7f	/* Mask for # segments remaining */

#define	AX_EOL		"\r"	/* AX.25 end-of-line convention */

/* Control field templates */
#define	I	0x00	/* Information frames */
#define	S	0x01	/* Supervisory frames */
#define	RR	0x01	/* Receiver ready     */
#define	RNR	0x05	/* Receiver not ready */
#define	REJ	0x09	/* Reject             */
#define	U	0x03	/* Unnumbered frames  */
#define	SABM	0x2f	/* Set Asynchronous Balanced Mode */
#define	DISC	0x43	/* Disconnect         */
#define	DM	0x0f	/* Disconnected mode  */
#define	UA	0x63	/* Unnumbered acknowledge */
#define	FRMR	0x87	/* Frame reject           */
#define	UI	0x03	/* Unnumbered information */
#define	PF	0x10	/* Poll/final bit         */

#define ERR_CTL 0xff

#define	MMASK	7	/* Mask for modulo-8 sequence numbers */

/* FRMR reason bits */
#define	W	1	/* Invalid control field */
#define	X	2	/* Unallowed I-field */
#define	Y	4	/* Too-long I-field */
#define	Z	8	/* Invalid sequence number */

#define CMD     1
#define RES     0

#define S1  0
#define S2  1
#define S3  2
#define S4  3
#define S5  4
#define S6  5
#define S7  6
#define S8  7
#define S9  8
#define S10 9
#define S11 10
#define S12 11
#define S13 12
#define S14 13
#define S15 14
#define S16 15

/*
 * AX.25 control block
 */
struct stax25cb {
    struct stax25cb *next;  /* next control block */

    TINY status;	    /* S1...S16 */
    BOOL f_start;	    /* Start */
    BOOL f_stop;	    /* Stop  */
    char myadrs[AXALEN];
    char yradrs[AXALEN];
    int  digi;
    char digiadrs[MAXDIGIS][AXALEN];
    TINY tncid;		    /* kiss id		*/
    TINY vr;		    /* V(R)		*/
    TINY vs;		    /* V(S)		*/
    TINY win;		    /* send window	*/
    BOOL f_sndreq;	    /* send request     */
    int  snd_ctl;	    /* send control code & command / P/F */
    int  snd_seq;	    /* send control seq */
    BOOL f_t1;		    /* timer T1 enable	*/
    int  tim_t1;	    /* timer T1		*/
    BOOL f_t2;		    /* timer T2 enable	*/
    int  tim_t2;	    /* timer T2		*/
    BOOL f_t3;		    /* timer T3 enable	*/
    int  tim_t3;	    /* timer T3		*/
    int  retries;	    /* Retry counter	*/
    struct stqueue rcvifrm; /* rcv I frame	*/
    struct stqueue sndifrm; /* snd I frame	*/

    BOOL f_conok;	    /* TNC parm conok      */
    BOOL f_fullduplex;	    /* TNC parm full       */
    TINY maxframe;	    /* TNC parm maxframe   */
    int  paclen;	    /* TNC parm paclen     */
    int  check;		    /* TNC parm check(sec) */
    int  retry;             /* TNC parm retry      */
    int  frack;		    /* TNC parm frack	   */

    u_long rcv_byte;	    /* rcv data byte */
    u_long snd_byte;	    /* snd data byte */

    TINY dreason;	    /* disconnect reason */
};

/*
 * Disconnecte Reasons
 */
#define DISC_LOCAL   1
#define DISC_REMOTE  2
#define DISC_TIMEOUT 3
#define DISC_BUSY    4

/*
 * event code
 */

#define E_ICP	    0
#define E_IC	    1
#define E_RRCP	    2
#define E_RRC	    3
#define E_REJCP	    4
#define E_REJC	    5
#define E_RNRCP	    6
#define E_RNRC	    7
#define E_SABM	    8
#define E_DISC	    9
#define E_RRRF	    10
#define E_RRR	    11
#define E_REJRF	    12
#define E_REJR	    13
#define E_RNRRF	    14
#define E_RNRR	    15
#define E_UA	    16
#define E_DM	    17
#define E_FRMR	    18
#define E_START	    19
#define E_STOP	    20
#define E_MBUSY	    21
#define E_YBUSY	    22
#define E_T1OUT	    23
#define E_T3OUT	    24
#define E_N2OVER    25
#define E_ILNS	    26
#define E_ILNR	    27
#define E_ILFR	    28
#define E_IDOL	    29

/* cmd / res */
#define _CMD	0x0100
#define _RES	0x0000

#define	RRc	(_CMD|RR)
#define	RNRc	(_CMD|RNR)

struct stevt {
    int ctl;	/* control */
    int status;	/* status  */
};

extern struct stevt evttbl[][16];

/* ax25.h */
