/*  parse.c - Parser for Report tool.
   This module is part of report.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
  

	Notes:  This was a quick grab from something else that was
		laying around, and has several hooks for things 
		which aren't actually here.  On the other hand, it
		does the job.  To add new commands, add the text to
		parse.h and a new case in doit() below.

*/


#include "parse.h"
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define promptlen 4;

int ars,ppoint,i;
unsigned int pnum;
int old_more;

char *token;
char buf[128];
int ctype;
int ltype;
int first_com_g;
      
int tflag,ok,eh;
#define true 1
#define false 0

enum ttypes { notoken,
	alftoken,
	numtoken,
	qmarktoken}  typtoken;

char oplist[] = " ?;\"";

FILE *fin, *fout;
int in_open = 0;
int out_open = 0;

extern char *strupr();
extern void report_rr(),report_raw(),report_circuit();
void pbreak(),doit(),end_report();
int start_report();

/* global defs */
char sel_call[11];
int sel_flag=0;
char sel_types[10]="CDFIT";
unsigned long recnum;

void
ptoken(buf)
char *buf;
{
	static char *start;
	char *s;

	if (buf != NULL)
		start = buf;

	token = strtok(buf, " \t\r\n");
	
	if (token == NULL) {
		typtoken = notoken;
		return;
	}

	ppoint = token - start;

	if (strcmp(token, "?") == 0) {
		typtoken = qmarktoken;
		return;
	}

	typtoken = alftoken;

	for (s = token; *s != '\0'; s++)
		if (!isdigit(*s))
			return;
			
	typtoken = numtoken;
	pnum = atoi(token);
}


void
pcom()
{
int match, looking, i;
        looking = true;
        ctype = 1+ (int) c_fnull ;
        while (comtext[ctype].c[0]!='\0' && (looking==1)) {
            match = true;
            i = 0;
            while ((i < strlen(token)) && (match==1)) {
               match = (toupper(token[i]) == comtext[ctype].c[i]);
                i++;
              }
            if (match==1) looking = false;
            else ctype++;
          }
      }

void
writedol(i)
int i;
{
 int j;
        i = i + promptlen;
        for (j=0;j<i;j++) printf(" ");
        printf("^");
}

void
writeeh(i)
int i;
{
        writedol(i);
        fprintf(stderr," Error");
	pbreak();
}

void
peh()
{
	eh=true;
	ok=false;
}

void
parse(flag,s)
int flag;			/* command line flag */
char *s;
{
	ok = true;
	eh = false;
	if (flag) 
	  strcpy (buf,s);
	else fgets(buf, 128, stdin);
	ars = strlen(buf);

        ptoken(buf);
	while ((ok) && (typtoken!=notoken)){
		if (typtoken==qmarktoken) {
			ctype=(int) c_help;
			doit();
			}
		else if ((typtoken==alftoken)||(typtoken==numtoken)) {
		        pcom();
          		if (ctype == (int) c_lnull) {
              			ok = false;
              			eh = true;
              			}
			else doit();
			}
		else {
			ok = false;
			eh = true;
			}
		if (ok) ptoken(NULL);
		else if (eh) writeeh(ppoint);
                }
}

void
pbreak()
{
	printf("\n");
}

void
doit()
{
int i = 0, j, k, ii;

        switch (ctype) {
	  case c_lnull:
		ok = false;
		eh = true;
		break;
		
	  case c_circuit:
		if (start_report()) break;
		report_circuit();
		end_report();
		break;
		
	  case c_help:
		ptoken(NULL);
 	        printf("Commands are:\n");
		i=(numcom)/8;
		k=1;
		for (j=0;j<i;j++) {
			for (ii=0;ii<8;ii++,k++) printf("%.8s ",comtext[k].c);
			printf("\n");
			}
		for (ii=0;ii<((numcom) % 8);ii++,k++)
			printf("%.8s ",comtext[k].c);
		printf("\n");
		break;

	  case c_input:
		ptoken(NULL);
		if (typtoken == alftoken || typtoken == numtoken) {
			if (in_open) {
				fclose(fin);
				in_open=0;
				}
			if ((fin = fopen(token,"r")) == NULL){
				perror("cannot open input file");
				return;
				}
			else in_open=1;
			}
		else peh();
		break;

	  case c_output:
		ptoken(NULL);
		if (typtoken == alftoken || typtoken == numtoken) {
			if (out_open && fout != stdout) {
				fclose(fout);
				out_open=0;
				}
			if ((fout = fopen(token,"w")) == NULL){
				perror("cannot open output file");
				return;
				}
			else out_open=1;
			}
		else peh();
		break;


	  case c_end:
	  case c_quit:
		if (out_open && fout != stdout){
  			if (fclose(fout)==EOF) {
				perror("Error closing output file");
				}
			}
		exit(0);
		break;

	  case c_rr:
		if (start_report()) break;
		report_rr();
		end_report();
		break;

	  case c_raw:
		ptoken(NULL);	
		if (typtoken==notoken) i=0;
		else if (toupper(*token)!='T') i=1;
		if (start_report()) break;
		report_raw(i);
		end_report();
		break;

	  case c_record:
		ptoken(NULL);
		if (typtoken==notoken) {
			printf("Record types selected: %s\n",sel_types);
			}
		else {
			strncpy(sel_types,token,sizeof(sel_types));
			sel_types[sizeof(sel_types)-1]='\0';
			strupr(sel_types);
			}
		break;

	  case c_select:
		ptoken(NULL);	
		if (typtoken==notoken) sel_flag=0;
		else {
			strcpy(sel_call,strupr(token));
			sel_flag=1;
			}
		break;

	  default: 
		fprintf(stderr,"*** internal error, parser default case\n");
		break;
	}
}

int start_report()
{
	if (!in_open) {
		if ((fin = fopen("LOG","r")) == NULL){
			perror("cannot open log file");
			return(1);
			}
		else in_open=1;
		}
	if (!out_open) fout=stdout;
	out_open=1;
	return(0);

}

void
end_report()
{
	rewind(fin);
	recnum=0;
}

