#define FALSE 0
#define TRUE (!FALSE)

/* Stats structure for keeping statistics. Cleared daily */
struct STAT_STRUCT {
	time_t LogTime			__attribute__ ((packed));
	/* n are simple counters */
	long nHolefills			__attribute__ ((packed));
	long nStartFile			__attribute__ ((packed));
	long nEndFile			__attribute__ ((packed));
	long nNoFile			__attribute__ ((packed));
	long nNoRoom			__attribute__ ((packed));
	long nNotOK			__attribute__ ((packed));
	/* nb are byte counters */
	long nbRequested		__attribute__ ((packed));
	long nbOverwrite		__attribute__ ((packed));
	long nbUnfresh			__attribute__ ((packed));
	long nbPfhErr			__attribute__ ((packed));
	long nbFopenErr			__attribute__ ((packed));
	long nbEnd			__attribute__ ((packed));
	long nbTransmitted		__attribute__ ((packed));
	/* nh are hole counters */
	long nhRequested		__attribute__ ((packed));
	long nDirReqs			__attribute__ ((packed));
	long nbDirTxd			__attribute__ ((packed));
	/* Ticks count time */
	long TicksDir			__attribute__ ((packed));	/* Version 2 and up */
	long TicksData			__attribute__ ((packed)); 	/* Version 2 and up */
	short nNewStns			__attribute__ ((packed));	/* New stations heard */
	/* Version 3 and up */
	long nbEof			__attribute__ ((packed));
	short nLongFile			__attribute__ ((packed));
};

int process(struct STAT_STRUCT *, short);
short GetVer(FILE *);
