#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <pwd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <linux/sockios.h>
#include <linux/if.h>
#include <linux/ax25.h>
#include <linux/rose.h>

#include "version.h"
#include "axconfig.h"

int main(int argc, char **argv)
{
	struct rose_ctl_struct rs_ctl;
	char *dev;
	int s;
	
	if (argc == 2 && strncmp(argv[1], "-v", 2) == 0) {
		printf("rsctl: %s\n", version);
		return 0;
	}

	if (argc < 4) {
		fprintf(stderr, "Usage: rsctl [-v] <lci> <port> -t1|-t2|-t3|-idle|-kill <parm>\n");
		return 1;
	}

	if (ax25_config_load_ports() == 0) {
		fprintf(stderr, "rsctl: no AX.25 ports configured\n");
		return 1;
	}

	if ((dev = ax25_config_get_dev(argv[2])) == NULL) {
		fprintf(stderr, "rsctl: invalid AX.25 port given\n");
		return 1;
	}

	rs_ctl.lci = atoi(argv[1]);
	strcpy(rs_ctl.dev, dev);
		
	if ((s = socket(AF_ROSE, SOCK_SEQPACKET, 0)) < 0) {
		perror("rsctl: socket");
		return 1;
	}

	if (strcmp(argv[3], "-kill") == 0) {
		rs_ctl.cmd = ROSE_KILL;
		rs_ctl.arg = 0;
	} else {
		if (argc < 5) {
			fprintf(stderr,"rsctl: parameter missing\n");
			return 1;
		}

		rs_ctl.arg = atoi(argv[4]);
		
		if (strcmp(argv[3], "-t1") == 0)
			rs_ctl.cmd = ROSE_T1;
		else if (strcmp(argv[3], "-t2") == 0)
			rs_ctl.cmd = ROSE_T2;
		else if (strcmp(argv[3], "-t3") == 0)
			rs_ctl.cmd = ROSE_T3;
		else if (strcmp(argv[3], "-idle") == 0)
			rs_ctl.cmd = ROSE_IDLE;
	}
	
	if (ioctl(s, SIOCRSCTLCON, &rs_ctl) != 0) {
		perror("rsctl: SIOCRSCTLCON");
		return 1;
	}
	
	return 0;
}

