#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <pwd.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <linux/sockios.h>
#include <linux/if.h>
#include <linux/ax25.h>
#include <linux/netrom.h>

#include "version.h"


int main(int argc, char **argv)
{
	struct nr_ctl_struct nr_ctl;
	int s;
	
	if (argc == 2 && strncmp(argv[1], "-v", 2) == 0) {
		printf("nrctl: %s\n", version);
		return 0;
	}

	if (argc < 4) {
		fprintf(stderr, "Usage: nrctl [-v] <index> <id> -t1|-t2|-t4|-idle|-n2|-paclen|-kill <parm>\n");
		return 1;
	}

	nr_ctl.index = atoi(argv[1]);
	nr_ctl.id    = atoi(argv[2]);
		
	if ((s = socket(AF_NETROM, SOCK_SEQPACKET, 0)) < 0) {
		perror("nrctl: socket");
		return 1;
	}

	if (strcmp(argv[3], "-kill") == 0) {
		nr_ctl.cmd = NETROM_KILL;
		nr_ctl.arg = 0;
	} else {
		if (argc < 5) {
			fprintf(stderr,"nrctl: parameter missing\n");
			return 1;
		}

		nr_ctl.arg = atoi(argv[4]);
		
		if (strcmp(argv[3], "-t1") == 0)
			nr_ctl.cmd = NETROM_T1;
		else if (strcmp(argv[3], "-t2") == 0)
			nr_ctl.cmd = NETROM_T2;
		else if (strcmp(argv[3], "-t4") == 0)
			nr_ctl.cmd = NETROM_T4;
		else if (strcmp(argv[3], "-idle") == 0)
			nr_ctl.cmd = NETROM_IDLE;
		else if (strcmp(argv[3], "-n2") == 0)
			nr_ctl.cmd = NETROM_N2;
	}
	
	if (ioctl(s, SIOCNRCTLCON, &nr_ctl) != 0) {
		perror("nrctl: SIOCNRCTLCON");
		return 1;
	}
	
	return 0;
}

