/* 
 *  convers.c
 *    Copyright (C) 1996 by Isao SEKI
 *       040796  I.SEKI  Created
 *       040996  I.SEKI  "err" flag was initalized by 0, for FreeBSD.
 *       960412  C.Makin Added defaults for host and port, added
 *                       channel on the command line and a requirement for
 *                       the callsign.
 *       041296  I.SEKI  Added screen refresh command, ^L.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <pwd.h>
#ifdef CURSES
#include "window.h"
#endif

char version[] = "convers for 4.3bsd. version 960412 by Isao SEKI (Carl Makin)\n\n";

int conv_session();
int debug = 0;

main(argc, argv)
  int argc;
  char *argv[];
{
    extern char *optarg;
    extern int optind;
    int c, port, sockfd, err=0;
    char call[16], buf[1024], chan[6];
    char *cp, *ch;
    struct hostent *hp;
    struct sockaddr_in serv_addr;
    FILE *fp;

    char host[255]="localhost\0";
    port=3600;
    err=1;
    while ((c = getopt(argc, argv, "dh:l:p:c:")) != -1) {
        switch (c) {
            case 'd':
                debug = 1;
                break;
            case 'h':
                strcpy(host, optarg);
                break;
            case 'l':
                strcpy(call, optarg);
		err=0;
                break;
            case 'c':
                strcpy(chan, optarg);
                break;
            case 'p':
                port = atoi(optarg);
                break;
            default:
                err++;
                break;
        }
    }

    if (err) {
        printf("usage: convers -l call [-d -h host -p port -c chan]\n");
        printf("\nRequired arguments\n");
        printf("       -l call      Your Amateur Callsign\n");
        printf("\nOptional arguments\n");
        printf("       -d           Debug\n");
        printf("       -h host      Hostname to connect to    (default is locahost)\n");
        printf("       -p port      Port number to connect to (default is 3600)\n");
        printf("       -c chan      Converse channel to enter (default is 0)\n");
	printf("\n\n");
        exit(1);
    }

    cp = call;
    ch = chan;
    if (*cp == NULL) {
        cp = getlogin();
        if (!cp)
            cp = getpwuid(getuid())->pw_name;
    }

    if (debug)
        printf("host: %s port: %d call: %s chan: %s\n", host, port, cp, ch);

    if ((hp = gethostbyname(host)) == NULL) {
        perror("gethostbyname");
        exit(1);
    }

    bzero((char *)&serv_addr, sizeof(serv_addr));
    bcopy(hp->h_addr, (char *)&serv_addr.sin_addr, hp->h_length);
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(port);
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket");
        exit(1);
    }

    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect");
        exit(1);
    }

    sprintf(buf, "/NAME %s %s\n", cp, ch);
    if (write(sockfd, buf, strlen(buf)) < 0) {
        perror("connect");
        exit(1);
    }

    sprintf(buf,"%s/.conversrc",getenv("HOME"));
    fp = fopen(buf,"r");
    if (fp != NULL) {
        while (fgets(buf, 2048, fp))
            if (buf[0] != '#') {
                if (write(sockfd, buf, strlen(buf)) < 0) {
                    perror("connect");
                    exit(1);
                }
            }
        fclose(fp);
    }

#ifdef CURSES
    cnvmkwin();
#endif

    conv_session(sockfd);
    close(sockfd);
    die();
}

int
conv_session(sfd)
int sfd;
{
    char sbuf[1024];
    char rbuf[1024];
    struct timeval tout;
    struct fd_set fdr;
    int i, x , y;
    char c;
    static char *ptr;
    static int j;
#ifdef CURSES
    cnvprnwin(version, strlen(version));
#else
    write(1,version,strlen(version));
#endif

    while(1) {
        if (!sfd)
            return(0);
        tout.tv_sec = 0;
        tout.tv_usec = 100000;
        FD_ZERO(&fdr);
        FD_SET(0,&fdr);
        FD_SET(sfd, &fdr);
        if (select(sfd+1, &fdr, NULL, NULL, &tout) > 0) {
            if (FD_ISSET(sfd, &fdr)) {
                i = read(sfd, sbuf, 1024);
                if (i == 0)
                    return(0);
                if (i > 0)
#ifdef CURSES
                    cnvprnwin(sbuf, i);
#else
                    write(1,sbuf,i);
#endif
            }
#ifdef CURSES
            if (FD_ISSET(0, &fdr)) {
                i = read(0, &c, 1);
                if (i > 0) {
                    if (!ptr) {
                        cnvreadwin(&c, 1);
                        ptr = (char *)malloc(1024);
                        *ptr = c; ptr++; j = 1;
                    } else if (c == 0x7f || c == 0x08) {
                        if (j > 0) {
                            getyx(win2, y, x);
                            wmove(win2, y, x-1);
                            wrefresh(win2);
                            *ptr = 0; ptr--; j--;
                        }
                    } else if (c == 0x0c) {
                        box(line_win, '-', '-');
                        wrefresh(line_win);
                        wrefresh(win1);
                        wrefresh(win2);
                    } else if (c == '\n') {
                        cnvreadwin(&c, 1);
                        *ptr = c; ptr= ptr - j;
                        write(sfd, ptr, j+1);
                        j = 0; free(ptr);
                    } else {
                        cnvreadwin(&c, 1);
                        *ptr = c; ptr++; j++;
                    }
                }
            }
#else
            if (FD_ISSET(0, &fdr)) {
                i = read(0, rbuf, 1024);
                if (i > 0)
                    write(sfd, rbuf, i);
            }
#endif
        }
    }
}
