#!/usr/bin/perl
#
$StatsDir = '/usr/lbbs/contrib/rstats/data';
$ExecTimeDiff = '/usr/lbbs/contrib/rstats/bin/difftime';

$first = 1;

while(<>) {
   chop;
   # This regexp should do to match an R: line with enough info.
   if(/^R\:(\d{6})\/(\d{4})[zZ]{0,1}\s+\d*\@[\:]{0,1}(\S+)/) {
      if($first == 0) {
         $system = $3;
         $time = "$1$2";
         
         if(!open(RESULT, "$ExecTimeDiff -f $1$2 -t $last_time |")) {
            # Invalidate
            $first = 1;
            next;
         }
         
         $result = <RESULT>;
         chop $result;
                  
         close(RESULT);

         &Update();
         
         $last_system = $system;
         $last_time = $time;
      } else {
         $last_system = $3;
         $last_time = "$1$2";
         $first = 0;
      }
   }
}

exit 0;

sub Update
{
   local($mystats[20]);
   local($found);
   local($cnt);
   local($pathname);
   local($tmpname);
   local(@STAT);
   local(@NEW);
   local($fsystem);

   # I was gonna (and want to) use the full HA for the file name, but...
   #  some bugger will come along and stick dots and slashes in it in an
   #  attempt to buffer something else up:
   #              R:950101/000000 @:../../spool/Qgb7mip
   # Like that and clobber someones Q file.   
   $last_system =~ /^([^\.]+)/;
   $fsystem = $1;
   
   $pathname = $StatsDir . "/" . "$fsystem";
   $tmpname = $StatsDir . "/" . "$fsystem" . ".tmp";

   if(!open(STAT, "$pathname")) {
      # Shitty open() schematics, I want open($pathname, O_RDWR|O_CREAT, umask) no O_TRUNC!
      if(!open(STAT, "+>$pathname")) {
         return;
      }
   }
   
   # If not, oh well for now!
   if(defined(&flock)) {
      flock(STAT, $LOCK_EX);
   }
   
   if(!open(NEW, ">$tmpname")) {
      close(STAT);
      return;
   }

   # PARANOIA?
   undef @stats;
   
   $found = 0;
   while(<STAT>) {
      chop;

      if(/^\s*${system}\s+/i) {
         $found = 1;
         last;
      } else {
         print NEW "$_\n";
      }
   }

   if($found == 1) {
      @stats = split(/\s+/);
   }

   if(int($result) < 0) {
      # - (minus) is a bad date (BBS may have incorrect time set) or something.
      $stats[28]++;
   } elsif(int($result) <= 60) {
      $stats[1]++;
   } elsif(int($result) <= 120) {
      $stats[2]++;
   } elsif(int($result) <= 180) {
      $stats[3]++;
   } elsif(int($result) <= 240) {
      $stats[4]++;
   } elsif(int($result) <= 300) {
      $stats[5]++;
   } elsif(int($result) <= 450) {
      $stats[6]++;
   } elsif(int($result) <= 600) {
      $stats[7]++;
   } elsif(int($result) <= 900) {
      $stats[8]++;
   } elsif(int($result) <= 1800) {
      $stats[9]++;
   } elsif(int($result) <= 2700) {
      # 1/2 Hour
      $stats[10]++;
   } elsif(int($result) <= 3600) {
      # 1 Hour
      $stats[11]++;
   } elsif(int($result) <= 5400) {
      # 1.5 Hours
      $stats[12]++;
   } elsif(int($result) <= 7200) {
      # 2 Hours
      $stats[13]++;
   } elsif(int($result) <= 9000) {
      # 2.5 Hours
      $stats[14]++;
   } elsif(int($result) <= 10800) {
      # 3 Hours
      $stats[15]++;
   } elsif(int($result) <= 14400) {
      # 4 Hours
      $stats[16]++;
   } elsif(int($result) <= (6 * 3600)) {
      # 6 Hours
      $stats[17]++;
   } elsif(int($result) <= (8 * 3600)) {
      # 8 Hours
      $stats[18]++;
   } elsif(int($result) <= (10 * 3600)) {
      # 10 Hours
      $stats[19]++;
   } elsif(int($result) <= (12 * 3600)) {
      # 12 Hours
      $stats[20]++;
   } elsif(int($result) <= (16 * 3600)) {
      # 16 Hours
      $stats[21]++;
   } elsif(int($result) <= (20 * 3600)) {
      # 20 Hours
      $stats[22]++;
   } elsif(int($result) <= (24 * 3600)) {
      # 24 Hours
      $stats[23]++;
   } elsif(int($result) <= (36 * 3600)) {
      # 36 Hours
      $stats[24]++;
   } elsif(int($result) <= (48 * 3600)) {
      # 48 Hours
      $stats[25]++;
   } elsif(int($result) <= (72 * 3600)) {
      # 72 Hours
      $stats[26]++;
   } else {
      # Longer
      $stats[27]++;
   }

   $stats[0] = $system;

   # Total
   $stats[29]++;

   $cnt = 0;
   while($cnt < 30) {
      if(defined($stats[$cnt])) {
         print NEW "$stats[$cnt] ";
      } else {
         print NEW "0 ";
      }
      $cnt++;
   }
   print NEW "\n";

   # Maybe more?
   if($found == 1) {
      while(<STAT>) {
         chop;
      
         if(/^\s*$system\s+/) {
            # How did we get this?  Loose it!
            next;
         } else {
            print NEW "$_\n";
         }
      }
   }
   
   close(NEW);
   
   rename($tmpname, $pathname);
   
   close(STAT);

   0;
}
