#!/usr/bin/perl
#
#	This is based on my shell script version from 18/04/1995.
#
#	This currently uses the 3rd field in the MGateway file, when it
#	 should really be using the 2nd.
#
#	Version 1.4	25/09/1995
#
#
#
# $Whoami is a check to see if I gatewayed it into Cnews, so no use in
#   Cnews gatewaying it back to us!  This should be the LBBS MySystem var.
$Whoami = 'G7LED';
# Default BBS distribution if no Distribution: line is given.
$DefaultAt = 'GBR';
# Setting this to 0, means that only news articles with a distinct
#  Distributions: header with "bbs" or "bbs.xxxxxx" in their list will
#  be gatewayed.  This allows the sender of the article to decide if
#  he/she wants it to be gatewayed, on a per article basis.
# If you set this to 1, then it will set the AT to $DefaultAt should not
#  explicit "bbs" distribution exist within the header.
$AllowNoDistributionHeader = 1;
#
##########################################################################
##### Nothing below should need changing (unless it needs fixing :-) #####
##########################################################################
#
$TmpBody = "/usr/lbbs/tmp/news" . $$;
$Prefix = "/usr/lbbs/spool/incoming/";
#$Prefix = "/usr/tmp/lbbs/";
# From the mail setup!
$CheckBBS = "/usr/lbbs/contrib/mail_from_sendmail/DB";
$CheckHA = "/usr/lbbs/contrib/mail_from_sendmail/HA";
$Log = "/usr/lbbs/tmp/news.log";
$GatewayFile = "/usr/lbbs/etc/Gateway";
$MGatewayFile = "/usr/lbbs/etc/MGateway";

while(<>) {
   chop;
   if(/^Newsgroups:\s+(.*)/i) {
      $Newsgroups = $_;
      $newsgroups = $1;
   } elsif(/^From:\s+(.*)/i) {
      $From = $_;
      $from = $1;
   } elsif(/^Date:\s+(.*)/i) {
      $Date = $_;
      $date = $1;
   } elsif(/^Subject:\s+(.*)/i) {
      $Subject = $_;
      $subject = $1;
   } elsif(/^Message-ID:\s+(.*)/i) {
      $Message_ID = $_;
      $message_ID = $1;
   } elsif(/^Path:\s+(.*)/i) {
      $Path = $_;
      $path = $1;
   } elsif(/^References:\s+(.*)/i) {
      $References = $_;
      $references = $1;
   } elsif(/^Distribution:\s+(.*)/i) {
      $Distribution = $_;
      $distribution = $1;
   } elsif(/^BBS-Reply-To:\s+(.*)/i) {
      $BBS_Reply_To = $1;
   } elsif(/^X-BBS-Reply-To:\s+(.*)/i) {
      $BBS_Reply_To = $1;
   } elsif(/^BBS-Message-ID:\s+(.*)/i) {
      $BBS_Message_ID = $1;
   } elsif(/^X-BBS-Message-ID:\s+(.*)/i) {
      $BBS_Message_ID = $1;
   } elsif(/^BBS-Newsgroups:\s+(.*)/i) {
      $BBS_Newsgroups = $1;
   } elsif(/^X-BBS-Newsgroups:\s+(.*)/i) {
      $BBS_Newsgroups = $1;
   } elsif(/^BBS-Gateway:\s+(.*)/i) {
      $BBS_Gateway = $1;
   } elsif(/^X-BBS-Gateway:\s+(.*)/i) {
      $BBS_Gateway = $1;
   } elsif(/^\s*$/) {
      last;
   }
}


if(defined($BBS_Newsgroups)) {
   $GatewayFromUsenet = 0;
   if(defined($BBS_Gateway)) {
      if($BBS_Gateway =~ /^\s*${Whoami}\s+/i) {
         &Log("  lbbs: $BBS_Message_ID (I gatewayed it!)");
         exit 0;
      }
   }
   $BBS_Newsgroups =~ /^\s*(\S+)\s+@\s+(\S+)\s+\<\s+(\S+)/;
   $Lbbs_To = $1;
   $Lbbs_At = $2;
   $Lbbs_From = $3;
} else {
#   print "Would have gated: $BBS_Message_ID $message_ID $From\n";
#   exit 1;

   $GatewayFromUsenet = 1;
   # Resolve the newsgroups header.
   @Groups = split(/,/, $newsgroups);
   
   if(!open(GATEWAY, $GatewayFile)) {
      die "No LBBS gateway file: $GatewayFile\n";
   }
   
   while(<GATEWAY>) {
      chop;
      if(/^\s*\;/) {
         next;
      } elsif(/^\s*(\S+)\s+(\S+)/) {
         @Gwgroups = split(/,/, $2);
         $Lbbs_To = $1;
         $found = 0;
gateway_done:
         foreach $i (@Groups) {
            foreach $j (@Gwgroups) {
               if("$i" eq "$j") {
                  $found = 1;
                  last gateway_done;
               }
            }
         }
         if($found == 0) {
            undef($Lbbs_To);
         } else {
            last;
         }
      }
   }
   
   close(GATEWAY);


   @Dist = split(/,/, $distribution);
   foreach $i (@Dist) {
      if($i =~ /^bbs\.(\S{1,6})/i) {
         $Lbbs_At = $1;
         $Lbbs_At =~ tr/a-z/A-Z/;
         last;
      } elsif($i =~ /^bbs$/i) {
         $Lbbs_At = $DefaultAt;
         last;
      } elsif($i =~ /^nts\.(\S{1,6})/i) {
         $Lbbs_At = $1;
         $Lbbs_At =~ tr/a-z/A-Z/;
         last;
      } elsif($i =~ /^nts$/i) {
         $Lbbs_At = $DefaultAt;
         last;
      }
   }
   if(!defined($Lbbs_At)) {
      if(defined($AllowNoDistributionHeader)) {
         $Lbbs_At = $DefaultAt;
      } else {
         &Log("Usenet: $Id (no Distributions: header with 'bbs' in it)");
         exit 0;
      }
   }
   

   if(!open(MGATEWAY, $MGatewayFile)) {
      die "No LBBS mgateway file: $MGatewayFile\n";
   }

   while(<MGATEWAY>) {
      local($save);
      local($regexpa);
      local($regexpb);

      chop;
      if(/^\s*\;/) {
         next;
      } elsif(/^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)/) {
         $regexpa = $1;
         $regexpb = $4;
         $save = $3;
#  &Log("Checking $regexpa with $from to set $save\n");
#         if($from =~ /$regexpa/)
         if("$from" eq "$regexpa") {
            $Lbbs_From = $save;
            last;
         }
# This is a hack for now...
         if($from =~ /$regexpb/) {
            $Lbbs_From = $save;
            last;
         }
      }
   }

   close(MGATEWAY);


   if(!open(CHECK, $CheckBBS)) {
      die "No Gatewaying User file: $CheckBBS\n";
   }
   
   while(<CHECK>) {
      chop;
      if(/^\s*#/) {
         next;
      } elsif(/^\s*${Lbbs_From}\s+(\S+)/i) {
         $Lbbs_FromAt = $1;
         $Lbbs_FromAt =~ tr/a-z/A-Z/;
#     print "New HA is: $At\n";
         last;
      }
   }
   
   close(CHECK);


   if(!defined($Lbbs_To)) {
      die "Lbbs_To: not setup\n";
   }
   if(!defined($Lbbs_From)) {
      die "Lbbs_From: not setup\n";
   }
   if(!defined($Lbbs_FromAt)) {
      die "Lbbs_FromAt: not setup\n";
   }
   if(!defined($Lbbs_At)) {
      die "Lbbs_At: not setup\n";
   }
   
   $year = (gmtime(time))[5];
   $month = (gmtime(time))[4] + 1;
   $day = (gmtime(time))[3];
   $hour = (gmtime(time))[2];
   $min = (gmtime(time))[1];
   
   $BBS_Reply_To = sprintf("R:%02d%02d%02d/%02d%02d @:%s LBBS", $year, $month, $day, $hour, $min, $Lbbs_FromAt);
}

if(defined($BBS_Message_ID)) {
   $BBS_Message_ID =~ /^\<(.*)\>/;
   $Id = $1;
}

if(defined($message_ID)) {
   if($message_ID =~ /\<(.*)\>/) {
      $Gw_Id = $1;
   }
}

if(defined($Path)) {
   $Path =~ /^Path:\s+([^\s\!]+)/i;
   $Peer = $1;
}

if(defined($Subject)) {
   $Lbbs_Subject = $subject;
}

# Filter out From: lines generated by them coming in via a BBS to IP gateway
#  without a T:.  I.e. anything ending in .nts for the hostname!
if(defined($From)) {
   if($From =~ /@.*\.nts/i) {
      undef($From);
   }
}

if(!open(OUT, "+>$TmpBody")) {
   print "ERROR: Can not create tmp file for body of message\n";
   exit 1;
}

print OUT "CB\n";
print OUT "T$Lbbs_To\n";
print OUT "F$Lbbs_From\n";
print OUT "A$Lbbs_At\n";
if(defined($Id)) {
   print OUT "I$Id\n";
}
if(defined($Gw_Id)) {
   print OUT "H$Gw_Id\n";
}
if(defined($Peer)) {
   print OUT "P$Peer\n";
}
print OUT "\n";

if(defined($Lbbs_Subject)) {
   print OUT "$Lbbs_Subject\n";
} else {
   print OUT " \n";
}

if(defined($BBS_Reply_To)) {
   print OUT "$BBS_Reply_To\n";
}

if(defined($Message_ID)) {
   print OUT "T:$Message_ID\n";
}
if(defined($From)) {
   print OUT "T:$From\n";
}
if(defined($References)) {
   print OUT "T:$References\n";
}
if(defined($Path)) {
   print OUT "T:$Path\n";
}
if(defined($Date)) {
   print OUT "T:$Date\n";
}


while(<>) {
   print OUT $_;
}


close(OUT);

$year = (gmtime(time))[5];
$month = (gmtime(time))[4] + 1;
$day = (gmtime(time))[3];
$hour = (gmtime(time))[2];
$min = (gmtime(time))[1];
$SpoolTo = sprintf("$Prefix%05d%02d%02d%02d", $$, $hour, $min, $sec);

if(rename($TmpBody, $SpoolTo)) {
   if($GatewayFromUsenet) {
      &Log("Usenet: $Lbbs_To @ $Lbbs_At < $Lbbs_From \$$Id");
   } else {
      &Log("  LBBS: $Lbbs_To @ $Lbbs_At < $Lbbs_From \$$Id");
   }
   exit 0;
} else {
   &Log("$Id *** Error");
   print "ERROR: Unable to rename message";
   exit 1;
}

exit 0;


sub Log {
   local($Msg) = $_[0];
   
   if(open(LOG, ">>$Log")) {
      print LOG "$Msg\n";
      close(LOG);
   }
}
