/* written by / modified from existing examples by Jukka Honkela /
** OH8HUC, fatal@ee.oulu.fi */

#include "beep.h"

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>
#include <linux/soundcard.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>


typedef struct {
	char * sinewave_buf;
	char * empty_buf;
	int buf_length;
	int speed, fd;
	int ditdah_pause, char_pause, row_pause, word_pause;
	double frequency;
} tita_t;
static tita_t t;
static int ex_pitch=560;


void close_bufs(tita_t * t)
{
	close(t->fd);
	free(t->sinewave_buf);
	free(t->empty_buf);
}
void generate_bufs(tita_t * t)
{
	int i;
	char ch;
	double a, b, inc = M_PI*t->frequency / 22050.0;

	if((t->sinewave_buf=(char*) malloc(10240)) == NULL) {
		fprintf(stderr, "Malloc error\n");
		exit(1); 
	}
	if((t->empty_buf=(char*) malloc(10240)) == NULL) {
		fprintf(stderr, "Malloc error\n");
		exit(1); 
	}

	for(a=0, i=0; a < 2*M_PI; a+=inc, i++) {
		b = 127.0 + sin(a) * 127.0;
		t->sinewave_buf[i] = (char) b;
		t->empty_buf[i] = (char) 127;
	}
	t->buf_length = i;
}


int internal_init()
{  
	char buffer[1024] = ""; 
	int i, j=44100;
	
	t.fd = open("/dev/dsp", O_WRONLY);
	if(t.fd <0) {
		fprintf(stderr, "/dev/dsp: %s\n", strerror(errno)); 
		return 1;
	}
	if(ioctl(t.fd, SNDCTL_DSP_SPEED, &j)) {
		printf("/dev/dsp: %s\n", strerror(errno));
		return 1;
	}
	return 0;
}

BeepInit ()
{
	t.speed = 100;
	t.frequency = ex_pitch;
	t.char_pause = t.speed * 3;
	t.ditdah_pause = t.speed;
	t.word_pause = t.speed * 9;
	t.row_pause = t.speed * 18;

	internal_init();

	generate_bufs(&t);

	return 0;
}


int
Beep (int time2, int volume, int tpitch)
{
	int i, j;
	int time;
	
	if(tpitch != ex_pitch) {
		ex_pitch = tpitch;
		t.frequency=tpitch;
		close_bufs(&t);
		internal_init();
		generate_bufs(&t);
	}

	time = 44.1 * time2 / t.buf_length; 
	
	if(volume > 0)
		for(i=0; i<time; i++)
			write(t.fd, t.sinewave_buf, t.buf_length);
	else
		for(i=0; i<time; i++)
			write(t.fd, t.empty_buf, t.buf_length);
	return 0;
}


int
BeepWait ()
{
	return 0;
}


int
BeepCleanup ()
{
	close_bufs(&t);
}


int
BeepResume ()
{
    return BeepInit();
}
