#include <stdio.h>
#include "yagi.h"

void usage_output(char *exefile)
{
		double Zo=Z0;        
		double H_max=H_MAX;
		double E_max=E_MAX;

		fprintf(stderr,"\nYagiUda antenna analysis programs, version %.2lf\n", version());
		fprintf(stderr,"Written by David Kirkby BSc MSc G8WRB (email:davek@medphys.ucl.ac.uk)\n");
		fprintf(stderr, "\nUSAGE: %s  [-hs] [-Z Zo] filename \n\n", exefile);
		fprintf(stderr, "Where options are:\n");
		fprintf(stderr, "   -c     Calculate sidelobe levels (slows program considerably).\n");
		fprintf(stderr, "   -e     Suppress calculation of 3dB E-plane BW.\n");
		fprintf(stderr, "   -h     Suppress calculation of 3dB H-plane BW.\n");
		fprintf(stderr, "   -s     Suppress diagnostic output\n");
		fprintf(stderr, "   -E     Max value for the angle to find the 3dB point. Min=90, max=180 \n          (default = %.3lf)\n", E_max);
		fprintf(stderr, "   -H     Max value for the angle to find the 3dB point. Min=0, max=90   \n          (default = %.3lf)\n", H_max);
		fprintf(stderr, "   -Z     Set characteristic impedance (default = %.3lf)\n", Zo);
}
