#include <stdio.h>
#include <string.h>
#include "yagi.h"

void read_yagi_data(char *one_line, char *input_filename, double *frequency, double *min_frequency, double *max_frequency, double *step_frequency, int driven , double **d, int parasitic, double **p, double *angular_step)
{
	FILE *ifp;
	int i;
	char	buf1 [MAX_LINE+1], junk [MAX_LINE+1];

	ifp=fopen(input_filename, "rt");
	if(ifp == NULL)
	{
		fprintf(stderr,"Sorry, cant find file:  %s\n", input_filename);
		exit(2);
	}

	/* Read one_line by one_line, looking for data on the elements */
	while(!feof(ifp))
	{
		fgets(buf1, MAX_LINE-1, ifp);

		if(strncmp(buf1,"STEP_FREQUENCY",14) == 0)  
		{
			sscanf(buf1,"%s %lf", junk, step_frequency);
			*step_frequency*=1e6;
		}
		if(strncmp(buf1,"MIN_FREQUENCY",13) == 0)  
		{
			sscanf(buf1,"%s %lf", junk, min_frequency);
			*min_frequency*=1e6;
		}
		if(strncmp(buf1,"MAX_FREQUENCY",13) == 0)  
		{
			sscanf(buf1,"%s %lf", junk, max_frequency);
			*max_frequency*=1e6;
		}
		if(strncmp(buf1,"ANGULAR_STEP",12) == 0)  
		{
			sscanf(buf1,"%s %lf", junk, angular_step);
		}
		if(strncmp(buf1,"FREQUENCY",9) == 0)  
		{
			sscanf(buf1,"%s %lf", junk, frequency);
			*frequency*=1e6;
		}
		if(strncmp(buf1,"DATA_PARASITIC",14) == 0)  
		{
			/*buf1+=14;*/
			for(i=1;i<=parasitic; ++i)
			{
				fgets(buf1, MAX_LINE-1, ifp);
				sscanf(buf1,"  %lf %lf %lf %lf",&p[i][X], &p[i][Y], &p[i][LENGTH], &p[i][DIAMETER] );
			}
		}
		if(strncmp(buf1,"DATA_DRIVEN",11) == 0)  
		{
			/*buf1+=11;*/ /* skip DATA_DRIVEN */
			for(i=1;i<=driven; ++i)
				sscanf(buf1+11, "%lf %lf %lf %lf %lf %lf\n", &d[i][X], &d[i][Y], &d[i][LENGTH], &d[i][DIAMETER], &d[i][VOLTAGE_R], &d[i][VOLTAGE_I]);
		}
	}

	fclose(ifp);
	if(*min_frequency > *max_frequency || *angular_step <= 0 || *step_frequency <=0.0 || *frequency <=0.0 )
	{
		fprintf(stderr,"Error in input file %s. Please check:\n", input_filename);
		fprintf(stderr,"FREQUENCY, MIN_FREQUENCY, MAX_FREQUENCY, STEP_FREQUENCY and ANGULAR_STEP\n");
		exit(1);
	}

}

