#include <stdio.h>
#ifdef linux
#include <stdlib.h>
#endif

#include <math.h>
#include <errno.h>
#include "yagi.h"
#include "verbose.h"

/* better.c This function compares new and old performance of a yagi to see if
its better. */ 

extern double vswr, Zo;
extern struct performance_data max;
extern int errno;
int is_it_better(int criteria,struct performance_data n, struct performance_data o) 
{
	double resistance_error;
	double ndiff, odiff;


if (0 != verbose) {
	printf("o=%.3lfdBi %.3lf dB  %.4lf:1\n", o.gain, o.fb, o.swr);
	printf("n=%.3lfdBi %.3lf dB  %.4lf:1\n", n.gain, n.fb, n.swr);
	printf("m=%.3lfdBi %.3lf dB  %.4lf:1\n\n", max.gain, max.fb, max.swr);
}

	/* If the user add REASONABLE to the 'better' argument, the program
	will make some intelligent guesses about whats a reasonale antenna. This
	could for example avoid ignoring an antenna with 20dB gain but 1.02:1
	vswr, in favour of 15dB gain but 1.01 vswr. Usually we would consider
	(all other things equal) the former antenna better. Hence we wont 
	bother optimising beyond these */

	if( (criteria & REASONABLE) == REASONABLE)
	{
		if (n.fb > max.fb && o.fb > max.fb)
		{
if (0 != verbose)
	printf ("   F/B over %f ignored: new %f old %f\n", max.fb, n.fb, o.fb);
			n.fb=o.fb; 
		}

		ndiff = fabs (n.r - Zo);
		odiff = fabs (o.r - Zo);
		if (ndiff < max.r && odiff < max.r)
		{
if (0 != verbose)
	printf ("   R error under %f ignored: new %f old %f\n", max.r, n.r, o.r);
			n.r=o.r;
		}

		if (n.swr < max.swr && o.swr < max.swr)
		{
if (0 != verbose)
	printf ("   SWR under %f ignored: new %f old %f\n", max.swr, n.swr, o.swr);
			n.swr=o.swr;
		}
	
		if (fabs(n.x) < max.x && fabs(o.x) < max.x)	
		{
if (0 != verbose)
	printf ("   X error under %f ignored: new %f old %f\n", max.x, n.x, o.x);
			n.x=o.x;
		}

		if (n.sidelobe > max.sidelobe && o.sidelobe > max.sidelobe)
		{
if (0 != verbose)
	printf ("   Lobe over %f ignored: new %f old %f\n", max.sidelobe, n.sidelobe, o.sidelobe);
			n.sidelobe=o.sidelobe;
		}


		/* Count this design as bad if any parameter pops back	*/
		/* outside the 'window' of reasonable values.  This	*/
		/* prevents X from taking off for a .01 db improvement	*/
		/* in gain.						*/

		if (n.fb < max.fb && o.fb > max.fb)
		{
if (0 != verbose)
	printf ("   F/B < %f bad: new %f old %f\n", max.fb, n.fb, o.fb);
			return FALSE;
		}

		if (ndiff > max.r && odiff < max.r)
		{
if (0 != verbose)
	printf ("   R error > %f bad: new %f old %f\n", max.r, n.r, o.r);
			return FALSE;
		}

		if (n.swr > max.swr && o.swr < max.swr)
		{
if (0 != verbose)
	printf ("   SWR > %f bad: new %f old %f\n", max.swr, n.swr, o.swr);
			return FALSE;
		}
	
		if (fabs(n.x) > max.x && fabs(o.x) < max.x)	
		{
if (0 != verbose)
	printf ("   X > %f bad: new %f old %f\n", max.x, n.x, o.x);
			return FALSE;
		}

		if (n.sidelobe < max.sidelobe && o.sidelobe > max.sidelobe)
		{
if (0 != verbose)
	printf ("   Lobe < %f bad: new %f old %f\n", max.sidelobe, n.sidelobe, o.sidelobe);
			return FALSE;
		}

	}


	/* Now do plain 'which one is better' checking.	*/

	if( (criteria & GAIN) == GAIN)
	{
		if( n.gain < o.gain) {
if (0 != verbose)
	printf ("   gain bad. old %f  new %f\n", o.gain, n.gain);
			return(FALSE);
		}
	}
	if( (criteria & FB) == FB)
	{
		if( n.fb < o.fb) {
if (0 != verbose)
	printf ("   FB bad. old %f  new %f\n", o.fb, n.fb);
			return(FALSE);
		}
	}
	if( (criteria & RESISTANCE) == RESISTANCE)
	{
		resistance_error = fabs(n.r - Zo) - fabs(o.r - Zo);
		if(resistance_error > 0) {
if (0 != verbose)
	printf ("   resistance_error bad. old %f  new %f\n", o.r, n.r);
			return(FALSE);
		}
	}
	if( (criteria & REACTANCE) == REACTANCE)
	{
		if(fabs(n.x) > fabs(o.x)) {
if (0 != verbose)
	printf ("   reactance bad. old %f  new %f\n", o.x, n.x);
			return(FALSE);
		}
	}
	if( (criteria & VSWR) == VSWR)
	{
		if( n.swr > o.swr) {
if (0 != verbose)
	printf ("   SWR bad. old %f  new %f\n", o.swr, n.swr);
			return(FALSE);
		}
	}
	if((criteria & SIDE_LOBE_LEVEL) == SIDE_LOBE_LEVEL)
	{
		if(n.sidelobe < o.sidelobe) {
if (0 != verbose)
	printf ("   Lobe bad. old %f  new %f\n", o.sidelobe, n.sidelobe);
			return(FALSE);
		}
	}
#ifdef DEBUG
	if(errno)
	{
	fprintf(stderr,"Errno =%d in better.c\n", errno);
	exit(1);
	}
#endif
if (0 != verbose)
	printf ("   better.c returning TRUE\n");

	return(TRUE);
}

