/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*----------------------------------------------------------------------*/
void l2init()
{
  WORD i;

  inithd(&rxfl);
  inithd(&stfl);
  inithd(&trfl);
  inithd(&freel);
  inithd(&l2frel);

  init_buffers();

  for (i = 0; i < L2PNUM; ++i) {
    inithd(&txl2fl[i]);
    inithd(&l2actl[i]);
  }

  for (i = 0, lnkpoi = lnktbl; i < LINKNMBR; ++i, ++lnkpoi)
  {
    lnkpoi->state = L2SDSCED;
    lnkpoi->rcvd = lnkpoi->tosend = 0;
    lnkpoi->zael = 1;                                     /* MultiConnect */
    inithd(&lnkpoi->rcvdil);
    inithd(&lnkpoi->sendil);
    inilbl();
    reslnk();
    relink((LEHEAD *)lnkpoi, (LEHEAD *)l2frel.tail);
  }

  iniDAMA();
}

/*----------------------------------------------------------------------*/
void sdfrmr(char ZYXW)
{
  char *frmrip;

  if (lnkpoi->state >= L2SIXFER) {
    frmrip = lnkpoi->frmr;
    *frmrip++ = rxfctl | rxfPF;
    *frmrip++ =   (lnkpoi->VR << 5)
                | (!rxfCR ? 0x10 : 0)
                | (lnkpoi->VS << 1);
    *frmrip   = ZYXW;
/***DEBUG***/
    notify(1,"Frame rejected %6.6s->%6.6s VS=%u ltxdNR=%u VR=%u lrxdNR=%u error=%u state=%u",
           lnkpoi->srcid, lnkpoi->dstid,
           lnkpoi->VS, lnkpoi->ltxdNR,
           lnkpoi->VR, lnkpoi->lrxdNR,
           ZYXW, lnkpoi->state);
/***DEBUG***/
    clrT1();                        /* Timer stoppen                    */
    clrT2();
    lnkpoi->RTT = 0;
    l2stma(stbl27);                 /* INVALID N(R) RECEIVED            */
  }
}

void autopar(int port)
{
  PORTINFO *p = portpar+port;
  UWORD    baud;                    /* Baudrate/100 auf dem Port        */
  UWORD    P;                       /* Persistance                      */
  UWORD    W;                       /* Slottime                         */
  UWORD    IRTT;                    /* Initial RTT                      */
  UWORD    T2;                      /* Timer2                           */
  UWORD    N2;                      /* Retry                            */
  BOOLEAN  l1update;

  /* T2 wird berechnet als die Lnge der Aussendung eines Frames bei
   * der eingestelten Baudrate + 10%.
   */
  baud = p->speed;

  T2 = 1;                           /* sehr schneller Link              */
  if ((baud != 0) && (baud < 2888))
    T2 = 2888 / baud;               /* sonst adaptiv nach Baudrate      */
  if (dama(port))
    T2 <<= 1;                       /* *2 bei DAMA nach DG3AAH          */

  /* Der IRTT wird auf T2*2 festgelegt, dies sollte immer
   * ausreichen, damit eine Antwort kommt. Es wird noch der TXDELAY
   * dazugerechnet, in der Annahme die Gegenstation habe etwa einen
   * gleich schnellen Transceiver.
   */
  IRTT = (T2 + p->txdelay) * 2;
  IRTT = max(10, IRTT);

  /* Der Retry ist 15 bei DUPLEX/CSMA und 5 bei DAMA.
   */
  N2 = DEF_N2;
  if (dama(port))
    N2 /= 2;

  /* P-PERSISTENCE
   * Bei DAMA und VOLLDUPLEX wird P immer auf 255 gesetzt.
   * Bei einem normalen Einstieg ohne DAMA oder Halb-Duplex
   * verwenden wir defaultmaessig P=160
   */
  P = 255;
  if ( !fullduplex(port) && !dama(port) )
    P = 160; /* Idee DB2OS und DG9FU */

  /* Als Slottime wird der aktuelle TX-Delay Wert genommen.
   */
  W = p->txdelay;
  if (W == 0)
    W++;

  l1update =    (P != p->persistance)
             || (W != p->slottime);

  p->persistance = P; /* Parameter neu setzen */
  p->slottime    = W;
  p->IRTT        = IRTT;
  p->T2          = T2;
  p->retry       = N2;

  if (l1update)                     /* neue L1-Parameter setzen         */
    l1ctl(L1CCMD, port);
}

void autopers(int port)
{
#if 0 /* DB2OS will es so ... */
  PORTINFO *p = portpar+port;
  UWORD    P;                       /* Persistance                      */
  BOOLEAN  l1update;

  /* Persistance wird berechnet als 255-(Anzahl der User)*10. Bei Vollduplex
   * und DAMA wird die Persistance immer auf 255 gesetzt.
   */
  P = 255;
  if ((p->nmbstn > 0) && !fullduplex(port) && !dama(port))
    if (p->nmbstn <= 15)
      P = 255-(p->nmbstn*10);
    else
      P = 100;

  l1update = (P != p->persistance);

  p->persistance = P;               /* Parameter neu setzen */

  if (l1update)                     /* neue L1-Parameter setzen         */
    l1ctl(L1CCMD, port);
#endif
}

/* End of L2E.C */
