/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

// keyboard_funcs.cpp

#include "keyboard_funcs.h"

void Keyboard_funcs::send_message(char message_number) {
    char* filename = new char[strlen(prog_func.filedir) + 10];
    if (!filename) {
        cerr << "Memory allocation error in Keyboard_controller::send_message(char)" << endl;
	exit(MEM_ERROR);
    }
    strcpy(filename, prog_func.filedir);
    strcat(filename, "/messages");

    message_file.open(filename, ios::in | ios::nocreate);
    if(!message_file) {
        PopupWin* popupwin_ptr = new PopupWin;
	if (!popupwin_ptr) {
	    cerr << "Memory allocation error in Keyboard_controller::send_message()" << endl;
	    exit(MEM_ERROR);
	}
        popupwin_ptr->show();
	popupwin_ptr->write(filename, 1, 5);
	popupwin_ptr->write("cannot be found or opened", 2, 5);
	popupwin_ptr->winrefresh();
	sleep(3);
	popupwin_ptr->unshow();
	delete popupwin_ptr;
	refresh_winlist(*screenform_ptr);
	message_file.clear();
    }
    else {
	char buffer[MESSAGE_SIZE + 1];
	int extracted = 0;
	int result = 0;
	while(!result && message_file.getline(buffer, MESSAGE_SIZE)) {
	    if (*buffer == '#' && *(buffer + 1) == message_number) {
	        // now get next line
	        if (message_file.getline(buffer, MESSAGE_SIZE) && (extracted = message_file.gcount()) > 0)  {
		    buffer[extracted - 1] = 0;  // null terminate last line extracted
		    result = 1;
		}
	    }
	}
	if (result) {
	    if (message_number == '0' || message_number > '5') {  // send a file
	        message_file.close();
		FilesendBuffer* filesend_ptr = new FilesendBuffer(FileBuffer::text,
		     tnc_ptr->tnc_func.active_stream(), tnc_ptr->tnc_func.active_port, tnc_ptr,
		      sendwin_ptr, receivewin_ptr, screenform_ptr);
		if (!filesend_ptr) {
		    cerr << "Memory allocation error in Keyboard_controller::send_message()" << endl;
		    exit(MEM_ERROR);
		}
		if (filesend_ptr->open_file(buffer, TRUE)) buffer_list_ptr->add(filesend_ptr);
		else delete filesend_ptr;
	    }
	    else {  // send the message in ./messages
	        int count = 0;
		int index;
		char letter;
		result = 0;

		do {
		    if (count) {  // terminate any former line with '\n'
		        wordwrap_buffer_add('\n');
		    }
		    buffer[--extracted] = 0;
		    for (index = 0; (letter = buffer[index]) != 0
			     && count < MESSAGE_SIZE && result != -1; index++, count++) {

		        if (tnc_ptr->tnc_func.active_port && (uchar)letter > 31) {
			    if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty
				|| tnc_ptr->tnc_func.hfmode == Tnc_func::fec
				|| tnc_ptr->tnc_func.hfmode == Tnc_func::amtor
				|| (tnc_ptr->tnc_func.hfmode == Tnc_func::gtor
				    && tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected)
				|| (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
				    && (tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected
					|| tnc_ptr->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor))) {
			        if (!is_baudot(letter)) letter = 0;
				else if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty) letter = toupper(letter);
			    }
			    else if (tnc_ptr->tnc_func.hfmode == Tnc_func::cw) {
			        if (!is_morse(letter) && letter != '$') letter = 0; // allow the $ token through
				else letter = toupper(letter);
			    }
			}

#if CHAR_SET==LATIN_1
			if ((uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
			if (((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
			if ((letter < 127 && letter > 31) || letter == '\n') {
#endif
			    if (letter == '$') {
			        int second_letter = buffer[index + 1];
				if (second_letter == 'a') {
				    for (char* letter_ptr = prog_func.myCall;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'a' code
				}
				else if (second_letter == 'b') {
				    for (char* letter_ptr = prog_func.mySelCall;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'b' code
				}
				else if (second_letter == 'c') {
				    for (char* letter_ptr = tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port];
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'c' code
				}
				else if (second_letter == 'd') {
				    time_t time_val;
				    time(&time_val);
				    tm* time_ptr = gmtime(&time_val);
				    ostrstream s1;
				    s1 << setfill('0') << setw(2) << time_ptr->tm_hour
				       << ":" << setw(2) << time_ptr->tm_min << ends;
				    char* time_string = s1.str();
				    for (char* letter_ptr = time_string;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    delete[] time_string;
				    index++; // get rid of the 'd' code
				}
				else if (second_letter == 'e') {
				    time_t time_val;
				    time(&time_val);
				    tm* time_ptr = gmtime(&time_val);
				    ostrstream s1;
				    char month[4];
				    get_month(month, time_ptr->tm_mon);
				    s1 << time_ptr->tm_mday << "-" << month  << "-"
				       << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
				    char* date_string = s1.str();
				    for (char* letter_ptr = date_string;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    delete[] date_string;
				    index++; // get rid of the 'e' code
				}
				else if (second_letter == 'f') {
				    for (char* letter_ptr = prog_func.rst;
					   result != -1 && *letter_ptr; letter_ptr++) {
				        result = wordwrap_buffer_add(*letter_ptr);
				    }
				    index++; // get rid of the 'f' code
				}
				else if (second_letter == 0) {  // last letter of line is a '$'
				    result = wordwrap_buffer_add('$');
				}
			    }
			    else {
			        result = wordwrap_buffer_add(letter);
			    }
			}
		    }
		} while (result != -1 && count < MESSAGE_SIZE && message_file.getline(buffer, MESSAGE_SIZE) &&
			 *buffer != '#' && *buffer != 0 && (extracted = message_file.gcount()) > 0);
		message_file.close();
	    }
	}
	else {  // no entry in ./messages for this message number
	    beep();
	    doupdate();
	    message_file.close();
	}
    }
    delete[] filename;
}


int Keyboard_funcs::wordwrap_buffer_add(uchar letter) {
    int return_val = letter;
    if (letter == ' ') {
        if (tr_buffer_ptr->letters_free() > wordwrap_buffer_count + 2) { // leave space for ' ' and possible '\n'
	    flush_wordwrap_buffer();
	    if (line_lettercount < WORDWRAP) {
		sendwin_ptr->write(' ');
		line_lettercount++;
		space_flag = TRUE;
	    }
	    else {
	        tr_buffer_ptr->add_letter('\n');
		sendwin_ptr->write('\n');
		line_lettercount = 0;
		space_flag = FALSE;
	    }
	    sendwin_ptr->winrefresh();
	}
	else {
	    beep();
	    doupdate();
	    return_val = -1;
	}
    }
    
    else if (letter == '\n') {
        if (tr_buffer_ptr->letters_free() > wordwrap_buffer_count + 2) { // leave space for '\n' and possible ' '
	    flush_wordwrap_buffer();
	    tr_buffer_ptr->add_letter('\n');
	    sendwin_ptr->write('\n');
	    sendwin_ptr->winrefresh();
	    line_lettercount = 0;
	    space_flag = FALSE;
	}
	else {
	    beep();
	    doupdate();
	    return_val = -1;
	}
    }

    else if (letter == 8) {
        if (line_lettercount) {
	    if (wordwrap_buffer_count) {
	        wordwrap_buffer_count--;
		line_lettercount--;
		sendwin_ptr->write(8);        // now erase letter from screen
		sendwin_ptr->write(32);
		sendwin_ptr->write(8);
		sendwin_ptr->winrefresh();
	    }
	    else if (space_flag) {
	        space_flag = FALSE;            // we cancel the space reserved to go before the word in wordwrap_buffer
		line_lettercount--;
		sendwin_ptr->write(8);        // now erase letter from screen
		sendwin_ptr->write(32);
		sendwin_ptr->write(8);
		sendwin_ptr->winrefresh();
	    }
	    else {
	        int result = tr_buffer_ptr->erase_letter();
		if (!result) {
		    beep();
		    doupdate();
		}
		else {
		    if (result == -1) {  // if last letter already extracted, and we are in pactor or gtor,
		                     // we need to send value 8 to the Kam
		        tr_buffer_ptr->add_letter(8);
		    }
		    line_lettercount--;
		    sendwin_ptr->write(8);        // now erase letter from screen
		    sendwin_ptr->write(32);
		    sendwin_ptr->write(8);
		    sendwin_ptr->winrefresh();
		}
	    }
	}
	else {
	    beep();
	    doupdate();
	    return_val = -1;
	}
    }

    else if (line_lettercount > WORDWRAP) {
        if (tr_buffer_ptr->letters_free() > wordwrap_buffer_count + 2) { // leave space for a '\n'
	    int index;
	    if (line_lettercount > wordwrap_buffer_count) { // check to see if the whole
			                                    // line is one word!
	        for (index = 0; index < wordwrap_buffer_count; index++) {
		    sendwin_ptr->write(8);
		    sendwin_ptr->write(32);
		    sendwin_ptr->write(8);
		}
		sendwin_ptr->winrefresh();
		tr_buffer_ptr->add_letter('\n');
		sendwin_ptr->write('\n');
		sendwin_ptr->winrefresh();
		line_lettercount = 0;
		space_flag = FALSE;
		for (index = 0; index < wordwrap_buffer_count; index++) {
		    sendwin_ptr->write(wordwrap_buffer[index]);
		    line_lettercount++;
		}
	    }
	    else {           // the whole line was one word - break it
	        flush_wordwrap_buffer();
	        tr_buffer_ptr->add_letter('\n');
		sendwin_ptr->write('\n');
		sendwin_ptr->winrefresh();
		line_lettercount = 0;
	    }
	    wordwrap_buffer[wordwrap_buffer_count++] = letter;
	    sendwin_ptr->write(letter);
	    sendwin_ptr->winrefresh();
	    line_lettercount++;
	}
	else {
	    beep();
	    doupdate();
	    return_val = -1;
	}
    }
    
    else {
        if (tr_buffer_ptr->letters_free() > wordwrap_buffer_count + 2) { // leave space for a possible ' '
	    wordwrap_buffer[wordwrap_buffer_count++] = letter;
	    sendwin_ptr->write(letter);
	    sendwin_ptr->winrefresh();
	    line_lettercount++;
	}
	else {
	    beep();
	    doupdate();
	    return_val = -1;
	}
    }
    return return_val;
}

void Keyboard_funcs::flush_wordwrap_buffer(void) {
    if (space_flag) tr_buffer_ptr->add_letter(' ');
    int index;
    for (index = 0; index < wordwrap_buffer_count; index++) {
        tr_buffer_ptr->add_letter(wordwrap_buffer[index]);
    }
    wordwrap_buffer_count = 0;
}

void Keyboard_funcs::run_connect_script(const char* script) {
// script has a default value of 0 (null pointer)

    if (script && connect_script_flag == not_running) {
        tnc_ptr->tnc_func.got_disconnect_flag = FALSE;
        script_file.open(script, ios::in | ios::nocreate);
	if (!script_file) {
	    PopupWin* popupwin_ptr = new PopupWin;
	    if (!popupwin_ptr) {
	        cerr << "Memory allocation error in Keyboard_controller::run_connect_script()" << endl;
		exit(MEM_ERROR);
	    }
	    popupwin_ptr->show();
	    popupwin_ptr->write(script, 1, 5);
	    popupwin_ptr->write("cannot be found or opened", 2, 5);
	    popupwin_ptr->winrefresh();
	    sleep(3);
	    popupwin_ptr->unshow();
	    delete popupwin_ptr;
	    refresh_winlist(*screenform_ptr);
	    script_file.clear();
	}
	else {
	    char buffer[257];
	    int firstline_flag = FALSE;
	    int count;
	    while (!firstline_flag && script_file.getline(buffer, 256)) {
	        if ((count = script_file.gcount()) > 1 && *buffer != '#') {  // # at start of line is a comment
		    buffer[--count] = 0;  // null terminate the string
		    firstline_flag = TRUE;
		}
	    }
	    if (!firstline_flag) {
	        PopupWin* popupwin_ptr = new PopupWin;
		if (!popupwin_ptr) {
		    cerr << "Memory allocation error in Keyboard_controller::run_connect_script()" << endl;
		    exit(MEM_ERROR);
		}
		popupwin_ptr->show();
		popupwin_ptr->write(script, 1, 5);
		popupwin_ptr->write("is empty - check the script", 2, 5);
		popupwin_ptr->winrefresh();
		sleep(3);
		popupwin_ptr->unshow();
		delete popupwin_ptr;
		refresh_winlist(*screenform_ptr);
		script_file.close();
	    }

	    else { 
	        char* commandmessage = new char[strlen(packet_connectCMD) + strlen(buffer) + 1];
		if (!commandmessage) {
		    cerr << "Memory allocation error in Keyboard_controller::run_connect_script()" << endl;
		    exit(MEM_ERROR);
		}
		strcpy(commandmessage, packet_connectCMD);
		strcat(commandmessage, buffer);
		tnc_ptr->send_kamcommand(commandmessage);
		delete[] commandmessage;
		connect_script_flag = running;
	    }
	}
    }

    // if we never made the initial connect 
    // cancel the attempt to run the script
    else if (connect_script_flag == running
	     && tnc_ptr->tnc_func.got_disconnect_flag
	     && tnc_ptr->tnc_func.disconnect_stream.port == tnc_ptr->tnc_func.active_port
	     && tnc_ptr->tnc_func.disconnect_stream.stream == tnc_ptr->tnc_func.active_stream()) {
        connect_script_flag = not_running;
	script_file.close();
    }

    else if (connect_script_flag == running
	     && tnc_ptr->tnc_func.stream_status[tnc_ptr->tnc_func.active_stream()]
	               [tnc_ptr->tnc_func.active_port] ==  Tnc_func::connected) {
        char buffer[256];
	char* buffer_ptr;
	int count;
        if ((tnc_ptr->get_packet_freebytes() > 256) && script_file.getline(buffer, 256)) {
	    if ((count = script_file.gcount()) > 1 && *buffer != '#') {  // # at start of line is a comment
	        buffer_ptr = buffer;
		int index;
		count--;
		for (index = 0; index < count; index++, buffer_ptr++) {
		    tr_buffer_ptr->add_letter(*buffer_ptr);
		    sendwin_ptr->write(*buffer_ptr);
		}
		tr_buffer_ptr->add_letter('\n');
		sendwin_ptr->write('\n');
		sendwin_ptr->winrefresh();
		usleep(100000);
	    }
	}
	if (!script_file) {              // finished sending script
	    script_file.close();
	    connect_script_flag = not_running;
	}
    }
}

void Keyboard_funcs::send_parms(const char* file) {
//file has a default value of 0
    if (send_parms_flag == Keyboard_funcs::not_running) {
        if (file) {
	    ostrstream s1;
	    s1 << prog_func.filedir << "/parms/" << file << ends;
	    char* filename = s1.str();
	    
	    parm_file.open(filename, ios::in | ios::nocreate);
	    if (!parm_file) {
	        PopupWin* popupwin_p = new PopupWin(6, 42, 10, Screen::get_ncols()/2 - 21);
		if (!popupwin_p) {
		    cerr << "Memory allocation error in Keyboard_funcs::send_parms()" << endl;
		    exit(MEM_ERROR);
		}
		popupwin_p->show();
		popupwin_p->write("File ", 1, 1);
		popupwin_p->write(filename);
		popupwin_p->write("cannot be found/opened", 2, 1);
		popupwin_p->write("Check that FILEDIR: in kamrc is correct", 3, 1);
		popupwin_p->winrefresh();
		sleep(3);
		popupwin_p->unshow();
		delete popupwin_p;
		refresh_winlist(*screenform_ptr);
		parm_file.clear();
	    }
	    else {
	        send_parms_flag = Keyboard_funcs::running;
		if (!strcmp(file, "tnc.parms")) { // if we are sending tnc.parms, set up myCall and mySelCall also
		    char* commandmessage;
		    int length = strlen(prog_func.myCall) + 8;
		    if (length < selCall_SIZE + 10) length = selCall_SIZE + 10;
		    if ((commandmessage = new char[length]) == 0) {
		        cerr << "Memory allocation error in Keyboard_funcs::sendparms()" << endl;
			exit(MEM_ERROR);
		    }
		    strcpy(commandmessage, "MYCALL ");
		    strcat(commandmessage, prog_func.myCall);
		    tnc_ptr->send_kamcommand(commandmessage);
		    usleep(200000);
		    strcpy(commandmessage, "MYSELCAL ");
		    strcat(commandmessage, prog_func.mySelCall);
		    tnc_ptr->send_kamcommand(commandmessage);
		    delete[] commandmessage;
		}
	    }
	    delete[] filename;
	}
	else {
	    receivewin_ptr->write("\nError in Keyboard_funcs::send_parms()");
	    receivewin_ptr->write("\nNo file open or file parameter passed()");
	    receivewin_ptr->write("\nPlease report to address in BUGS file\n");
	    receivewin_ptr->winrefresh();
	}
    }
    if (send_parms_flag == Keyboard_funcs::running) {
        char buffer[258];
	int count = 0;

// now keep going in a while loop until we get a line which isn't empty
// and isn't a comment(# at start of line is a comment)
	while(parm_file.getline(buffer, 256) && ((count = parm_file.gcount()) < 2  || *buffer == '#')) {}
	if (parm_file) { // we have a command
	    buffer[--count] = 0;   // null terminate the string
	    char* buffer_ptr = buffer; // get rid of any trailing comment
	    while(*buffer_ptr != 0 && *buffer_ptr != '#') buffer_ptr++;
	    if (*buffer_ptr == '#') {
	        *buffer_ptr = 0;
	    }
	    tnc_ptr->send_kamcommand(buffer);
	    usleep(200000);
	}
	else {  // we have sent all the commands in tnc.parms
	    parm_file.close();
	    parm_file.clear();
	    send_parms_flag = Keyboard_funcs::not_running;
	}
    }
}
