
/* Note - first three elements must be present and in the same order */

struct ALOG_1 {
	unsigned char event	__attribute__ ((packed));	/* event code */
	unsigned char len	__attribute__ ((packed));	/* length of entry */
	unsigned long tstamp	__attribute__ ((packed));	/* time stamp */
	unsigned short serial_no __attribute__ ((packed));	/* serial number */
	unsigned char rxchan	__attribute__ ((packed));	/* rx channel */
};


struct ALOG_1F {
	unsigned char event	__attribute__ ((packed));	/* event code */
	unsigned char len	__attribute__ ((packed));	/* length of entry */
	unsigned long tstamp	__attribute__ ((packed));	/* time stamp */
	unsigned short serial_no __attribute__ ((packed));	/* serial number */
	unsigned char rxchan	__attribute__ ((packed));	/* rx channel */
	unsigned long var1	__attribute__ ((packed));
	unsigned long var2	__attribute__ ((packed));
	unsigned long var3	__attribute__ ((packed));
	unsigned long var4	__attribute__ ((packed));
	unsigned long var5	__attribute__ ((packed));
	unsigned long var6	__attribute__ ((packed));

};

struct ALOG_2 {
	unsigned char event	__attribute__ ((packed));	/* event code */
	unsigned char len	__attribute__ ((packed));	/* length of entry */
	unsigned long tstamp	__attribute__ ((packed));	/* time stamp */
	unsigned short serial_no __attribute__ ((packed));	/* serial number */
	unsigned char rxchan	__attribute__ ((packed));	/* rx channel */
	unsigned char call[6]	__attribute__ ((packed));	/* callsign */
	unsigned char ssid	__attribute__ ((packed));	/* ssid */
};

struct ALOG_2F {
	unsigned char event	__attribute__ ((packed));	/* event code */
	unsigned char len	__attribute__ ((packed));	/* length of entry */
	unsigned long tstamp	__attribute__ ((packed));	/* time stamp */
	unsigned short serial_no __attribute__ ((packed));	/* serial number */
	unsigned char rxchan	__attribute__ ((packed));	/* rx channel */
	unsigned char call[6]	__attribute__ ((packed));	/* callsign */
	unsigned char ssid	__attribute__ ((packed));	/* ssid */
	unsigned long var1	__attribute__ ((packed));
	unsigned long var2	__attribute__ ((packed));
	unsigned long var3	__attribute__ ((packed));
	unsigned long var4	__attribute__ ((packed));
	unsigned long var5	__attribute__ ((packed));
	unsigned long var6	__attribute__ ((packed));
};



#define ALOG_FTL0_STARTUP 1		/* ftl0 startup */
#define ALOG_FTL0_SHUTDOWN 2		/* ftl0 shutdown */
#define ALOG_START_SESSION 3		/* user logon */
#define ALOG_CLOSE_SESSION 4		/* user logout */
#define ALOG_DISCONNECT 5		/* user timedout */
#define ALOG_USER_REFUSED 6		/* user refused (max sessions) */
#define ALOG_BCAST_START  7		/* added to list */
#define ALOG_BCAST_STOP 8		/* removed from list */
#define ALOG_DISKSPACE 9		/* free disk space */
#define ALOG_FILE_DELETE 10		/* file deleted */
#define ALOG_FILE_DOWNLOAD 11		/* file download */
#define ALOG_FILE_UPLOAD 12		/* file upload */
#define ALOG_BBS_SHUT 13		/* BBS is shut */
#define ALOG_BBS_OPEN 14		/* BBS is open */
#define ALOG_DIR 15			/* directory request */
#define ALOG_SELECT 16			/* Select */
#define ALOG_FILE_REMOVED 17 		/* Autodelete */
#define ALOG_FILE_NOT_REMOVED 18	/* Autodelete failed */
#define ALOG_END_DOWNLOAD 19		/* End of download */
#define ALOG_END_UPLOAD 20		/* End of download */
#define ALOG_END_DIR	21		/* end of downloading dir file */
#define ALOG_SELECT_DONE 22		/* End of select */

/* Disconnect reasons */
#define DC_TIMEOUT 1l
#define DC_IN_ULOK 2l
#define DC_IN_DLOK 3l
#define DC_IN_DLEND 4l
#define DC_IN_ULRX 5l
#define DC_UNKNOWN_PKT 6l
#define DC_PKT_TOO_BIG 7l

#define ALOG_FTYPE 0x0c			/* pfh file type */

unsigned write_alog(void *,int);

