/* SH/MOON */

#include "sun.h"

void sh_moon(int max_loc)
{
   int	loc,valid; 
   /* Grayline	grayline; */
   Moon		moon;
   char moonrise[8],moonset[8],moonaz[8],moonel[8];

   print_header(MOON,"");
   valid=0;
   for (loc=0;loc<max_loc;loc++)
   {
      switch(locations[loc].pref[0])
      {
      	case '#':
            print_not_in_database(locations[loc].name);
            break;
         case '?':
            print_enter_location(locations[loc].name);
            break;
         default:
            moon = moonrisetimes(locations[loc].loc.lat,locations[loc].loc.lon);
            strcpy (moonrise,min2tim(moon.rise));
            strcpy (moonset,min2tim(moon.set));
            sprintf(moonaz,"%5.1f",moon.az);
            sprintf(moonel,"%5.1f",moon.el);

            /* deaktiviert, da immer ein Ergebnis ermittelt wird,
               und wenn es auch am Vortag war.
            if (moon.rise<0)
               strcpy(moonrise,"--:--");
            if (moon.set<0)
               strcpy(moonset,"--:--");
            */

            /* printf("sh_moon: >>%s<< >>%s<<\n",moonrise,moonset); */
            print_moonrise_moonset(locations[loc].pref,locations[loc].name,
                        	moonrise,moonset,moonaz,moonel);
            valid++;
      }
   }
   print_foot(valid,MOON);
}

Azel moonpos(double x,double y, time_t tim)
{
	int d,m,yr,ya,m1,bz,b;
	double p1,pc,pd,l5,l6,j,t,t1,t2,d9,
		k1,k2,k3,k4,k5,k6,x1,x2,x3,x4,x5,
		l7,l8,d1,a2,a1,a,r1,l1,l,g,h,e;
        struct tm now;
	Azel mpos;

	p1 = M_PI;
	pc = p1/180.0;
	pd = 2.0*p1;

        /*
            Testdaten

	l5 = 51.65*pc;
	l6 = 0.1*pc;
        yr = 1983; m=12; d=31;
        b  = 2145;
        d9 = (b - ((int)(b/100)*100)) + (int)(b/100)*60;
        */ 

        l5 =  x*pc; /* x :  -90...90     Breite N positiv */
        l6 = -y*pc; /* y : -180...180    Laenge E positiv */
        /* printf("L5=%6.2f L6=%6.2f\n",l5,l6); */

        now = *gmtime(&tim);
        yr  = now.tm_year+1900; /* Y2K? */
        m   = now.tm_mon+1;
        d   = now.tm_mday;
        /* printf("D=%d M=%d YR=%d\n",d,m,yr); */

        m1 = m + 12; ya = yr - 1; if ( m > 2 ) { m1 = m; ya = yr; }
        a  = (int) (yr/100); bz = 2 - a + ((int) (a/4)); 
        j  = (int)(365.25*ya) + ((int)(30.6001*(m1+1))) + d + bz;
        t1 = j - 17472.5 - (long int) 676553;
        /* printf("J=%12.8f T1=%12.2f\n",j,t1); */

        b = 0;
        d9 = now.tm_hour*60 + now.tm_min;
        t  = d9/1440.0; t2 = t1 + t; x1 = 0.751213  + 0.0366011*t2;
        /* printf("D9=%12.2f T=%12.2f T2=%12.2f\n",d9,t,t2); */
        k1 = (x1-(int)(x1))*pd;    x2 = 0.822513  + 0.0362917*t2;
        k2 = (x2-(int)(x2))*pd;    x4 = 0.974271  + 0.0338632*t2;
        k4 = (x4-(int)(x4))*pd;    x3 = 0.995766  + 2.73779e-03*t2;
        k3 = (x3-(int)(x3))*pd;    x5 = 0.0312525 + 0.0367482*t2;
        k5 = (x5-(int)(x5))*pd;

        l8 = k1 + (0.658*sin(2*k4)      + 6.289*sin(k2))*pc;
        l8 = l8 - (1.274*sin(k2-2*k4)   + 0.186*sin(k3))*pc;
        l8 = l8 + (0.214*sin(2*k2)      - 0.114*sin(2*k5))*pc;
        l8 = l8 - (0.059*sin(2*k2-2*k4) + 0.057*sin(k2+k3-2*k4))*pc;
        /* printf("l8=%12.8f\n",l8); */

        k6 = k5 + (0.6593*sin(2*k4) + 6.2303*sin(k2-1.272)*sin(k2-2*k4))*pc;
        l7 = (5.144*sin(k6) - 0.146*sin(k5-2*k4))*pc;
        /* printf("l7=%12.8f\n",l7); */
        d1 = cos(l7)*sin(l8)*0.397821 + sin(l7)*0.917463;
        d1 = atan(d1/sqrt(1-d1*d1));
        a2 = cos(l7)*cos(l8)/cos(d1);
        a1 = (cos(l7)*sin(l8)*0.917463-sin(l7)*0.397821)/cos(d1);
        a  = atan(a1/a2);

        /* gosub 830 */

        /* printf("moon.c: a=%8.5f a2=%8.5f\n",a,a2); */

	if ( a==0 ) { 
		if (a2 < 0) { 
			a = p1; 
		} 
	} else if ( a > 0 ) { 
		if ( a2 < 0 ) { 
			a = a + p1; 
		} 
	} else if ( a2 < 0 ) { 
		a = a + p1; 
	} else { 
		a = a + pd;
	}
        /* end gosub - I hope that's correct! */
        /* printf("a=%12.8f a1=%12.8f a2=%12.8f\n",a,a1,a2); */

        r1 = a;
        l1 = 0.0657098*t1;
        l  = t*24*1.00274 + 6.64606 + (l1-(int)(l1/24)*24);
        l  = l - (int)(l/24)*24; 
        g  = (l/24)*pd - r1;

        if (g<pd) { 
            if (g<0) { 
                g = g + pd; 
            }
        } else { 
            g = g - pd; 
        }
        h  = l6 - g;

        e  = cos(l5)*cos(h)*cos(d1) + sin(d1)*sin(l5);
        e  = atan(e/sqrt(1-e*e));
        /* printf("l=%12.8f g=%12.8f e=%12.8f\n",l,g,e); */
        /* printf("l5=%12.8f h=%12.8f e=%12.8f\n",l5,h,e); */

        a2 = sin(d1)/(cos(l5)*cos(e));
        a2 = a2 - tan(l5)*tan(e);

        a1 = sin(l5)*sin(d1) + cos(l5)*cos(d1)*cos(h);
        a1 = (sin(h)*cos(d1))/sqrt(1-a1*a1);
        a  = atan(a1/a2);

        /* gosub 830 */

        /* printf("moon.c: a=%8.5f a2=%8.5f\n",a,a2); */

	if ( a==0 ) { 
		if (a2 < 0) { 
			a = p1; 
		} 
	} else if ( a > 0 ) { 
		if ( a2 < 0 ) { 
			a = a + p1; 
		} 
	} else if ( a2 < 0 ) { 
		a = a + p1; 
	} else { 
		a = a + pd;
	}
        /* end gosub - I hope that's correct! */
        /* printf("a=%12.8f a1=%12.8f a2=%12.8f\n",a,a1,a2); */

        mpos.az=a*180.0/p1;
        mpos.el=e*180.0/p1;

	return(mpos);
}

Moon moonrisetimes(double x,double y)
{
	Moon moon_data;
        time_t tim,current;
	Azel mpos;
        struct tm now;
	

	moon_data.rise = 0;
	moon_data.set = 1439;

        (void) time(&current);
	tim = current;
        now = *gmtime(&tim);

	mpos = moonpos(x,y,tim);
        moon_data.az=mpos.az;
        moon_data.el=mpos.el;

	if (moon_data.el < 0) {
                /* Moonrise later than now */
		while(mpos.el < 0) {
			tim = tim + 300; /* +5 minutes */
        		/* printf("T: %ld\n",tim); */
			mpos = moonpos(x,y,tim);
		}
		moon_data.rise = now.tm_hour*60 + now.tm_min + (tim-current)/60;

                /* Moonset earlier than now */
        	tim = current;
		mpos = moonpos(x,y,tim);
		while(mpos.el < 0) {
			tim = tim - 300; /* -5 minutes */
			mpos = moonpos(x,y,tim);
		}
		moon_data.set = now.tm_hour*60 + now.tm_min + (tim-current)/60;

	} else {
                /* Moonset later than now */
		while(mpos.el > 0) {
			tim = tim + 300; /* +5 minutes */
        		/* printf("T: %ld\n",tim); */
			mpos = moonpos(x,y,tim);
		}
		moon_data.set = now.tm_hour*60 + now.tm_min + (tim-current)/60;

                /* Moonrise earlier than now */
        	tim = current;
		mpos = moonpos(x,y,tim);
		while(mpos.el > 0) {
			tim = tim - 300; /* -5 minutes */
        		/* printf("T: %ld\n",tim); */
			mpos = moonpos(x,y,tim);
		}
		moon_data.rise = now.tm_hour*60 + now.tm_min + (tim-current)/60;
	}


	return(moon_data);
}

/* 

The software is based on the following program called MOONTRAK.BAS 
downloaded from ftp.amsat.org on Feb 12, 1999.

10 REM MOON TRACKING PROGRAM
20 REM PROGRAM ORIGINATED BY WB7CCI. THIS VERSION CONVERTED TO DISC BASIC BY
30 REM G3RWL. WORKS OK WITH GWBASIC.
40 REM
50 REM THIS PROGRAM PRINTS AZ/EL FIGURES AT SET INTERVALS. SAMPLE RUN FOR 31ST
60 REM DECEMBER 1983 COMMENCING 0100 UTC AND 30 MINUTE INTERVALS GAVE AOS AT
70 REM 0500 AZ=118.6 EL=-2.6 THRU MAXIMUM EL AT 0930 AZ=176.9 EL=18.2 TO LOS
80 REM AT 1430 AZ=241.3 EL=-4.2. USE THIS AS WORKED EXAMPLE WITH LAT/LONG GIVEN
85 REM BEFORE CHANGING TO *YOUR* QTH.
90 P1=3.14159:PC=P1/180:PD=2*P1
100 DEF FNC(Z)=ATN(Z/SQR(-Z*Z+1)):REM ARCSIN
110 REM L5=51.65*PC:L6=.1*PC:REM STATION LAT/LONG L5/L6
111 L5=48.15*PC:L6=-11.71*PC:REM STATION LAT/LONG L5/L6
120 CLS:PRINT TAB(25)"MoonTrack":PRINT TAB(25)"=========":PRINT
130 INPUT "Year number in full ",Y
140 IF Y<1980 OR Y>1999 OR Y<>INT(Y) THEN 130
150 INPUT "       Month number ",M
160 IF M<1 OR M>12 OR M<>INT(M) THEN 150
170 INPUT "         Day number ",D
180 IF D<1 OR D>31 OR D<>INT(D) THEN 170
190 M1=M+12:YA=Y-1:IF M>2 THEN M1=M:YA=Y
200 A=INT(Y/100):BZ=2-A+INT(A/4):J=INT(365.25*YA)+INT(30.6001*(M1+1))+D+BZ
210 INPUT "Start time UTC HHMM ",B
220 IF B<0 OR B>2400 OR B<>INT(B) THEN 210
230 PRINT:PRINT "Time step usually 15 minutes, ";
240 INPUT "enter new value if required or press return ",ST
250 IF ST=0 THEN ST=15:PRINT ELSE PRINT
260 INPUT "Type P for printer, V for vdu or B for both ",P$
270 IF P$="b"THEN P$="B" ELSE IF P$="p"THEN P$="P" ELSE IF P$="v" THEN P$="V"
280 IF P$="B" OR P$="P" OR P$="V" THEN 290 ELSE 260
290 T1=J-17472.5-676553!:IF P$<>"P" THEN CLS
300 IF P$="V" OR P$="B" THEN PRINT TAB(21)"Moontrack by WB7CCI"
310 IF P$="P" OR P$="B" THEN LPRINT TAB(21)"Moontrack by WB7CCI"
320 IF P$="V" OR P$="B" THEN PRINT TAB(21)"===================":PRINT
330 IF P$="P" OR P$="B" THEN LPRINT TAB(21)"===================":LPRINT
340 IF P$="V" OR P$="B" THEN PRINT:PRINT TAB(20)"Date ";D;"/";M;"/";Y
350 IF P$="P" OR P$="B" THEN LPRINT:LPRINT TAB(20)"Date ";D;"/";M;"/";Y
360 IF P$="P" THEN PRINT:PRINT "Printout being produced":PRINT
370 GOSUB 930
380 D9=(B-((INT(B/100))*100))+INT(B/100)*60
390 T=D9/1440:T2=T1+T:X1=.751213+.0366011*T2
400 K1=(X1-INT(X1))*PD:X2=.822513+.0362917*T2
410 K2=(X2-INT(X2))*PD:X4=.974271+.0338632*T2
420 K4=(X4-INT(X4))*PD:X3=.995766+2.73779E-03*T2
430 K3=(X3-INT(X3))*PD:X5=.0312525+.0367482*T2
440 K5=(X5-INT(X5))*PD
450 L8=K1+(.658*SIN(2*K4)+6.289*SIN(K2))*PC
460 L8=L8-(1.274*SIN(K2-2*K4)+.186*SIN(K3))*PC
470 L8=L8+(.214*SIN(2*K2)-.114*SIN(2*K5))*PC
480 L8=L8-(.059*SIN(2*K2-2*K4)+.057*SIN(K2+K3-2*K4))*PC
490 K6=K5+(.6593*SIN(2*K4)+6.2303*SIN(K2-1.272)*SIN(K2-2*K4))*PC
500 L7=(5.144*SIN(K6)-.146*SIN(K5-2*K4))*PC
510 D1=COS(L7)*SIN(L8)*.397821+SIN(L7)*.917463:D1=FNC(D1)
520 A2=COS(L7)*COS(L8)/COS(D1)
530 A1=(COS(L7)*SIN(L8)*.917463-SIN(L7)*.397821)/COS(D1)
540 A=ATN(A1/A2):GOSUB 830:R1=A:L1=.0657098*T1
550 L=T*24*1.00274+6.64606+(L1-INT(L1/24)*24)
560 L=L-INT(L/24)*24:G=(L/24)*PD-R1:IF G<PD THEN 580
570 G=G-PD:GOTO 600
580 IF G<0 THEN 590 ELSE 600
590 G=G+PD
600 H=L6-G
610 E=COS(L5)*COS(H)*COS(D1)+SIN(D1)*SIN(L5):E=FNC(E)
620 A2=SIN(D1)/(COS(L5)*COS(E)):A2=A2-TAN(L5)*TAN(E)
630 A1=SIN(L5)*SIN(D1)+COS(L5)*COS(D1)*COS(H)
640 A1=(SIN(H)*COS(D1))/SQR(1-A1*A1):A=ATN(A1/A2):GOSUB 830
650 AZ=(INT(A*180/P1*10))/10:EL=(INT(E*180/P1*10))/10
660 IF EL<-20 THEN B=B+100
670 IF EL<-10 THEN B=B+85
680 IF EL<-5 THEN 710 ELSE GOSUB 910
690 IF P$="V" OR P$="B" THEN PRINT TAB(12)T$;TAB(26)AZ;TAB(41)EL
700 IF P$="P" OR P$="B" THEN LPRINT TAB(12)T$;TAB(26)AZ;TAB(41)EL
710 B=B+ST:B2=B-(INT(B/100))*100:IF B2>59 THEN B=B+40
720 IF B<2400 THEN 380
730 IF P$="V" OR P$="B" THEN PRINT
740 IF P$="P" OR P$="B" THEN LPRINT
750 INPUT "Next Day ? (Y/N) ",N$
760 IF LEFT$(N$,1)="Y" OR LEFT$(N$,1)="y" THEN 770 ELSE END
770 T1=T1+1:D=D+1:IF P$="V" OR P$="B" THEN PRINT:PRINT TAB(20)"Date: ";
780 IF P$="P" OR P$="B" THEN LPRINT:LPRINT TAB(20)"Date: ";
790 IF P$="V" OR P$="B" THEN PRINT D;"/";M;"/";Y
800 IF P$="P" OR P$="B" THEN LPRINT D;"/";M;"/";Y
810 IF P$="P" THEN PRINT:PRINT "Printout being produced":PRINT
820 GOSUB 930:B=B-2400:GOTO 380
830 IF A=0 THEN 840 ELSE 860
840 IF A2<0 THEN 850 ELSE RETURN
850 A=P1:RETURN
860 IF A>0 THEN 900
870 IF A2<0 THEN 890
880 A=A+PD:RETURN
890 A=A+P1:RETURN
900 IF A2>=0 THEN RETURN ELSE A=A+P1:RETURN
910 T$=STR$(B):T$=RIGHT$(T$,(LEN(T$)-1))
920 T$=RIGHT$(("0000"+T$),4):RETURN
930 IF P$="V" OR P$="B" THEN PRINT TAB(12)"UTC";TAB(26)"Azimuth";TAB(42)"Elev"
940 IF P$="P" OR P$="B" THEN LPRINT TAB(12)"UTC";TAB(26)"Azimuth";TAB(42)"Elev"
950 RETURN

*/

long int gregorian_to_julian_dn(int y, int m, int d) {

	long int jd;
	float a,b;

	if ( m<=2 ) { 
		y = y - 1; 
		m = m + 12; 
	}
	a = (int)(y / 100.0);
	b = 2.0 - a + (int)(a/4.0);
	jd = ((int)(365.25*y)) + ((int)(30.6001*(m+1))) + 
		d + b + 1720995;
        /* printf("d=%d, m=%d, y=%d, a=%6.2f, b=%6.2f, jd=%ld\n",
		d,m,y,a,b,jd); */
	return(jd);

}

float moon_phase() {

  /* Contributor: ALAN GRAFF                                          */
  /*                                                                  */
  /*                                                                  */
  /* As Robert Forbes said to All on 25 Apr 94...                     */
  /*                                                                  */
  /*  RF>         Anyone have any idea how to make an algorithm to    */
  /*  RF> calculate the moonphase given the date?                     */


  /***************************************************************/
  /*                                                             */
  /* Determines APPROXIMATE phase of the moon (percentage lit)   */
  /* 0.00 = New moon, 1.00 = Full moon                           */
  /* Due to rounding, full values may possibly never be reached  */
  /* Valid from Oct. 15, 1582 to Feb. 28, 4000                   */
  /* Calculations and BASIC program found in                     */
  /* "119 Practical Programs For The TRS-80 Pocket Computer" by  */
  /* John Clark Craig, TAB Books, 1982                           */
  /* Conversion to Turbo Pascal by Alan Graff, Wheelersburg, OH  */
  /*                                                             */
  /***************************************************************/

	long int jd;
        struct tm now;
        time_t tim;
	float m;

        (void) time(&tim);
        now = *gmtime(&tim);
	jd = gregorian_to_julian_dn(now.tm_year+1900,now.tm_mon+1,now.tm_mday);
	m = (jd+4.867) / 29.53058;
        /* printf("m=%10.2f\n",m); */
	m = 2*(m-(int)m)-1;
        /* printf("m=%10.2f\n",m); */
	return fabs(m*100.0);
}
