#include "sun.h"

int scan_locations(char *s_pfx,int start)
{
   FILE *fp;
   float lat,lon;
   float timezone;
   int lat_deg,lat_min,lon_deg,lon_min;
   int i;
   int ctr;
   char pfx[10],name[30],ew,ns;

/*   char sunrise[6],sunset[6];	*/
   char loc_filename[80];

   strcpy(loc_filename,getenv("HOME"));
   strcat(loc_filename,"/config/location.dat");

   ctr=0;

   if ( ( fp=fopen(loc_filename,"rt") ) == NULL )
   {
      write_syslog_noopen(loc_filename);
   } 
   else 
   {
      while ( ( fscanf(fp,"%s %s %d %d %c %d %d %c %f",
          pfx,name,&lat_deg,&lat_min,&ns,
          &lon_deg,&lon_min,&ew,&timezone ) > 0 )  ) 
      {
       	i=strncmp(s_pfx,pfx,strlen(s_pfx));
         if ( i == 0 )
         {
            lat=(float) lat_deg+((float) lat_min/60.0);
            if (ns == 'S') lat = -lat;

            lon=(float) lon_deg+((float) lon_min/60.0);
            if (ew == 'W') lon = -lon;

            locations[ctr+start].loc.lat = lat;
            locations[ctr+start].loc.lon = lon;
            strcpy(locations[ctr+start].pref,pfx);
            strcpy(locations[ctr+start].name,name);
            locations[ctr+start].timezone=0.0;
            locations[ctr+start].qrb=0;
            locations[ctr+start].qtf=0;
            locations[ctr+start].suntimes.rise=0;
            locations[ctr+start].suntimes.set=0;

#ifdef DEBUG
            printf("PFX: %-6s NAME: %-20s   LAT: %6.2f LON: %6.2f\n",
		pfx,name,lat,lon);
#endif
            strlwr(pfx);

            ctr++;
         }
      }
   }
   fclose(fp);
   return(ctr);
}


