#define LOCATION
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ftz.h"
/* #include "adv_txt.h" */
#include "output.h"

int scan_locations(char *s_pfx)
{
   FILE *fp;
   float lat,lon;
   float timezone;
   int lat_deg,lat_min,lon_deg,lon_min;
   int i;
   int ctr;
   char pfx[10],name[30],ew,ns;

   char loc_filename[80];

   strcpy(loc_filename,getenv("HOME"));
   strcat(loc_filename,"/config/location.dat");

   ctr=0;

   if ( ( fp=fopen(loc_filename,"rt") ) == NULL )
   {
      write_syslog_noopen(loc_filename);
   } 
   else 
   {
      while ( ( fscanf(fp,"%s %s %d %d %c %d %d %c %f",
          pfx,name,&lat_deg,&lat_min,&ns,
          &lon_deg,&lon_min,&ew,&timezone ) > 0 )  ) 
      {
       	i=strncmp(s_pfx,pfx,strlen(s_pfx));
         if ( i == 0 )
         {
         	lat=lat_deg+lat_min/60;
            if (ns == 'S') lat = -lat;

            lon=lon_deg+lon_min/60;
            if (ew == 'W') lon = -lon;

            target_location.lat= lat;
            target_location.lon = lon;

#ifdef DEBUG
            printf("PFX: %-6s NAME: %-20s   LAT: %6.2f LON: %6.2f\n",c_pfx,land_n,lat,lon);
#endif
            strlwr(pfx);
            strcpy(target_location.pref,pfx);
            strcpy(target_location.name,name);
            target_location.timezone=0.0;

            ctr++;
         }
      }
   }
   fclose(fp);
   return(ctr);
}


