#!/usr/bin/perl
# file: udp_server.pl

use IO::Socket;
use strict;
use constant MAXLEN => 1024;

my $port = shift || 2007;
my $data;

my $S = IO::Socket::INET->new(Proto     => 'udp',
                              Type      => SOCK_DGRAM,
                              LocalPort => $port,
                              ) || die "can't make socket: $!";

while (1) {
    my $sender = $S->recv($data,MAXLEN,0) || die "recv(): $!";

    my ($remote_port,$remote_host) = sockaddr_in($sender);
    $remote_host = inet_ntoa($remote_host);
    warn "Received ",length($data)," bytes from [$remote_host,$remote_port]\n";

    chomp($data);
    $data = (scalar reverse $data) . "\n";
    $S->send($data,0,$sender) || die "send(): $!";
}

__END__
