;====================================================================
;
; This is the FINEST program for POCSAG decoding.
; Written by Iogann Excalibur in 1995.
; Can be use (or not use) by everyone for any purposes.
; Can be distributed freely everywhere.
; Nice listening!!!
;
;====================================================================
RX_MODE_CONST   equ     2       ; 0 - Frame output
                                ; 1 - ASCII output
                                ; 2 - ASCII HEX output
                                ; 3 - Numeric output
                                ; 4 - Numeric HEX output
;====================================================================
RX_COMPLEMENT_CONST equ 0       ; 00h - true receiver
                                ; 0FFh - complement receiver
;====================================================================
                %INCLUDE "defines.asm"
                %INCLUDE "fx_reg.asm"
;====================================================================
                seg     code

                org     0000h
		ljmp	Cool_Reset

                org     0003h
		ljmp	Intr_0

                org     000Bh
		ljmp	Timer_0

                org     0013h
		ljmp	Intr_1

                org     001Bh
		ljmp	Timer_1

                org     0023h
		ljmp	Int_SIO

                org     002Bh
		ljmp	Timer_2
;-----------------------------------------------------------
Rx_Addresses:
RX_ADDRESS_0    db      00h,10h,01h ; 1st received address
RX_ADDRESS_1    db      00h,10h,02h ; 2nd
RX_ADDRESS_2    db      00h,10h,03h ; 3rd
RX_ADDRESS_3    db      00h,10h,04h ; 4th
RX_ADDRESS_4    db      00h,10h,05h ; 5th
RX_ADDRESS_5    db      00h,10h,06h ; 6th
RX_ADDRESS_6    db      00h,10h,07h ; 7th
RX_ADDRESS_7    db      00h,10h,08h ; 8th received address
Rx_Addresses_End:
;====================================================================
Cool_Reset:
                mov     R0,#0FFh
Clear_RAM:
                mov     @R0,#0
                djnz    R0,Clear_RAM
;-----------------------------------------------------------
Warm_Reset:
		mov	IE,#0

		mov	R0,#50
Warm_Wait_0:
		mov	R1,#200
Warm_Wait_1:
		mul	AB
		djnz	R1,Warm_Wait_1

		djnz	R0,Warm_Wait_0


	        mov     SP,#Stack-1
		clr	RS0
		clr	RS1

		clr	Timer2_Rx
;--------------------------------------------------------------------
		mov	TCON,#0
                mov     TMOD,#00100000b ; timer 1 mode 2 - AutoReload
                orl     PCON,#10000000b ; *2 baud
                mov     TH1,#(256-10)   ; 9600 baud
                setb    TR1             ; enable timer 1

		mov     SCON,#01011100b ; UART mode 1 -  8bit
;--------------------------------------------------------------------
; Timer 2 - used as a task switching with different priorities for every task
;
		mov	T2MOD,#0
		mov	T2CON,#0

		mov	RCAP2H,#high(T9600)
		mov	RCAP2L,#low (T9600)

		setb	TR2	; Enable Timer2
		setb	ET2	; Enable Timer2 interrupts
;--------------------------------------------------------------------
;	Set interrupt priority
;
		setb	PT2		; Timer2 - Highest priority
;--------------------------------------------------------------------
		setb	Tx_EMPTY
		setb	ES		; Enable SIO interrupt
;--------------------------------------------------------------------
;	Out to the RS-232 queue
;
		mov	Out_Head,#Tx_Buffer_Begin
		mov	Out_Tail,#Tx_Buffer_Begin
;--------------------------------------------------------------------
;	In from RS-232 queue
;
                mov     In_Head,#Rx_Buffer_Begin
                mov     In_Tail,#Rx_Buffer_Begin
;--------------------------------------------------------------------
Initialize:
		Green_On
		Red_Off
;--------------------------------------------------------------------
;
                setb    EA              ; not disable all IRQ
;====================================================================
CORR_THRESHOLD	equ	13	; correlator threshold
;--------------------------------------------------------------------
Wait_For_Preamble:
		mov	RCAP2H,#high(T9600)
		mov	RCAP2L,#low (T9600)

		Green_On
		RED_Off

		clr	Timer2_Rx		; Correlate now

		clr	Corr_Complete

		jnb	Corr_Complete,$
		clr	Corr_Complete
;--------------------------------------
                mov     DPTR,#Rx_Addresses
                mov     A,#0
                mov     R7,#0
                mov     R0,Addr_Field
Fill_Addr_Field:
                mov     A,R7
                movc    A,@A+DPTR
                mov     @R0,A
                inc     R0
                inc     R7
                cjne    R7,#Rx_Addresses_End,Fill_Addr_Field
;--------------------------------------
Wait_Corr:
		jnb	Corr_Complete,$
		clr	Corr_Complete

		mov	R0,#Koeff_Derived
		mov	R7,#3
Loop_Rxt:
		mov	A,@R0
		inc	R0
		clr	C
		subb	A,#100
		jnc	RT00

		cpl	A
		inc	A
RT00:
		mov	B,A
		mul	AB

		mov	R4,A
		mov	R3,B

		mov	A,@R0
		inc	R0
		clr	C
		subb	A,#100
		jnc	RT01

		cpl	A
		inc	A
RT01:
		mov	B,A
		mul	AB

		add	A,R4
		mov	R4,A
		mov	A,B
		addc	A,R3
		mov	R3,A
		clr	C
		subb	A,#CORR_THRESHOLD
		jnc	Preabmle_Exist

		djnz	R7,Loop_Rxt

		ljmp	Wait_Corr
;-------------------------
Preabmle_Exist:
		mov	A,R7
		cjne	A,#3,Not_512

		mov	RCAP2H,#high(T0_512)
		mov	RCAP2L,#low (T0_512)
		sjmp	Search_FS
Not_512:
		cjne	A,#2,Not_1200

		mov	RCAP2H,#high(T0_1200)
		mov	RCAP2L,#low (T0_1200)
		sjmp	Search_FS
Not_1200:
		cjne	A,#1,Not_2400

		mov	RCAP2H,#high(T0_2400)
		mov	RCAP2L,#low (T0_2400)
		sjmp	Search_FS
Not_2400:
		ljmp	Wait_Corr
;==============================
Search_FS:
		clr	TR2
		setb	Timer2_Rx		; Receiving now

                mov     Rx_Complement,#RX_COMPLEMENT_CONST
		mov	Rx_Bit_Count,#0
		mov	Rx_Bit_Capture,#1
		clr	Rx_Buf_Ready
		setb	TR2
		mov	R6,#32
;---------------------------
Wait_For_FS:
		jnb	Rx_Buf_Ready,$	;2
		clr	Rx_Buf_Ready	;1

		mov	R7,#0
		mov	DPTR,#Quontity_Ones

		mov	A,Rx_Buf+0
		xrl	A,#FS_0
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+1
		xrl	A,#FS_1
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+2
		xrl	A,#FS_2
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+3
		xrl	A,#FS_3
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A
		cmp	A,#2
		jc	FS_Start
;---------------
		mov	R7,#0

		mov	A,Rx_Buf+0
		xrl	A,#FSI_0
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+1
		xrl	A,#FSI_1
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+2
		xrl	A,#FSI_2
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A

		mov	A,Rx_Buf+3
		xrl	A,#FSI_3
		movc	A,@A+DPTR
		add	A,R7
		mov	R7,A
		cmp	A,#2
		jc	FSI_Start
;---------------
		mov	A,Rx_Buf+0
		cjne	A,#55h,WF_Not_Pre
		mov	A,Rx_Buf+1
		cjne	A,#55h,WF_Not_Pre
		mov	R6,#32
WF_Not_Pre:
		djnz	R6,Not_Any

		ljmp	Wait_For_Preamble
Not_Any:
		ljmp	Wait_For_FS		;2
;-----------------------------------
FSI_Start:
		xrl	Rx_Complement,#0FFh	;2
FS_Start:
		mov	Rx_Bit_Capture,#32	;2

		Green_Off
		RED_On

                mov     A,#RX_MODE_CONST
		mov	Rx_Mode,A

		cjne	A,#00,RXT_Not_FRAME

		ljmp	FRAME_Output_Mode
RXT_Not_FRAME:
		cjne	A,#01,RXT_Not_ASC_7

		ljmp	ASC_Output_Mode
RXT_Not_ASC_7:
		cjne	A,#02,RXT_Not_ASC_HEX

		ljmp	ASC_Output_Mode
RXT_Not_ASC_HEX:
		cjne	A,#03,RXT_Not_NUM

		ljmp	NUM_Output_Mode
RXT_Not_NUM:
		cjne	A,#04,RXT_Not_NUM_HEX

		ljmp	NUM_Output_Mode
RXT_Not_NUM_HEX:
		mov	Rx_Mode,#01
		ljmp	ASC_Output_Mode
;====================================================================
;	ASCII format
;
ASC_Output_Mode:
		mov	Frame,#0FFh
		clr	Data_Was_Been
;-----------------------
ASC_Wait_Frame:
		lcall	Get_Frame

		inc	Frame
		mov	A,Frame
		cjne	A,#16,ASC_FS

		mov	Frame,#0

		lcall	Is_FS
		jc	ASC_Next_Batch

		ljmp	ASC_End
ASC_Next_Batch:
		lcall	Get_Frame
ASC_FS:
		lcall	Is_Idle
		jnc	ASC_Start_Msg

		jnb	Data_Was_Been,ASC_NoCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
ASC_NoCRLF:
		sjmp	ASC_Wait_Frame
;-----------------------
ASC_Start_Msg:
		lcall	RLC_Rx_Buf
		jnc	ASC_Addr_DWord

		jnb	Address_Valid,ASC_Wait_Frame

		mov	R7,#20
ASC_Extract_Symbol:
		lcall	RLC_Rx_Buf
		mov	A,Symbol
		rrc	A
		mov	Symbol,A

		djnz	SymBits,ASC_Skip_Out
;---------------
		mov	A,Rx_Mode
		cjne	A,#02,ASC_ASCII_Output

		mov	A,Symbol
		rr	A
		anl	A,#01111111b
		lcall	HexOutA
		sjmp	ASC_Out_End
;---------------
ASC_ASCII_Output:
		mov	A,Symbol
		rr	A
		anl	A,#01111111b
		cmp	A,#20h
		jnc	ASC_Printable

		mov	A,#20h
ASC_Printable:
		lcall	SymOut
ASC_Out_End:
;---------------
		mov	SymBits,#7
		mov	Symbol,#0
ASC_Skip_Out:
		djnz	R7,ASC_Extract_Symbol

		sjmp	ASC_Wait_Frame
;-----------------------
ASC_Addr_DWord:
		jnb	Data_Was_Been,ASC_AddrCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
ASC_AddrCRLF
		lcall	Is_Address_Valid

		jnb	Address_Valid,ASC_Addr_Invalid

		lcall	Print_Output_Mode
		lcall	Print_Address

		mov	SymBits,#7
		mov	Symbol,#0
		setb	Data_Was_Been
ASC_Addr_Invalid:
		ljmp	ASC_Wait_Frame
;-----------------------
ASC_End:
		jnb	Data_Was_Been,ASC_End_NoCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
ASC_End_NoCRLF:
		ljmp	Wait_For_Preamble
;====================================================================
;	NUMERIC format
;
NUM_Output_Mode:
		mov	Frame,#0FFh
		clr	Data_Was_Been
;-----------------------
NUM_Wait_Frame:
		lcall	Get_Frame

		inc	Frame
		mov	A,Frame
		cjne	A,#16,NUM_FS

		mov	Frame,#0

		lcall	Is_FS
		jc	NUM_Next_Batch

		ljmp	NUM_End
NUM_Next_Batch:
		lcall	Get_Frame
NUM_FS:
		lcall	Is_Idle
		jnc	NUM_Start_Msg

		jnb	Data_Was_Been,NUM_NoCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
NUM_NoCRLF:
		sjmp	NUM_Wait_Frame
;-----------------------
NUM_Start_Msg:
		lcall	RLC_Rx_Buf
		jnc	NUM_Addr_DWord

		jnb	Address_Valid,NUM_Wait_Frame

		mov	A,Rx_Mode
		cjne	A,#04,NUM_HEX_NoErr

		mov	A,ErrorsBCH
		lcall	NibbleOut
		Message " "
NUM_HEX_NoErr:
		mov	R7,#5
NUM_Extract_Symbol:
		mov	R6,#4
NUM_Shift_Sym:
		lcall	RLC_Rx_Buf
		mov	A,Symbol
		rrc	A
		mov	Symbol,A
		djnz	R6,NUM_Shift_Sym

		mov	A,Rx_Mode
		cjne	A,#05,NUM_No_OpenPage

		mov	A,Symbol
		swap	A
		anl	A,#00001111b
		add	A,#(NUM_HEX_Table-NUM_disp_OP)
		movc	A,@A+PC
NUM_disp_OP:
		lcall	SymOut
		sjmp	NUM_Not_Space
NUM_No_OpenPage:
		mov	A,Rx_Mode
		cjne	A,#03,NUM_HEX_Out
;---------------
		mov	A,Symbol
		swap	A
		anl	A,#00001111b
		add	A,#(NUM_Table-NUM_disp1)
		movc	A,@A+PC
NUM_disp1:
		lcall	SymOut
		sjmp	NUM_Out_End
;---------------
NUM_HEX_Out:
		mov	A,Symbol
		swap	A
		anl	A,#00001111b
		add	A,#(NUM_HEX_Table-NUM_disp2)
		movc	A,@A+PC
NUM_disp2:
		lcall	SymOut
;---------------
NUM_Out_End:
		djnz	R7,NUM_Extract_Symbol

		mov	A,Rx_Mode
		cjne	A,#04,NUM_Not_Space
		Message	" "
NUM_Not_Space:
		ljmp	NUM_Wait_Frame
;-----------------------
NUM_Addr_DWord:
		jnb	Data_Was_Been,NUM_AddrCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
NUM_AddrCRLF:
		lcall	Is_Address_Valid

		jnb	Address_Valid,NUM_Skip_Addr

		lcall	Print_Output_Mode
		lcall	Print_Address

		setb	Data_Was_Been
NUM_Skip_Addr:
		ljmp	NUM_Wait_Frame
;-----------------------
NUM_End:
		jnb	Data_Was_Been,NUM_End_NoCRLF
		clr	Data_Was_Been
		Message <0Dh,0Ah,0Dh,0Ah>
NUM_End_NoCRLF:
		ljmp	Wait_For_Preamble
;====================================================================
NUM_Table:
		db	'0','1','2','3','4','5','6','7'
		db	'8','9','*','U',' ','-',']','['
NUM_HEX_Table:
		db	'0','8','4','C','2','A','6','E'
		db	'1','9','5','D','3','B','7','F'
;====================================================================
;	FRAME format
;
FRAME_Output_Mode:
		Message <0Dh,0Ah>
		lcall	Print_Output_Mode

		Message <0Dh,0Ah>
FRAME_Start_Rx:
		mov	Frame,#16
FRAME_Batch:
		lcall	Get_Frame

		lcall	NibbleOut
		Message " "

		lcall	Is_Idle
		jnc	FRAME_Not_Idle

		Message <"--------">
		sjmp	FRAME_Skip

FRAME_Not_Idle:
		mov	A,Rx_Buf+0
		lcall	HexOutA
		mov	A,Rx_Buf+1
		lcall	HexOutA
		mov	A,Rx_Buf+2
		lcall	HexOutA
		mov	A,Rx_Buf+3
		lcall	HexOutA
FRAME_Skip:
		Message <"  ">

		mov	A,Frame
		dec	A
		anl	A,#00000011b
		jnz	FRAME_Sk_CRLF

		Message <0Dh,0Ah>
FRAME_Sk_CRLF:
		djnz	Frame ,FRAME_Batch

		Message <0Dh,0Ah>

		lcall	Get_Frame

		lcall	Is_FS
		jc	FRAME_Start_Rx

		ljmp	Wait_For_Preamble
;====================================================================
;	Wait for receiving frame and decode errors
;
Get_Frame:
		jnb	Rx_Buf_Ready,$
		clr	Rx_Buf_Ready
		lcall	CorrectBCH

		ret
;====================================================================
Print_Output_Mode:
		Message "POCSAG "
		mov	A,RCAP2L
		cjne	A,#low(T0_512),Print_Form_Not_512
		Message "512"
Print_Form_Not_512:
		cjne	A,#low(T0_1200),Print_Form_Not_1200
		Message "1200"
Print_Form_Not_1200:
		cjne	A,#low(T0_2400),Print_Form_Not_2400
		Message "2400"
Print_Form_Not_2400:
		mov	A,Rx_Complement
                xrl     A,#RX_COMPLEMENT_CONST
Print_Form_001:
		jnz	Print_Form_Inv
		Message "+"
		sjmp	Print_Format_End
Print_Form_Inv:
		Message "-"
Print_Format_End:
		ret
;====================================================================
Print_Address:
		Message <" A=">
		mov	R3,#0
		mov	R2,#0
		mov	R1,#0
		mov	R0,#0
                mov     R7,#21
CapCode_Loop:
		lcall	RLC_Rx_Buf
		mov	A,R3
                addc    A,ACC
                da      A
                mov	R3,A
		mov	A,R2
                addc    A,ACC
                da      A
                mov	R2,A
		mov	A,R1
                addc    A,ACC
                da      A
                mov	R1,A
		mov	A,R0
                addc    A,ACC
                da      A
                mov	R0,A
                djnz    R7,CapCode_Loop

		mov	A,R0
		lcall	NibbleOut
		mov	A,R1
		lcall	HexOutA
		mov	A,R2
		lcall	HexOutA
		mov	A,R3
		lcall	HexOutA

		Message " G="
		mov	A,Group
		lcall	NibbleOut

		Message " F="
		mov	A,Frame
		rr	A
		anl	A,#00000111b
		lcall	NibbleOut

		Message <0Dh,0Ah>
		ret
;====================================================================
RLC_Rx_Buf:
		mov	A,Rx_Buf+3
		rlc	A
		mov	Rx_Buf+3,A
		mov	A,Rx_Buf+2
		rlc	A
		mov	Rx_Buf+2,A
		mov	A,Rx_Buf+1
		rlc	A
		mov	Rx_Buf+1,A
		mov	A,Rx_Buf+0
		rlc	A
		mov	Rx_Buf+0,A
		ret
;====================================================================
; multiple tmp+0..+2 by B
;
Mult_tmp:
		push	B
		mov	A,tmp+2
		mul	AB
		mov	tmp+2,A		; low byte
		mov	tmp+3,B

		mov	A,tmp+1
		pop	B
		push	B
		mul	AB
		add	A,tmp+3
		mov	tmp+1,A 	; middle byte
		mov	A,B
		addc	A,#0
		mov	tmp+3,A

		mov	A,tmp+0
		pop	B
		mul	AB
		add	A,tmp+3
		mov	tmp+0,A		; high byte
		ret
;====================================================================
;	Validate Address
;
Is_Address_Valid:
		mov	A,Rx_Buf+2
		swap	A
		anl	A,#00000011b
		mov	Group,A

		mov	A,Frame
		anl	A,#00001110b
		rl	A
		rl	A
		anl	Rx_Buf+2,#11000000b
		orl	Rx_Buf+2,A	; Rx_Buf+0..+2 = Addr left aligned

		setb	Address_Valid
;-----------------------
		jb	Rx_All_Addr,End_Addr_Check

		mov	R0,#Addr_Field
IAV_Addr_Loop:
		setb	GF_0
		mov	A,@R0
		inc	R0
		xrl	A,Rx_Buf+0
		jz	IAV_Addr_H

		clr	GF_0
IAV_Addr_H:
		mov	A,@R0
		inc	R0
		xrl	A,Rx_Buf+1
		jz	IAV_Addr_M

		clr	GF_0
IAV_Addr_M:
		mov	A,@R0
		inc	R0
		xrl	A,Rx_Buf+2
		anl	A,#11111000b
		jz	IAV_Addr_L

		clr	GF_0
IAV_Addr_L:
		jb	GF_0,End_Addr_Check
		cjne	R0,#Addr_Field+24,IAV_Addr_Loop

		clr	Address_Valid
End_Addr_Check:
;-----------------------
		ret
;====================================================================
                %INCLUDE "correct.asm"
                %INCLUDE "subr.asm"
                %INCLUDE "int.asm"
                %INCLUDE "corr_tab.asm"
                %INCLUDE "variable.asm"
;====================================================================
		end	0000h
;====================================================================