;==========================================================
; BCH 31,21 correction		
; On return - A=0,1,2,9=Uncorrectable.
;
CorrectBCH:	
		mov	R0,BCH0
		mov	R1,BCH1
		mov	R2,BCH2
		mov	R3,BCH3
		
		mov	R6,#0
		mov	R7,#0
		
		mov	A,R0
		xrl	A,R1
		xrl	A,R2
		xrl	A,R3
		jnb	P,_parity_0
		inc	R6
_parity_0:	
		mov	A,R0
		anl	A,#0feh
		mov	R0,A
		mov	R5,#4
_calc_syndrom:  
		mov	A,R3
		mov	R4,A   ; tmpbyte
		mov 	A,R2
		mov	R3,A
		mov	A,R1
		mov	R2,A
		mov	A,R0
		mov	R1,A
		mov	R0,#0
		mov	DPTR,#CrcTable
		mov	A,R4
		add	A,DPL
		mov	DPL,A
		clr	A
		addc	A,DPH
		mov	DPH,A
		mov	A,R4
		movc	A,@A+DPTR
		xrl	A,R2
		mov	R2,A
		mov	A,R4
		inc	DPTR
		movc	A,@A+DPTR
		xrl	A,R3
		mov	R3,A
		djnz	R5,_calc_syndrom
;
;  R3R2 - syndrom<<6
;
		mov	A,R2
		anl	A,#0c0h
		orl	A,R3
		jnz	_synd_not_0
_correct_p:	
		cjne	R6,#0,_err_parity

		clr	A
		ljmp	C_BCH_End
_err_parity:	
		inc	R7
		mov	A,BCH0
		xrl	A,#1
		mov	BCH0,A
_result:	
		mov	A,R7
		ljmp	C_BCH_End

_synd_not_0:    
		mov	R5,#5
		
_scale_synd:    
		mov	A,R3		;1
		rrc	A		;1
		mov	R3,A		;1
		mov	A,R2		;1
		rrc	A		;1
		mov	R2,A		;1
		djnz	R5,_scale_synd	;2 = 72
		
		mov	A,R3
		anl	A,#7
		mov	R3,A
		mov	A,R2
		anl	A,#0feh
		mov	R2,A
		
		mov	DPTR,#SyndTable
		add	A,DPL
		mov	DPL,A
		mov	A,R3
		addc	A,DPH
		mov	DPH,A
		
		clr	A
		movc	A,@A+DPTR
		cjne    A,#0FFh,_may_correctd
_non_correct:	
		mov	A,#0FFh
		ljmp	C_BCH_End
_may_correctd:  
		mov	R0,A   ; error 1 position
		clr	A
		inc	DPTR
		movc	A,@A+DPTR
		cjne	A,#0FFh,_double_err
_correct_1:	
		mov	A,R0
		lcall	_invertbit
		inc	R7
		cjne	R6,#1,_err_parity  ; if parity == 0 then correct it
		
		sjmp	_result
_double_err:    
		cjne	R6,#0,_non_correct ; if 2 errors - parity must be 0 
		
		xch	A,R0
		lcall	_invertbit
		mov	A,R0
		lcall	_invertbit
		mov	A,#2		
C_BCH_End:
		mov	ErrorsBCH,A
		ret
;----------------------------------------------------------		
_invertbit:	
		mov	R2,A
		anl	A,#7
		mov	DPTR,#MaskByte
		movc	A,@A+DPTR
		xch	A,R2
  		rr	A
		rr	A
		rr	A
		anl	A,#3
		
		cpl	A
		add	A,#4

		mov	R1,#BCH3
		add	A,R1
		mov	R1,A
		mov	A,R2
		xrl	A,@R1
		mov	@R1,A
		ret

MaskByte:	db 1,2,4,8,10h,20h,40h,80h
;----------------------------------------------------------		
CrcTable:

	db 000h,000h
	db 040h,0dah
	db 0c0h,06eh
	db 080h,0b4h
	db 080h,0ddh
	db 0c0h,007h
	db 040h,0b3h
	db 000h,069h
	db 040h,061h
	db 000h,0bbh
	db 080h,00fh
	db 0c0h,0d5h
	db 0c0h,0bch
	db 080h,066h
	db 000h,0d2h
	db 040h,008h
	db 080h,0c2h
	db 0c0h,018h
	db 040h,0ach
	db 000h,076h
	db 000h,01fh
	db 040h,0c5h
	db 0c0h,071h
	db 080h,0abh
	db 0c0h,0a3h
	db 080h,079h
	db 000h,0cdh
	db 040h,017h
	db 040h,07eh
	db 000h,0a4h
	db 080h,010h
	db 0c0h,0cah
	db 040h,05fh
	db 000h,085h
	db 080h,031h
	db 0c0h,0ebh
	db 0c0h,082h
	db 080h,058h
	db 000h,0ech
	db 040h,036h
	db 000h,03eh
	db 040h,0e4h
	db 0c0h,050h
	db 080h,08ah
	db 080h,0e3h
	db 0c0h,039h
	db 040h,08dh
	db 000h,057h
	db 0c0h,09dh
	db 080h,047h
	db 000h,0f3h
	db 040h,029h
	db 040h,040h
	db 000h,09ah
	db 080h,02eh
	db 0c0h,0f4h
	db 080h,0fch
	db 0c0h,026h
	db 040h,092h
	db 000h,048h
	db 000h,021h
	db 040h,0fbh
	db 0c0h,04fh
	db 080h,095h
	db 080h,0beh
	db 0c0h,064h
	db 040h,0d0h
	db 000h,00ah
	db 000h,063h
	db 040h,0b9h
	db 0c0h,00dh
	db 080h,0d7h
	db 0c0h,0dfh
	db 080h,005h
	db 000h,0b1h
	db 040h,06bh
	db 040h,002h
	db 000h,0d8h
	db 080h,06ch
	db 0c0h,0b6h
	db 000h,07ch
	db 040h,0a6h
	db 0c0h,012h
	db 080h,0c8h
	db 080h,0a1h
	db 0c0h,07bh
	db 040h,0cfh
	db 000h,015h
	db 040h,01dh
	db 000h,0c7h
	db 080h,073h
	db 0c0h,0a9h
	db 0c0h,0c0h
	db 080h,01ah
	db 000h,0aeh
	db 040h,074h
	db 0c0h,0e1h
	db 080h,03bh
	db 000h,08fh
	db 040h,055h
	db 040h,03ch
	db 000h,0e6h
	db 080h,052h
	db 0c0h,088h
	db 080h,080h
	db 0c0h,05ah
	db 040h,0eeh
	db 000h,034h
	db 000h,05dh
	db 040h,087h
	db 0c0h,033h
	db 080h,0e9h
	db 040h,023h
	db 000h,0f9h
	db 080h,04dh
	db 0c0h,097h
	db 0c0h,0feh
	db 080h,024h
	db 000h,090h
	db 040h,04ah
	db 000h,042h
	db 040h,098h
	db 0c0h,02ch
	db 080h,0f6h
	db 080h,09fh
	db 0c0h,045h
	db 040h,0f1h
	db 000h,02bh
	db 040h,0a7h
	db 000h,07dh
	db 080h,0c9h
	db 0c0h,013h
	db 0c0h,07ah
	db 080h,0a0h
	db 000h,014h
	db 040h,0ceh
	db 000h,0c6h
	db 040h,01ch
	db 0c0h,0a8h
	db 080h,072h
	db 080h,01bh
	db 0c0h,0c1h
	db 040h,075h
	db 000h,0afh
	db 0c0h,065h
	db 080h,0bfh
	db 000h,00bh
	db 040h,0d1h
	db 040h,0b8h
	db 000h,062h
	db 080h,0d6h
	db 0c0h,00ch
	db 080h,004h
	db 0c0h,0deh
	db 040h,06ah
	db 000h,0b0h
	db 000h,0d9h
	db 040h,003h
	db 0c0h,0b7h
	db 080h,06dh
	db 000h,0f8h
	db 040h,022h
	db 0c0h,096h
	db 080h,04ch
	db 080h,025h
	db 0c0h,0ffh
	db 040h,04bh
	db 000h,091h
	db 040h,099h
	db 000h,043h
	db 080h,0f7h
	db 0c0h,02dh
	db 0c0h,044h
	db 080h,09eh
	db 000h,02ah
	db 040h,0f0h
	db 080h,03ah
	db 0c0h,0e0h
	db 040h,054h
	db 000h,08eh
	db 000h,0e7h
	db 040h,03dh
	db 0c0h,089h
	db 080h,053h
	db 0c0h,05bh
	db 080h,081h
	db 000h,035h
	db 040h,0efh
	db 040h,086h
	db 000h,05ch
	db 080h,0e8h
	db 0c0h,032h
	db 0c0h,019h
	db 080h,0c3h
	db 000h,077h
	db 040h,0adh
	db 040h,0c4h
	db 000h,01eh
	db 080h,0aah
	db 0c0h,070h
	db 080h,078h
	db 0c0h,0a2h
	db 040h,016h
	db 000h,0cch
	db 000h,0a5h
	db 040h,07fh
	db 0c0h,0cbh
	db 080h,011h
	db 040h,0dbh
	db 000h,001h
	db 080h,0b5h
	db 0c0h,06fh
	db 0c0h,006h
	db 080h,0dch
	db 000h,068h
	db 040h,0b2h
	db 000h,0bah
	db 040h,060h
	db 0c0h,0d4h
	db 080h,00eh
	db 080h,067h
	db 0c0h,0bdh
	db 040h,009h
	db 000h,0d3h
	db 080h,046h
	db 0c0h,09ch
	db 040h,028h
	db 000h,0f2h
	db 000h,09bh
	db 040h,041h
	db 0c0h,0f5h
	db 080h,02fh
	db 0c0h,027h
	db 080h,0fdh
	db 000h,049h
	db 040h,093h
	db 040h,0fah
	db 000h,020h
	db 080h,094h
	db 0c0h,04eh
	db 000h,084h
	db 040h,05eh
	db 0c0h,0eah
	db 080h,030h
	db 080h,059h
	db 0c0h,083h
	db 040h,037h
	db 000h,0edh
	db 040h,0e5h
	db 000h,03fh
	db 080h,08bh
	db 0c0h,051h
	db 0c0h,038h
	db 080h,0e2h
	db 000h,056h
	db 040h,08ch

SyndTable:

	db 0ffh,0ffh
	db 015h,0ffh
	db 016h,0ffh
	db 016h,015h
	db 017h,0ffh
	db 017h,015h
	db 017h,016h
	db 0ffh,0ffh
	db 018h,0ffh
	db 018h,015h
	db 018h,016h
	db 0ffh,0ffh
	db 018h,017h
	db 011h,009h
	db 0ffh,0ffh
	db 010h,00bh
	db 019h,0ffh
	db 019h,015h
	db 019h,016h
	db 00ch,009h
	db 019h,017h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,018h
	db 00eh,001h
	db 012h,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 011h,00ch
	db 01fh,002h
	db 01ah,0ffh
	db 01ah,015h
	db 01ah,016h
	db 0ffh,0ffh
	db 01ah,017h
	db 0ffh,0ffh
	db 00dh,00ah
	db 00eh,003h
	db 01ah,018h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,019h
	db 0ffh,0ffh
	db 00fh,002h
	db 0ffh,0ffh
	db 013h,00bh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 013h,010h
	db 012h,00dh
	db 0ffh,0ffh
	db 003h,001h
	db 0ffh,0ffh
	db 01bh,0ffh
	db 01bh,015h
	db 01bh,016h
	db 010h,00eh
	db 01bh,017h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,018h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00eh,00bh
	db 0ffh,0ffh
	db 00fh,004h
	db 0ffh,0ffh
	db 01bh,019h
	db 01ch,00dh
	db 0ffh,0ffh
	db 01eh,008h
	db 0ffh,0ffh
	db 00bh,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 013h,003h
	db 01bh,01ah
	db 013h,001h
	db 0ffh,0ffh
	db 01fh,004h
	db 010h,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 007h,006h
	db 014h,00ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00bh,003h
	db 0ffh,0ffh
	db 01ch,012h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,011h
	db 01ch,00ah
	db 013h,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,009h
	db 004h,002h
	db 01dh,005h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,0ffh
	db 01ch,015h
	db 01ch,016h
	db 0ffh,0ffh
	db 01ch,017h
	db 01dh,003h
	db 011h,00fh
	db 0ffh,0ffh
	db 01ch,018h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00fh,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,019h
	db 01bh,00dh
	db 0ffh,0ffh
	db 00bh,005h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00fh,00ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,005h
	db 01eh,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,01ah
	db 0ffh,0ffh
	db 01dh,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,009h
	db 013h,005h
	db 0ffh,0ffh
	db 008h,006h
	db 00ch,002h
	db 01fh,011h
	db 0ffh,0ffh
	db 01bh,012h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 011h,002h
	db 01fh,00ch
	db 0ffh,0ffh
	db 01bh,00ah
	db 0ffh,0ffh
	db 009h,002h
	db 0ffh,0ffh
	db 01dh,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,004h
	db 0ffh,0ffh
	db 01ch,01bh
	db 019h,00dh
	db 014h,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 009h,004h
	db 005h,001h
	db 0ffh,0ffh
	db 011h,004h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,012h
	db 008h,007h
	db 0ffh,0ffh
	db 015h,00dh
	db 00dh,0ffh
	db 0ffh,0ffh
	db 016h,00dh
	db 0ffh,0ffh
	db 017h,00dh
	db 00ch,004h
	db 01ah,00ah
	db 0ffh,0ffh
	db 018h,00dh
	db 01dh,013h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,014h
	db 0ffh,0ffh
	db 00eh,005h
	db 0ffh,0ffh
	db 01dh,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 018h,012h
	db 0ffh,0ffh
	db 019h,00ah
	db 0ffh,0ffh
	db 017h,012h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 015h,012h
	db 012h,0ffh
	db 01dh,00bh
	db 016h,012h
	db 014h,00fh
	db 01ah,00dh
	db 0ffh,0ffh
	db 017h,00ah
	db 0ffh,0ffh
	db 016h,00ah
	db 015h,00ah
	db 00ah,0ffh
	db 005h,003h
	db 0ffh,0ffh
	db 01eh,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,012h
	db 0ffh,0ffh
	db 018h,00ah
	db 01dh,0ffh
	db 01dh,015h
	db 01dh,016h
	db 012h,00bh
	db 01dh,017h
	db 01ch,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,018h
	db 0ffh,0ffh
	db 01eh,004h
	db 013h,00dh
	db 012h,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,019h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,00ah
	db 00fh,008h
	db 0ffh,0ffh
	db 00bh,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,01ah
	db 0ffh,0ffh
	db 01ch,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 008h,002h
	db 00ch,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 013h,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,00dh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 009h,006h
	db 0ffh,0ffh
	db 013h,012h
	db 011h,006h
	db 0ffh,0ffh
	db 01fh,008h
	db 01ch,001h
	db 0ffh,0ffh
	db 01bh,005h
	db 0ffh,0ffh
	db 00dh,00bh
	db 01dh,01bh
	db 00ch,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00ah,001h
	db 0ffh,0ffh
	db 014h,006h
	db 012h,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 009h,007h
	db 0ffh,0ffh
	db 00dh,003h
	db 00eh,00ah
	db 012h,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 008h,004h
	db 01ch,013h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,005h
	db 0ffh,0ffh
	db 011h,007h
	db 0ffh,0ffh
	db 01ch,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 012h,003h
	db 01fh,01eh
	db 00dh,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,005h
	db 01ch,00bh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00ah,003h
	db 00eh,00dh
	db 0ffh,0ffh
	db 018h,005h
	db 01eh,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 017h,005h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 015h,005h
	db 005h,0ffh
	db 0ffh,0ffh
	db 016h,005h
	db 01dh,01ch
	db 017h,003h
	db 01ah,00eh
	db 0ffh,0ffh
	db 015h,003h
	db 003h,0ffh
	db 0ffh,0ffh
	db 016h,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00ah,005h
	db 0ffh,0ffh
	db 006h,002h
	db 018h,003h
	db 0ffh,0ffh
	db 00ch,008h
	db 012h,005h
	db 011h,008h
	db 0ffh,0ffh
	db 01fh,006h
	db 0ffh,0ffh
	db 019h,003h
	db 0ffh,0ffh
	db 007h,004h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,013h
	db 01ah,001h
	db 009h,008h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,00eh
	db 01bh,010h
	db 00eh,0ffh
	db 015h,00eh
	db 0ffh,0ffh
	db 01ah,003h
	db 017h,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 018h,00eh
	db 019h,001h
	db 00dh,005h
	db 0ffh,0ffh
	db 01bh,00bh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,00eh
	db 018h,001h
	db 01eh,014h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,001h
	db 015h,001h
	db 001h,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00fh,006h
	db 017h,001h
	db 0ffh,0ffh
	db 01ah,010h
	db 01eh,011h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,013h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,00bh
	db 01eh,009h
	db 0ffh,0ffh
	db 01dh,00dh
	db 018h,013h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,013h
	db 00fh,007h
	db 013h,0ffh
	db 015h,013h
	db 01eh,00ch
	db 0ffh,0ffh
	db 017h,013h
	db 0ffh,0ffh
	db 015h,010h
	db 010h,0ffh
	db 01bh,00eh
	db 016h,010h
	db 0ffh,0ffh
	db 017h,010h
	db 018h,00bh
	db 014h,008h
	db 0ffh,0ffh
	db 018h,010h
	db 017h,00bh
	db 007h,002h
	db 016h,00bh
	db 01dh,012h
	db 00bh,0ffh
	db 015h,00bh
	db 006h,004h
	db 019h,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,013h
	db 01bh,001h
	db 0ffh,0ffh
	db 01ch,005h
	db 019h,00bh
	db 0ffh,0ffh
	db 01eh,0ffh
	db 01eh,015h
	db 01eh,016h
	db 0ffh,0ffh
	db 01eh,017h
	db 0ffh,0ffh
	db 013h,00ch
	db 0ffh,0ffh
	db 01eh,018h
	db 0ffh,0ffh
	db 01dh,004h
	db 005h,002h
	db 0ffh,0ffh
	db 00ah,006h
	db 0ffh,0ffh
	db 014h,001h
	db 01eh,019h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,008h
	db 01fh,005h
	db 013h,009h
	db 014h,00eh
	db 012h,006h
	db 013h,011h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,01ah
	db 00bh,009h
	db 0ffh,0ffh
	db 011h,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00dh,006h
	db 011h,00bh
	db 0ffh,0ffh
	db 010h,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,003h
	db 00ch,00bh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00fh,005h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,00ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,01bh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,008h
	db 01dh,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 011h,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 009h,003h
	db 0ffh,0ffh
	db 00dh,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,008h
	db 015h,008h
	db 008h,0ffh
	db 0ffh,0ffh
	db 014h,010h
	db 0ffh,0ffh
	db 017h,008h
	db 0ffh,0ffh
	db 00ch,003h
	db 014h,00bh
	db 018h,008h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 011h,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00ch,001h
	db 0ffh,0ffh
	db 01fh,01dh
	db 00ah,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00eh,009h
	db 014h,013h
	db 0ffh,0ffh
	db 012h,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,008h
	db 009h,001h
	db 0ffh,0ffh
	db 01dh,002h
	db 005h,004h
	db 0ffh,0ffh
	db 011h,001h
	db 01ch,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00eh,00ch
	db 0ffh,0ffh
	db 01eh,01ch
	db 0ffh,0ffh
	db 00dh,008h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,00bh
	db 01fh,010h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,007h
	db 0ffh,0ffh
	db 004h,003h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 018h,007h
	db 0ffh,0ffh
	db 010h,002h
	db 00bh,002h
	db 017h,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 015h,007h
	db 007h,0ffh
	db 013h,00fh
	db 016h,007h
	db 0ffh,0ffh
	db 00ch,005h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00ah,008h
	db 010h,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00eh,004h
	db 0ffh,0ffh
	db 00fh,00bh
	db 0ffh,0ffh
	db 013h,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 004h,001h
	db 009h,005h
	db 01fh,013h
	db 01dh,014h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,007h
	db 012h,008h
	db 011h,005h
	db 0ffh,0ffh
	db 00fh,003h
	db 01dh,011h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 014h,005h
	db 0ffh,0ffh
	db 01fh,00eh
	db 0ffh,0ffh
	db 002h,001h
	db 0ffh,0ffh
	db 01dh,009h
	db 013h,004h
	db 01eh,00dh
	db 01fh,001h
	db 01ch,008h
	db 00eh,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,006h
	db 0ffh,0ffh
	db 01dh,00ch
	db 01bh,007h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00bh,004h
	db 0ffh,0ffh
	db 00fh,00eh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,006h
	db 010h,004h
	db 01fh,003h
	db 01eh,012h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 018h,006h
	db 003h,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,00ah
	db 016h,006h
	db 0ffh,0ffh
	db 006h,0ffh
	db 015h,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 017h,006h
	db 00fh,001h
	db 01eh,01dh
	db 0ffh,0ffh
	db 018h,004h
	db 0ffh,0ffh
	db 01bh,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,004h
	db 0ffh,0ffh
	db 004h,0ffh
	db 015h,004h
	db 0ffh,0ffh
	db 00dh,00ch
	db 017h,004h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 011h,00dh
	db 00bh,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 007h,003h
	db 0ffh,0ffh
	db 019h,004h
	db 010h,006h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00dh,009h
	db 0ffh,0ffh
	db 013h,006h
	db 0ffh,0ffh
	db 012h,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 007h,001h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,01bh
	db 01ah,004h
	db 00ch,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 008h,005h
	db 012h,011h
	db 0ffh,0ffh
	db 012h,00ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,014h
	db 011h,00ah
	db 01bh,002h
	db 0ffh,0ffh
	db 00ah,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00eh,007h
	db 017h,00fh
	db 006h,001h
	db 01ch,011h
	db 014h,00ah
	db 00fh,0ffh
	db 015h,00fh
	db 016h,00fh
	db 013h,007h
	db 0ffh,0ffh
	db 01fh,01ah
	db 01bh,004h
	db 0ffh,0ffh
	db 018h,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,008h
	db 019h,00fh
	db 0ffh,0ffh
	db 01ah,002h
	db 0ffh,0ffh
	db 00eh,006h
	db 014h,012h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ch,00ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01fh,018h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,00fh
	db 014h,00dh
	db 019h,002h
	db 0ffh,0ffh
	db 01fh,015h
	db 01fh,0ffh
	db 0ffh,0ffh
	db 01fh,016h
	db 0ffh,0ffh
	db 01fh,017h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 017h,002h
	db 00bh,007h
	db 016h,002h
	db 0ffh,0ffh
	db 002h,0ffh
	db 015h,002h
	db 0ffh,0ffh
	db 01fh,019h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 010h,007h
	db 01eh,005h
	db 018h,002h
	db 006h,003h
	db 0ffh,0ffh
	db 00ah,002h
	db 01bh,011h
	db 0ffh,0ffh
	db 01fh,012h
	db 01eh,003h
	db 0ffh,0ffh
	db 006h,005h
	db 0ffh,0ffh
	db 013h,008h
	db 01ch,004h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01ah,014h
	db 00fh,00dh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 012h,002h
	db 01bh,00ch
	db 01dh,007h
	db 01fh,00ah
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,00eh
	db 0ffh,0ffh
	db 019h,014h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 00dh,002h
	db 0ffh,0ffh
	db 012h,00fh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 017h,014h
	db 0ffh,0ffh
	db 010h,008h
	db 00fh,00ah
	db 014h,0ffh
	db 015h,014h
	db 016h,014h
	db 0ffh,0ffh
	db 01fh,00dh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,001h
	db 018h,014h
	db 00bh,008h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 016h,011h
	db 0ffh,0ffh
	db 011h,0ffh
	db 015h,011h
	db 01ch,00fh
	db 0ffh,0ffh
	db 017h,011h
	db 018h,009h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 018h,011h
	db 017h,009h
	db 019h,00ch
	db 016h,009h
	db 015h,009h
	db 009h,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 019h,011h
	db 0ffh,0ffh
	db 018h,00ch
	db 0ffh,0ffh
	db 008h,003h
	db 0ffh,0ffh
	db 017h,00ch
	db 0ffh,0ffh
	db 01eh,013h
	db 00dh,004h
	db 00ch,0ffh
	db 015h,00ch
	db 016h,00ch
	db 019h,009h
	db 007h,005h
	db 01eh,010h
	db 01ah,011h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 012h,004h
	db 008h,001h
	db 01fh,01ch
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01eh,00bh
	db 01ah,009h
	db 0ffh,0ffh
	db 00eh,008h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01bh,014h
	db 0ffh,0ffh
	db 01ch,002h
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 0ffh,0ffh
	db 01dh,006h
	db 0ffh,0ffh
	db 01ah,00ch
	db 00ah,004h
	db 0ffh,0ffh
	db 0ffh,0ffh
;====================================================================

