#ifndef _VSTTYPE_H
#define _VSTTYPE_H

/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


struct tag_mapdata {
    long        m_version;
	long		m_RFU0;                     /* true if part of world map*/
	double		m_minx;                     /* lowest x coordinate		*/
	double		m_miny;                     /* lowest y coordinate		*/
	double		m_maxx;                     /* highest x coordinate		*/
	double		m_maxy;                     /* highest y coordinate		*/
	long        m_RFU1[22];                 /* Reserved for future use  */
};

typedef struct tag_mapdata  mapdata_t;

struct tag_mapsuffix {
     int        ms_x, ms_y;    /* Screen resolution for map    */
     char       *ms_suffix;     /* suffix to add to file name   */
};

typedef struct tag_mapsuffix mapsuffix_t;

typedef struct tag_site {
	char		   *c_name;	                /* name		                    */
	char		   *c_locale;               /* state or country name        */
	char            c_tzname[4];            /* time zone string             */
	double		    c_lat;	                /* latitude, radians    	    */
	double		    c_lng;	                /* longitude, radians   	    */
	double		    c_alt;	                /* elevation, meters		    */
    double          c_vecX;                 /* for squint angle calcs.      */
    double          c_vecY;                 /*     "   "      "     "       */
    double          c_vecZ;                 /*     "   "      "     "       */
    double          c_timezone;             /* hours.fractions diff with UTC*/
	int             c_lbid;                 /* item id in the list box      */
	struct tag_site *c_next;                /* ptr to next city in link list*/
	void           *c_adjunct;              /* RFU                          */
} site_t;

typedef struct tag_satellite {
	char		    s_name[32];         	/* satellite name		        */
	char            s_epochstr[28];         /* string equivalent of epoch   */
	long		    s_satnum;               /* catalog number		        */
	long    	    s_elementset;           /* element set number           */
	long    	    s_orbitnum;             /* epoch revolution             */
	long            s_beacon;               /* beacon frequency (MHz)       */
	double		    s_epochyear;            /* epoch year                   */
	double		    s_epochtime;            /* epoch time (julian day & fraction */
    double		    s_decayrate;            /* orbit decay rate		        */
	double		    s_inclination;          /* orbital inclination		    */
	double		    s_raan;                 /* right ascension		        */
	double		    s_eccentricity;         /* orbit eccentricity		    */
	double		    s_argperigee;	        /* arg of perigee               */
	double		    s_meananomaly;	        /* mean anomaly                 */
	double		    s_meanmotion;	        /* mean motion                  */
	double          s_ephemeristype;        /* what it is                   */
	double          s_dratedot;             /* 2nd time derivate of drag    */
	double          s_bstarcoeff;           /* B-star coefficient           */
	short           s_lbid;                 /* id in the list box           */
	short           s_flags;                /* flags                        */
	long            s_RFU[2];               /* RFU                          */
    struct tag_mode *s_modep;               /* ptr to mode struct if any    */
	struct tag_satellite *s_next;           /* ptr to next entry in the list*/
} satellite_t;


#define MAXMODES    10

typedef struct tag_moderec {
    int         minPhase;
    int         maxPhase;
    char        modeStr[4];
} moderec_t;

typedef struct tag_mode {
    char        alias[38];
    double      beacon;
    double      perigeePhase;
    double      maxPhase;
    double      attVecX, attVecY, attVecZ;
    int         nmodes;
    void        *m_adjunct;  /* RFU */
    moderec_t   mds[MAXMODES];
} mode_t;

typedef struct tag_mapdata  mapdata_t;

typedef struct tag_rotinfo {
    char       rot_name[32];
    char       rot_driver[64];
    int        rot_index;
    struct tag_rotinfo *rot_next;
} rotinfo_t;

typedef struct tag_radinfo {
    char       rad_name[32];
    char       rad_driver[64];
    int        rad_index;
    struct tag_radinfo *rad_next;
} radinfo_t;

struct tag_trackparams {
    site_t          *sitep;
    satellite_t     *satp;
    char            *satname;
    int              flags;
    int              satnum;
    int              elementset;
    short            launchflag;
    short            orbitfrac;
    int              orbitnum;
    int              phase;
    float            minelevation;
    double           epochday;
    double           inclination;
    double           epochRAAN;
    double           eccentricity;
    double           epochargperigee;
    double           epochmeananomaly;
    double           meananomaly;
    double           trueanomaly;
    double           epochmeanmotion;
    double           decayrate;
    double           epochorbitnum;
    double           beacon;
    double           perigeephase;
    double           maxphase;
    double           semimajoraxis;
    double           RAANprec;
    double           perigeeprec;
    double           reforbit;
    double           sitemat[3][3];
    double           duration;
    double           steptime;
    double           starttime;
    double           stoptime;
    double           timezone;
    double           sidday;
    double           sidtime;
    double           equinox;
    double           lastime;
    double           gastime;
    double           juliandate;
    double           lastjdate;
    double           lastsuntime;
    double           lastprectime;
    double           sunepochtime;
    double           suninclination;
    double           sunRAAN;
    double           sunmeananomaly;
    double           suntrueanomaly;
    double           sundistance;
    double           sunmeanmotion;
    double           suneccentricity;
    double           sunargperigee;
    double           sunazimuth;
    double           sunelevation;
    long             RFU[6];
};

typedef struct tag_trackparams  track_t;

struct  tag_result {
    double           r_time;
    double           r_range;
    double           r_height;
    double           r_rangerate;
    double           r_av;
    float            r_azimuth;
    float            r_elevation;
    float            r_pelev;
    float            r_lat;
    float            r_long;
    float            r_doppler;
    float            r_pathloss;
    float            r_squint;
    short            r_orbitnum;
    short            r_phase;
    char             r_viswarn;
    char             r_rising;
    char             r_insun;
    char             r_modestr[3];
    long             r_RFU[4];
};


typedef struct tag_result   result_t;


struct  tag_selection { 
    int              sl_index;
    track_t         *sl_tp;
    result_t        *sl_rp;
    char             sl_itemp[17*20];
    char             sl_buf[82];
    HWND             rtdhwnd;
    HANDLE           rtd_thread_handle;
    double           simtime;
    short            satx;
    short            saty;
    short            dsatx;
    short            dsaty;
#ifndef NOVISCIR
    short            satavx, satavy;
    short            dsatavx, dsatavy;
#endif
    short            ticks;
    short            updatetime;
    int              timerid;
    char             timeron, terminate, first, running;
    int              flags;
    CRITICAL_SECTION rtd_mutex;
    long             RFU[4];
    struct tag_selection *sl_next;
};

typedef struct tag_selection select_t;

struct tag_reginfo {
    char    *ri_msgstring;
    char    *ri_basekey;
    char    *ri_subkey1;
    char    *ri_subkey2;
    char    *ri_subkey3;
    char    *ri_username;
};

typedef struct tag_reginfo reginfo_t;

struct tag_registry {
    char            *st_message;
    char            *st_default;
    char            *st_keyvalue;
    int              st_maxkeylen;
    int              st_keylen;
    char            *st_keyname;
    int              st_keytype;
};

typedef struct tag_registry registry_t;


typedef struct tag_exserver {
    char       *srv_libfun;
    char       *srv_pipename;
    int         srv_state;
    int         srv_flags;
    int         srv_seq;
    select_t   *srv_sp;
    void       *srv_vp;
    HANDLE      srv_thread_handle;
    HANDLE      srv_hpipe;
    HANDLE      srv_RdEvent;
    HANDLE      srv_WrEvent;
    OVERLAPPED  srv_RdOverlap;
    OVERLAPPED  srv_WrOverlap;
    void        (*srv_fmtproc)(int, int, struct tag_exserver *,
                 select_t *, char *);
    void       *srv_adjunct;    /* RFU */
} exserver_t;


#endif /* _VSTTYPE_H */
