#
#  %W% %E% %U%  [EXTREL_1.2]
# 
#  VersaTrack orbit calculations are based on those that appear in Dr. Manfred
#  Bester's sattrack program (the Unix(tm) version, circa 1992).
# 
#  The data from which the maps where generated come from "xsat", an
#  X-Windows program by David A. Curry (N9MSW).
# 
#  Site coordinates come from various sources, including a couple of
#  World Almanacs, and also from both of the programs mentioned above.
# 
#  The following are authors' applicable copyright notices:
# 
#                                                                                
#  Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
#                                                                            
#  Permission to use, copy, modify, and distribute this software and its      
#  documentation for educational, research and non-profit purposes, without   
#  fee, and without a written agreement is hereby granted, provided that the  
#  above copyright notice and the following three paragraphs appear in all    
#  copies.                                                                    
#                                                                               
#  Permission to incorporate this software into commercial products may be    
#  obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
#  Berkeley, CA 94709, USA.                                                   
#                                                                              
#  IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
#  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
#  THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
#  OF THE POSSIBILITY OF SUCH DAMAGE.                                         
#                                                                              
#  THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
#  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
#  PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
#  BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
#  UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
#                                                                              
#                                                                              
#  Copyright 1992 by David A. Curry                                            
#                                                                              
#  Permission to use, copy, modify, distribute, and sell this software and its 
#  documentation for any purpose is hereby granted without fee, provided that  
#  the above copyright notice appear in all copies and that both that copyright
#  notice and this permission notice appear in supporting documentation.  The  
#  author makes no representations about the suitability of this software for  
#  any purpose.  It is provided "as is" without express or implied warranty.   
#                                                                              
#  David A. Curry, N9MSW                                                       
#  Purdue University                                                           
#  Engineering Computer Network                                                
#  1285 Electrical Engineering Building                                        
#  West Lafayette, IN 47907                                                    
#  davy@ecn.purdue.edu                                                         
#                                                                              
#  VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
# 
#  Permission is hereby granted to copy, modify and distribute VersaTrack
#  in whole, or in part, for educational, non-profit and non-commercial use
#  only, free of charge or obligation, and without agreement, provided that
#  all copyrights and restrictions noted herein are observed and followed, and
#  additionally, that this and all other copyright notices listed herein
#  appear unaltered in all copies and in all derived work.
# 
#  This notice shall not in any way void or supersede any of the other authors
#  rights or privileges.
# 
#  VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
#  YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
#  direct, indirect, incidental, or consequential damage, loss of profits or
#  other tangible or intangible losses or benefits, arising out of or related
#  to its use. VersaTrack carries no warranty, explicit or implied, including
#  but not limited to those of merchantablity and fitness for a particular
#  purpose.
# 
#  Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
#  sia@bga.com or sia@realtime.com.
#
#############################################################################
#
#
#  Makefile for VersaTrack.
#  For a full description of legal notices please see the source files.
#  This makefile is intended for use with manual invocation of the nmake util.
#  (as opposed to using it through WIN SDK or equivalent)
#
#  VALID MAKE TARGETS ARE:
#   <null>      : build and leave results in current directory.
#   all or test : same as <null>.
#   install     : build in current directory and install in $(INSTALLDIR)
#   clean       : clean up .obj's and other files that can be built from
#                 sources - .map files are not deleted.
#   clobber     : clean up and also remove the executables, .dll's, and .map's.
#   backup      : copy all source files to floppy in A:
#   zip         : archive all source files in a .zip file. Includes all the
#                 makefile, resource files, icons, etc. PKZIP must be accessible
#                 for this to work.
#
#

PROJ       = vst
EXENAME    = versatrk
DLLNAME    = dbread
DEBUG      = 0
INSTALLDIR = \vst
#
## Define  CVER = -DWINNT_31   if to be run under windows nt 3.1
#
CVER	   =
MAKE = nmake -e
CC   = cl
CPP  = cl
RC   = rc
.SUFFIXES:	.dib .map

CFLAGS_D_WEXE  = -nologo -W3 -D_X86_ -D_DEBUG_ -D_WINDOWS -DWIN32 $(CVER)
CFLAGS_R_WEXE  = -nologo -W3 -D_X86_ -DNDEBUG -D_WINDOWS -DWIN32 $(CVER)
# can we set debugtype to coff? elf? dwarf?
LFLAGS_D_WEXE  = -nologo -map -debug -debugtype:cv -subsystem:windows
LFLAGS_R_WEXE  = -nologo -map -subsystem:windows
LFLAGS_D_LIB   = -nologo
LFLAGS_R_LIB   = -nologo
LIBS_D_WEXE    = user32.lib gdi32.lib advapi32.lib wsock32.lib
LIBS_R_WEXE    = user32.lib gdi32.lib advapi32.lib wsock32.lib
D_RCDEFINES    = -D_DEBUG_
R_RCDEFINES    = -DNDEBUG
RCFLAGS        = -D_WINDOWS -DWIN32
MAKEFLAGS      = L E
CC_D_OPTIM     = -Ox
CC_R_OPTIM     = -Ox

!if "$(DEBUG)" == "1"

OBJS_EXT       = $(OBJS1) $(OBJS_DEBUG)
CFLAGS         = $(CFLAGS_D_WEXE) $(CC_D_OPTIM)
CFLAGSX        = $(CFLAGS_D_WEXE)
LFLAGS         = $(LFLAGS_D_WEXE)
LIBS           = $(LIBS_D_WEXE)
LFLAGS_LIB     = $(LFLAGS_D_LIB)
RCDEFINES      = $(RCFLAGS) $(D_RCDEFINES)

!else

OBJS_EXT       = $(OBJS1)
CFLAGS         = $(CFLAGS_R_WEXE) $(CC_R_OPTIM)
CFLAGSX        = $(CFLAGS_R_WEXE)
LFLAGS         = $(LFLAGS_R_WEXE)
LIBS           = $(LIBS_R_WEXE)
LFLAGS_LIB     = $(LFLAGS_R_LIB)
RCDEFINES      = $(RCFLAGS) $(R_RCDEFINES)

!endif

OBJS1 = \
    init.obj \
    dialogs.obj \
    satsite.obj \
    rtd.obj \
    select.obj \
    compute.obj \
    vstnute.obj \
    vstsgp4.obj \
    vstsqnt.obj \
    vstdate.obj \
    track.obj \
    rst.obj \
    util.obj \
    rotator.obj \
    colors.obj \
    error.obj

OBJS_DEBUG = prf.obj

DEPS   =  \
    vstdefs.h \
    vsttype.h \
    vstextrn.h \
    vstdib.h

LIBS_EXT = 

MAP1 = world86.map
MAP2 = world64.map
MAP3 = usa86.map
MAP4 = usa64.map
MAPS = $(MAP1) $(MAP2) $(MAP3) $(MAP4)


all test:	the_dll $(EXENAME).exe $(MAPS)

the_dll:
    @cd lib
    @$(MAKE) "DEBUG=$(DEBUG)" "CVER=$(CVER)" "INSTALLDIR=$(INSTALLDIR)"
    @cd ..

#gendate.exe:    gendate.c $(DEPSS)
#    $(CC) $(CFLAGS) gendate.c -o gendate.exe
#   -@del gendate.obj

mapadj.exe:     mapadj.c vsttype.h
	$(CC) -nologo -Ox mapadj.c
	-@del mapadj.obj
        
vst.obj:	vst.c $(DEPS) resource.h

prf.obj:	prf.c $(DEPS)

dialogs.obj:	dialogs.c $(DEPS) resource.h

compute.obj:	compute.c $(DEPS)

vstsgp4.obj:	vstsgp4.c $(DEPS) vstprop.h

vstnute.obj:	vstnute.c $(DEPS)

vstsqnt.obj:	vstsqnt.c $(DEPS)

satsite.obj:	satsite.c $(DEPS) resource.h

select.obj:		select.c $(DEPS)

vstdate.obj:	vstdate.c $(DEPS)

rtd.obj:		rtd.c $(DEPS) resource.h

rst.obj:		rst.c $(DEPS) resource.h

util.obj:		util.c $(DEPS)

track.obj:		track.c $(DEPS)

error.obj:	error.c

rotator.obj:	rotator.c $(DEPS)
	$(CC) $(CFLAGSX) -c $*.c

init.obj:	init.c $(DEPS)

colors.obj:	colors.c $(DEPS) resource.h

error.obj:	error.c

$(PROJ).res:	vst.rc resource.h
	$(RC) $(RCDEFINES) -r vst.rc

$(MAPS):	mapadj.exe

.c.obj:
    $(CC) $(CFLAGS) -c $*.c

.dib.map:
	mapadj $*

$(EXENAME).exe:		$(PROJ).res vst.obj $(OBJS_EXT) $(LIBS_EXT)
	echo >NUL @<<$(PROJ).inp
vst.obj 
$(OBJS_EXT)
$(PROJ).res
-out:$(EXENAME).exe

$(LIBS)
$(LIBS_EXT)
$(DEFFILE_OPTION) -implib:$(PROJ).lib
<<
	link $(LFLAGS) @$(PROJ).inp

clean:
	-@del *.obj $(EXENAME).map *.res *.pch *.sbr *.aps *.log >NUL 2>NUL
	@cd lib
	@$(MAKE) clean
	@cd ..

clobber:	clean
	-@del $(EXENAME).exe gendate.exe mapadj.exe $(DLLNAME).dll >NUL 2>NUL
    -@del $(MAPS)
	@cd lib
	@$(MAKE) clobber
    @cd ..

install:	$(INSTALLDIR)\$(EXENAME).exe $(INSTALLDIR)\$(DLLNAME).dll \
	$(INSTALLDIR)\$(MAP1) $(INSTALLDIR)\$(MAP2) $(INSTALLDIR)\$(MAP3) \
	$(INSTALLDIR)\$(MAP4)
	copy $(EXENAME).exe $(INSTALLDIR)\*.* /v
	copy $(DLLNAME).dll  $(INSTALLDIR)\*.* /v
	copy $(MAP1) $(INSTALLDIR)\*.* /v
	copy $(MAP2) $(INSTALLDIR)\*.* /v
	copy $(MAP3) $(INSTALLDIR)\*.* /v
	copy $(MAP4) $(INSTALLDIR)\*.* /v
	copy doc.txt $(INSTALLDIR)\*.* /v
	copy *.dat $(INSTALLDIR)\*.* /v

backup:
	@backup.bat a:

zip:
	@srczip.bat

## End of Makefile
