/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#undef MIN
#define MIN(x,y)    (((x) < (y) ) ? (x) : (y))
static char *memmsg = "Can't allocate memory";

void
upperCase(string)
char *string;
{
    int i, l;
    l = strlen(string);
    for (i = 0; i < l; i++) {
        if (string[i] >= 'a' && string[i] <= 'z')
            string[i] -= 'a' - 'A';
    }
}


void
lowerCase(cp)
register char *cp;
{
    char *lastp;
    
    for (lastp = cp + strlen(cp); cp < lastp; cp++)
        if (*cp >= 'A' && *cp <= 'Z')
            *cp -= 'A' - 'a';
}


char *
stripLeadingSpace(cp)
register char *cp;
{
    while (cp && *cp && (*cp == ' ' || *cp == '\t' || *cp == '\n'))
        cp++;
    return cp;
}

void
stripTrailingSpace(s)
register char *s;
{
    register char *t;

    if (!s)
        return;
    t = s + strlen(s) - 1;
    while ((t >= s) && ((*t == ' ') || (*t == '\t') || (*t == '\n')))
    	t--;
    *(++t)= 0;
}

/*
 * Save a string in alloc'd memmory.
 */
char *
saveString(s)
char *s;
{   
    char *t;
    extern void fatal(char *);

    if ((t = (char *) (LPVOID) LocalAlloc(LMEM_FIXED, strlen(s)+1)) == NULL)
        fatal(memmsg);
    strcpy(t, s);
    return t;
}


/*
 * Allocate memory with error checking.
 */

void *
safeAlloc(size)
int size;
{
    char *p;
    extern void fatal(char *);

    if ((p = GlobalAlloc(GPTR, size)) == NULL)
        fatal(memmsg);
    return p;
}

void
safeFree(bufp)
void *bufp;
{
    if (bufp)
        LocalFree(bufp);
}

char *
ErrorString(int errcode)
{
    extern char *StrError(int);
	return StrError(errcode);
}


char *
getline(buf, size, fp)
char *buf;
int size;
FILE *fp;
{
    char *cp;

    if (!fp)
        return NULL;

    if (fgets(buf, size, fp) == NULL)
        return NULL;

    cp = stripLeadingSpace(buf);
    stripTrailingSpace(buf);
    return cp;
}


int
cistrcmp(src,dst)
char *src,*dst;
{
    char d[64],s[64];
    register char *dp, *sp;

    for (sp=s; sp<(s+63) && *src; src++) {
        if (*src == ' ' || *src == '\t')
            continue;
        if (isupper(*sp = *src))
            *sp = tolower(*sp);
        sp++;
    }
    *sp = 0;
    for (dp=d; dp<(d+63) && *dst; dst++) {
        if (*dst == ' ' || *dst == '\t')
            continue;
        if (isupper(*dp = *dst))
            *dp = tolower(*dp);
        dp++;
    }
    *dp = 0;
    return strcmp(s, d);
}

static HANDLE hlib;

void *
LibFunc(const char *fname)      /* DANGER: NOT re-entrant!!! */
{
    void *fp;
    extern void usermsg(const char *);
    extern char *dllloadmsg;
    extern char tmpbuf[], dllname[];

    if (!hlib) {
        hlib = LoadLibrary(dllname);
        if (!hlib) {
            sprintf(tmpbuf, "%s: error code %d", dllloadmsg,
				ErrorString(GetLastError()));
			usermsg(tmpbuf);
			return NULL;
		}
	}
	fp = GetProcAddress(hlib, fname);
	return fp;
}

void
LibClose()                      /* DANGER: NOT re-entrant!!! */
{
	if (!hlib) {
		FreeLibrary(hlib);
	    hlib = NULL;
	}
}

