/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"

static
int   month_days[] = { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };

long day_number(year,month,day)
int year, month, day;
{
    long result;
    
    if (year < 50)                 /* allows 4 or 2 digit year specifications */
        year += 2000;
    else
        if (year < 100)
            year += 1900;

    result = ((((long) year - 1901) * 1461) >> 2) 
             + month_days[month-1] + day + 365;

    if (year%4 == 0 && month > 2)         /* correct day number for leap year */
        result++;

    return result;
}

static void
daytoymdyd(daynum, year, month, day, yearday)
long daynum;
int  *year, *month, *day, *yearday;

{
    long Y;
    int  M, L;

    Y         = 4 * daynum;
    Y        /= 1461;
    daynum   -= 365 + (((Y - 1) * 1461) >> 2);
    *yearday  = daynum;
    L = 0;
    if (Y%4 == 0 && daynum > month_days[2])
        L = 1;
    M = 1;
    while (daynum > month_days[M] + L)
        M++;
    daynum -= (month_days[M-1]);
    if (M > 2)
        daynum -= L;
   
    *year  = Y + 1900;
    *month = M;
    *day   = daynum;
}

double
utctime()
{
    double daynum;
    double hour;
    SYSTEMTIME tm;

    GetSystemTime(&tm);

    daynum    = day_number(tm.wYear, tm.wMonth, tm.wDay);
    hour      = (double) tm.wHour + (double)tm.wMinute / 60.0 +
                (double) tm.wSecond/3600.0 + (double)tm.wMilliseconds / (3600.0 * 1000.0);
    return daynum + hour/24.0;
}

void UTCtimeStr(time,str)
double time;
char *str;
{
    double dayTime;
    long   dayNum;
    int    hours, mins, secs, dummyi;

    dayNum  = (long) time;
    dayTime = time - (double) dayNum;
    timetodhms(dayTime, &dummyi, &hours, &mins, &secs);
    sprintf(str,"%02d:%02d:%02d", hours, mins, secs);
}


static void
timetodhms(time, days, hours, mins, secs)
double time;
int    *days, *hours, *mins, *secs;

{
    double timed, timeh, timem, times;

    timed  = time;
    timeh  = 24.0 *   modf(timed,&timed);
    timem  = 60.0 *   modf(timeh,&timeh);
    times  = 60.0 *   modf(timem,&timem);
    times +=          modf(times,&times);

    if (fabs(times - 60.0) < 5.0e-4) {
        times  = 0.0;
        timem += 1.0;
        if (fabs(timem - 60.0) < 1.0e-4) {
            timem  = 0.0;
            timeh += 1.0;
            if (fabs(timeh - 24.0) < 1.0e-4) {
                timeh  = 0.0;
                timed += 1.0;
            }
        }
    }
    *days  = (int) timed;
    *hours = (int) timeh;
    *mins  = (int) timem;
    *secs  = (int) times;
}


void
UTCdateStr(time, string)
double time;  /* in day units + fractions */
char *string;
{
    double dayTime;
    long dayNum;
    int  day, month, year, yearDay, hours, mins, secs, idummy;

    dayNum = (long) time;
    daytoymdyd(dayNum, &year, &month, &day, &yearDay);
    dayTime = time - (double) dayNum;
    timetodhms(dayTime, &idummy, &hours, &mins, &secs);

    sprintf(string, "%02d/%02d/%02d %02d:%02d:%02d", month, day, year-1900,
        hours, mins, secs);
}


char *monthname(month)
int  month;
{
    static char *name[] = { "???", "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                            "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

    return (month < 1 || month > 12) ? name[0] : name[month];
}


double internalTime( yr, mon, day, hour, min, sec)
int yr, mon, day, hour, min, sec;
{
    double t, h;
    
    t  = (double) day_number(yr, mon, day);
    h  = (double) hour + (double) min / 60.0 + (double)sec / 3600.0;
    t += h / 24.0;
    
    return t;
}

 

