/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"

BOOL
RotatorControl(version, hwnd, sp, vp)
int version;
HWND hwnd;
select_t *sp;
void *vp;
{
    rotinfo_t *rp = (rotinfo_t *) vp;    
    extern BOOL applaunch(HWND, char *, char *, char *);
    if (version > VSTVERSION)
        return FALSE;
    return applaunch(hwnd, rp->rot_driver, "", rp->rot_name);
}

BOOL
RadioControl(version, hwnd, sp, vp)
int version;
HWND hwnd;
select_t *sp;
void *vp;
{
    radinfo_t *rp = (radinfo_t *) vp;
    extern BOOL appaunch(HWND, char *, char *, char *);
        
    if (version > VSTVERSION)
        return FALSE;
        
    return applaunch(hwnd, rp->rad_driver, "", rp->rad_name);
}

static BOOL
applaunch(hwnd, exename, argline, model)
HWND hwnd; 
char *exename;
char *argline;
char *model;
{
    PROCESS_INFORMATION  pinfo;
    STARTUPINFO si;
    char *cp;
    char name[80];
    BOOL r;
    int error;
    extern char *StrError(int);

    for (cp = (char *)&si; cp < ((char *)&si + sizeof si);)
        *cp++ = 0;

    sprintf(name, "DEBUG CONSOLE (BELONGS TO %s IN %s)", model, exename);
    si.lpTitle = name;
    si.dwXSize = 200;
    si.dwYSize = 100;
    si.wShowWindow = SW_SHOWMINIMIZED;

    sprintf(tmpbuf,"%s %08x %s", exename, hwnd, argline);
    r = CreateProcess(NULL, tmpbuf, NULL, NULL, FALSE, IDLE_PRIORITY_CLASS,
        NULL, NULL, &si, &pinfo);

    if (r == FALSE) {
        error = GetLastError();
        sprintf(tmpbuf,"Unable to run %s: %s", exename, StrError(error));
        usermsg(NULL, tmpbuf);
        return FALSE;
    }
    return TRUE;
}
