/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>

#include "vstdefs.h"
#include "vsttype.h"
#include "libxtrns.h"
#include "resource.h"       /* Make sure the one in this directory is used */

static char *bufp;
static char vkey[100];

static void
regfatal(hwnd)
HWND hwnd;
{
    fatal(hwnd, "Unable to create or write entry in system registry");
    Sleep(1000);
}



static LRESULT CALLBACK
InstallProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
    POINT *p;
    
    switch(message) {
    case WM_INITDIALOG:
        p = DialogPos(hwnd);
        SendMessage(hwnd, DM_SETDEFID, (WPARAM)IDOK, (LPARAM)0);
        SendDlgItemMessage(hwnd, IDC_INSTALL_MESSAGE, WM_SETTEXT, (WPARAM) 0,
            (LPARAM) bufp);
        SendDlgItemMessage(hwnd, IDC_INSTALL_EDIT, WM_SETTEXT, (WPARAM) 0,
            (LPARAM) tmpbuf);
        SendDlgItemMessage(hwnd, IDC_INSTALL_EDIT, EM_SETSEL, (WPARAM) -1,
            (LPARAM) strlen(tmpbuf)-1);
        SetWindowPos(hwnd, 0, (int)p->x, (int)p->y, 0, 0,
            SWP_NOZORDER | SWP_NOSIZE | SWP_SHOWWINDOW);
        return TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK) {
            GetEditText(hwnd, IDC_INSTALL_EDIT, tmpbuf, sizeof(tmpbuf)-1);
            EnableWindow(GetParent(hwnd), TRUE);
            EndDialog(hwnd, TRUE);
            return TRUE;
        }
        if (LOWORD(wParam) == IDCANCEL) {
            EnableWindow(GetParent(hwnd), TRUE);
            EndDialog(hwnd, FALSE);
            return TRUE;
        }
        break;        

    case WM_CTLCOLORDLG:
    case WM_CTLCOLORSTATIC:
        SetBkColor((HDC)wParam, BColors[6]);
        SetTextColor((HDC) wParam, BColors[15]);
        return (BOOL) hBDrawBrush[6];
        
    case WM_CTLCOLOREDIT:
        SetBkColor((HDC) wParam, BColors[8]);
        SetTextColor((HDC) wParam, BColors[0]);
        return (BOOL) hBDrawBrush[8];
  
    default:
        break;
    }
    return FALSE;
}

BOOL
GetUserInput(hwnd, text, defstr, resultptr, rsize)
HWND hwnd;
char *text, *defstr, *resultptr;
int rsize;
{
    BOOL r;
    extern LRESULT CALLBACK InstallProc();

    bufp = text ? text : "";
    strncpy(tmpbuf, defstr ? defstr : "" , sizeof(tmpbuf));

    r = (BOOL) DialogBox(hInstDLL, MAKEINTRESOURCE(IDD_INSTALL), hwnd, InstallProc);

    if (r && resultptr)
        strncpy(resultptr, tmpbuf, rsize);

    return r;
}

BOOL
Install(int version, HWND hwnd, HWND hkey, registry_t *setp,
        reginfo_t *rgp, int nstp, BOOL installflag)
{
    int result, i;
    BOOL r;
    registry_t *stp;
    extern void RegCleanup(int, HKEY, reginfo_t *);

    if (hkey)
        RegCleanup(version, hkey, rgp);

     if (!installflag) do {
        for (i=0, r = TRUE, stp = setp; r && i< nstp; i++, stp++) {
            if (stp->st_keytype != REG_SZ)
                continue;
			r = TRUE;
			if (stp->st_message)
	            r = GetUserInput(hwnd, stp->st_message, stp->st_default,
    				            stp->st_keyvalue, stp->st_maxkeylen);
            if (r)
                stp->st_keylen = strlen(stp->st_keyvalue);
        }
        if (!r)
            return FALSE;
    } while(!yesno(hwnd, "Is the information you have supplied correct ?"));

    sprintf(vkey,"Software\\%s%s%s%s", rgp->ri_basekey, rgp->ri_subkey1,
        rgp->ri_subkey2, rgp->ri_subkey3);

    result = 0;

    if (RegCreateKeyEx(HKEY_CURRENT_USER, vkey,
            0, 0, REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY|KEY_SET_VALUE,
            NULL, &hkey, &result) != ERROR_SUCCESS)
        regfatal(hwnd);

    for (i=0, stp = setp; i < nstp ; i++, stp++) {
        if (RegSetValueEx(hkey, stp->st_keyname, 0, stp->st_keytype,
            stp->st_keyvalue, stp->st_keylen ) != ERROR_SUCCESS)
            regfatal(hwnd);
        RegFlushKey(hkey);
    }

    RegCloseKey(hkey);
    return TRUE;
}

#ifdef WINNT_31

void
RegCleanup(version, hxkey, rgp)
int version;
HKEY hxkey;
reginfo_t *rgp;
{
    int  i, result;
    char *cp, vkey[200];
    HKEY *keyp, tmpkey = NULL;

    keyp = (hxkey) ? &hxkey : &tmpkey;
    if (hxkey)
        RegCloseKey(hxkey);

    sprintf(vkey,"\\Software\\");

    for(i=10, cp = rgp->ri_basekey; cp && *cp; cp++)
        if (*cp != '\\')
           vkey[i++] = *cp;
    vkey[i] = 0;

    if (RegCreateKeyEx(HKEY_CURRENT_USER, vkey, 0, 0,
        REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY, NULL, keyp, &result) != ERROR_SUCCESS)
        return;

    for(i=0, cp = rgp->ri_subkey1; cp && *cp; cp++)
        if (*cp != '\\')
           vkey[i++] = *cp;
    vkey[i] = 0;

    RegDeleteKey(*keyp, vkey);
    RegFlushKey(*keyp);
    RegCloseKey(*keyp);

    if (RegCreateKeyEx(HKEY_CURRENT_USER, "\\Software",
        0, 0, REG_OPTION_NON_VOLATILE, KEY_CREATE_SUB_KEY, NULL,
        keyp, &result) != ERROR_SUCCESS)
        return;

    for(i=0, cp = rgp->ri_basekey; cp && *cp; cp++)
        if (*cp != '\\')
           vkey[i++] = *cp;
    vkey[i] = 0;

    RegDeleteKey(*keyp, vkey);
    RegFlushKey(*keyp);
    RegCloseKey(*keyp);
}

BOOL
GetRegistryValues(int version, HWND hwnd, registry_t *setp,
                  reginfo_t *rgp, int nsetp, BOOL installflag)
{
    HKEY hkey;
    int result, i;
    registry_t *stp;
    BOOL status;
    extern void Copyright(int, HWND);
    
  restart:
    hkey = NULL;
    result = 0;
    
    sprintf(vkey,"\\Software\\%s%s%s%s", rgp->ri_basekey, rgp->ri_subkey1,
        rgp->ri_subkey2, rgp->ri_subkey3);

    if (RegCreateKeyEx(HKEY_CURRENT_USER, vkey, 0, 0, REG_OPTION_NON_VOLATILE,
        KEY_READ, NULL, &hkey, &result) != ERROR_SUCCESS) {
            usermsg(hwnd, "Unable to open system registry");
            return FALSE;
    }
    if (result != REG_OPENED_EXISTING_KEY && installflag) {
        
        sprintf(tmpbuf,"%s has not been installed for \"%s\". Do you whish to install it ?",
            rgp->ri_msgstring, rgp->ri_username);

        if (yesno(hwnd, tmpbuf)) {
            if (!Install(version, hwnd, hkey, setp, rgp, nsetp, FALSE)) {
                RegCleanup(version, hkey, rgp);
                sprintf(tmpbuf, "%s HAS NOT BEEN INSTALLED!", rgp->ri_msgstring);
                usermsg(hwnd, tmpbuf);
                return FALSE;
            }
            else {
                sprintf(tmpbuf, "%s is now installed for \"%s\".",
                    rgp->ri_msgstring, rgp->ri_username);
                usermsg(hwnd, tmpbuf);
                Copyright(version, hwnd);
                goto restart;
            }
        }
        else {
            RegCleanup(version, hkey, rgp);
            return FALSE;
        }
    }    
    status = TRUE;
    
    for (i=0, stp = setp; i< nsetp; stp++,i++) {
        stp->st_keyvalue[0] = 0;
        stp->st_keylen = stp->st_maxkeylen;

        if (RegQueryValueEx(hkey, stp->st_keyname, 0, &result,
            stp->st_keyvalue, &stp->st_keylen) != ERROR_SUCCESS) {
            if (!installflag) {
                status = FALSE;
                break;
            }
            sprintf(tmpbuf, "%s is not fully installed. Do you wish to re-install it ?",
                rgp->ri_msgstring);

            if (yesno(hwnd, tmpbuf)) {
                if (!Install(version, hwnd, hkey, setp, rgp, nsetp, FALSE)) {
                    RegCleanup(version, hkey, rgp);
                    sprintf(tmpbuf, "%s HAS NOT BEEN FULLY INSTALLED!",
                        rgp->ri_msgstring);                    
                    usermsg(hwnd, tmpbuf);
                    return FALSE;
                }
                else {
                    sprintf(tmpbuf, "%s is now installed for \"%s\".",
                        rgp->ri_msgstring, rgp->ri_username);
                    usermsg(hwnd, tmpbuf);
                    goto restart;
                }
            }
            else
                return FALSE;
        }
        if (result != REG_BINARY)
            stp->st_keyvalue[stp->st_keylen] = 0;   /* Important */
    }
    if (hkey)
        RegCloseKey(hkey);

    return status;
}

#else /* WINNT_31 */

void
RegCleanup(version, hxkey, rgp)
int version;
HKEY hxkey;
reginfo_t *rgp;
{
    int  result;
    char *cp, vkey[200];
    HKEY *keyp, tmpkey = NULL;
    extern char *StrError(int);

    keyp = (hxkey) ? &hxkey : &tmpkey;
    if (hxkey)
        RegCloseKey(hxkey);

    sprintf(vkey,"Software\\%s%s%s", rgp->ri_basekey, rgp->ri_subkey1,
		rgp->ri_subkey2, rgp->ri_subkey3);

	do {
	    if ((result = RegOpenKeyEx(HKEY_CURRENT_USER, vkey, 0,
			KEY_WRITE, keyp)) != ERROR_SUCCESS) {
    	    sprintf(tmpbuf,"Can't open [ %s ]: %s", vkey, StrError(result));
        	usermsg(NULL, tmpbuf);
	        return;
		}
		if (strcmp(vkey,"Software")==0)
			break;
	    if ((result = RegDeleteKey(*keyp, NULL)) != ERROR_SUCCESS) {
	        sprintf(tmpbuf,"Can't delete key [ %s ]: %s", vkey,
				StrError(result));
	        usermsg(NULL, tmpbuf);
	    }
    	RegFlushKey(*keyp);
	    RegCloseKey(*keyp);
	    cp=strrchr(vkey,'\\');

	    if (cp)
			cp = 0;

	} while (cp && strcmp(vkey,"Software"));
}

BOOL
GetRegistryValues(int version, HWND hwnd, registry_t *setp,
                  reginfo_t *rgp, int nsetp, BOOL installflag)
{
    HKEY hkey;
    int result, i;
    registry_t *stp;
    BOOL status;
    extern void Copyright(int, HWND);
    extern char *StrError(int);
    
  restart:
    hkey = NULL;
    result = 0;
    
    sprintf(vkey,"Software\\%s%s%s%s", rgp->ri_basekey, rgp->ri_subkey1,
        rgp->ri_subkey2, rgp->ri_subkey3);

    result = RegOpenKeyEx(HKEY_CURRENT_USER, vkey, 0, KEY_READ, &hkey);

    if (result != ERROR_SUCCESS && installflag) {
        
        sprintf(tmpbuf,"%s has not been installed for \"%s\". Do you whish to install it ?",
            rgp->ri_msgstring, rgp->ri_username);

        if (yesno(hwnd, tmpbuf)) {
            if (!Install(version, hwnd, hkey, setp, rgp, nsetp, FALSE)) {
                RegCleanup(version, hkey, rgp);
                sprintf(tmpbuf, "%s HAS NOT BEEN INSTALLED!", rgp->ri_msgstring);
                usermsg(hwnd, tmpbuf);
                return FALSE;
            }
            else {
                sprintf(tmpbuf, "%s is now installed for \"%s\".",
                    rgp->ri_msgstring, rgp->ri_username);
                usermsg(hwnd, tmpbuf);
                Copyright(version, hwnd);
                goto restart;
            }
        }
        else {
            sprintf(tmpbuf,"Key not found [ %s ]: %s", vkey, StrError(result));
            return FALSE;
        }
    }    
    status = TRUE;
    
    for (i=0, stp = setp; i< nsetp; stp++,i++) {
        stp->st_keyvalue[0] = 0;
        stp->st_keylen = stp->st_maxkeylen;

        if (RegQueryValueEx(hkey, stp->st_keyname, 0, &result,
            stp->st_keyvalue, &stp->st_keylen) != ERROR_SUCCESS) {
            if (!installflag) {
                status = FALSE;
                break;
            }
            sprintf(tmpbuf, "%s is not fully installed. Do you wish to re-install it ?",
                rgp->ri_msgstring);

            if (yesno(hwnd, tmpbuf)) {
                if (!Install(version, hwnd, hkey, setp, rgp, nsetp, FALSE)) {
                    RegCleanup(version, hkey, rgp);
                    sprintf(tmpbuf, "%s HAS NOT BEEN FULLY INSTALLED!",
                        rgp->ri_msgstring);                    
                    usermsg(hwnd, tmpbuf);
                    return FALSE;
                }
                else {
                    sprintf(tmpbuf, "%s is now installed for \"%s\".",
                        rgp->ri_msgstring, rgp->ri_username);
                    usermsg(hwnd, tmpbuf);
                    Copyright(version, hwnd);
                    goto restart;
                }
            }
            else
                return FALSE;
        }
        if (result != REG_BINARY)
            stp->st_keyvalue[stp->st_keylen] = 0;   /* Important */
    }
    if (hkey)
        RegCloseKey(hkey);

    return status;
}

#endif /* WINNT_31 */
