#ifndef _LIBEXTRNS_H
#define _LIBEXTRNS_H
/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <stdio.h>
#include <string.h>
#ifdef _DEBUG_
#include <stdarg.h>
#endif /* _DEBUG_ */

extern void fatal (HWND, char *);
extern BOOL yesno (HWND, char *);
extern void usermsg (HWND, char *);
extern POINT *DialogPos (HWND);
extern BOOL GetEditText(HWND, int, char *, int);
#ifdef _DEBUG_
extern void (*diag)(va_list,...);
extern void DebugFunc(va_list,...);
extern void ConsClose(void);
extern void _vst_assert_(BOOL, char *, char *,  int);
#else  /* _DEBUG_ */
extern void diag(void);
#endif /* _DEBUG_ */

extern char *getline (char *, int, FILE *);
extern BOOL readSatmodeDB (int, HWND, satellite_t **, char *, char *, char *);
extern void stripTrailingSpace (char *);
extern char *stripLeadingSpace (char *);
extern char *saveString (char *);
extern void *safeAlloc (int);
extern void safeFree (void *);
extern int  cistrcmp (char *, char *);
extern double getElement (char *, int, int);
extern satellite_t **readSatDB (int, char *, char *, char *);
extern satellite_t *findSatbyName (satellite_t **, char *);
extern satellite_t *findSatbyID (int);
static int satCompare (const void *, const void *);

extern site_t **readSiteDB (int, char *, char *, unsigned char *, char *);
extern site_t *findSitebyName (char *);
extern site_t *findSitebyID (int);

extern double utctime (void);
extern long day_number (int, int ,int);
extern void daytodate (long, int *, int *, int *, int *);
extern void UTCdateStr (double, char *);
extern char *monthname (int);
extern double internalTime (int, int, int, int, int, int);
extern void timetodhms (double , int *, int *, int *, int *);
extern void calendar (int, int, int *, int *);

extern COLORREF BColors[];
extern HBRUSH hBDrawBrush[];
extern char textbuf[BUFLEN], tmpbuf[BUFLEN], textbuf[BUFLEN];
extern HINSTANCE hInstDLL;

#endif /* _LIBEXTRNS_H */
