/* 
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that the above copyright notice and this and the following
 * paragraph appear unaltered in all copies and in all derived work.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantability and fitness for a particular
 * purpose.
 *
 * sia@bga.com -or- sia@realtime.com
 *
 */

#include <stdio.h>
#include <string.h>

static char buf[48];

/* Not the right ways, but the space savings way... */

#define B1_S	0
static char *B1[] = {
 "SUCCESS",                     /* 0L   */
 "INVALID_FUNCTION",            /* 1L   */
 "FILE_NOT_FOUND",              /* 2L   */
 "PATH_NOT_FOUND",              /* 3L   */
 "TOO_MANY_OPEN_FILES",         /* 4L   */
 "ACCESS_DENIED",               /* 5L   */
 "INVALID_HANDLE",              /* 6L   */
 "ARENA_TRASHED",               /* 7L   */
 "NOT_ENOUGH_MEMORY",           /* 8L   */
 "INVALID_BLOCK",               /* 9L   */
 "BAD_ENVIRONMENT",             /* 10L   */
 "BAD_FORMAT",                  /* 11L   */
 "INVALID_ACCESS",              /* 12L   */
 "INVALID_DATA",                /* 13L   */
 "OUTOFMEMORY",                 /* 14L   */
 "INVALID_DRIVE",               /* 15L   */
 "CURRENT_DIRECTORY",           /* 16L   */
 "NOT_SAME_DEVICE",             /* 17L   */
 "NO_MORE_FILES",               /* 18L   */
 "WRITE_PROTECT",               /* 19L   */
 "BAD_UNIT",                    /* 20L   */
 "NOT_READY",                   /* 21L   */
 "BAD_COMMAND",                 /* 22L   */
 "CRC",                         /* 23L   */
 "BAD_LENGTH",                  /* 24L   */
 "SEEK",                        /* 25L   */
 "NOT_DOS_DISK",                /* 26L   */
 "SECTOR_NOT_FOUND",            /* 27L   */
 "OUT_OF_PAPER",                /* 28L   */
 "WRITE_FAULT",                 /* 29L   */
 "READ_FAULT",                  /* 30L   */
 "GEN_FAILURE",                 /* 31L   */
 "SHARING_VIOLATION",           /* 32L   */
 "LOCK_VIOLATION",              /* 33L   */
 "WRONG_DISK",                  /* 34L   */
  0,
#define T1  36
 "SHARING_BUFFER_EXCEEDED",     /* 36L   */
  0,
#define T2  38
 "HANDLE_EOF",                  /* 38L   */
 "HANDLE_DISK_FULL",            /* 39L   */
  0,0,0,0,0,0,0,0,0,0,
 "NOT_SUPPORTED",               /* 50L   */
 "REM_NOT_LIST",                /* 51L   */
 "DUP_NAME",                    /* 52L   */
 "BAD_NETPATH",                 /* 53L   */
 "NETWORK_BUSY",                /* 54L   */
 "DEV_NOT_EXIST",               /* 55L   */
 "TOO_MANY_CMDS",               /* 56L   */
 "ADAP_HDW_ERR",                /* 57L   */
 "BAD_NET_RESP",                /* 58L   */
 "UNEXP_NET_ERR",               /* 59L   */
 "BAD_REM_ADAP",                /* 60L   */
 "PRINTQ_FULL",                 /* 61L   */
 "NO_SPOOL_SPACE",              /* 62L   */
 "PRINT_CANCELLED",             /* 63L   */
 "NETNAME_DELETED",             /* 64L   */
 "NETWORK_ACCESS_DENIED",       /* 65L   */
 "BAD_DEV_TYPE",                /* 66L   */
 "BAD_NET_NAME",                /* 67L   */
 "TOO_MANY_NAMES",              /* 68L   */
 "TOO_MANY_SESS",               /* 69L   */
 "SHARING_PAUSED",              /* 70L   */
 "REQ_NOT_ACCEP",               /* 71L   */
 "REDIR_PAUSED",                /* 72L   */
#define T3 72
  0,0,0,0,0,0,0,
#define T4 80
 "FILE_EXISTS",                 /* 80L   */
#define T5 82
  0,
 "CANNOT_MAKE",                 /* 82L   */
 "FAIL_I24",                    /* 83L   */
 "OUT_OF_STRUCTURES",           /* 84L   */
 "ALREADY_ASSIGNED",            /* 85L   */
 "INVALID_PASSWORD",            /* 86L   */
 "INVALID_PARAMETER",           /* 87L   */
 "NET_WRITE_FAULT",             /* 88L   */
 "NO_PROC_SLOTS",               /* 89L   */
#define T6 89
  0,0,0,0,0,0,0,0,0,0,
#define T7 100
 "TOO_MANY_SEMAPHORES",         /* 100L   */
 "EXCL_SEM_ALREADY_OWNED",      /* 101L   */
 "SEM_IS_SET",                  /* 102L   */
 "TOO_MANY_SEM_REQUESTS",       /* 103L   */
 "INVALID_AT_INTERRUPT_TIME",   /* 104L   */
 "SEM_OWNER_DIED",              /* 105L   */
 "SEM_USER_LIMIT",              /* 106L   */
 "DISK_CHANGE",                 /* 107L   */
 "DRIVE_LOCKED",                /* 108L   */
 "BROKEN_PIPE",                 /* 109L   */
 "OPEN_FAILED",                 /* 110L   */
 "BUFFER_OVERFLOW",             /* 111L   */
 "DISK_FULL",                   /* 112L   */
 "NO_MORE_SEARCH_HANDLES",      /* 113L   */
 "INVALID_TARGET_HANDLE",       /* 114L   */
#define T8  114
  0,0,
#define T9  117
 "INVALID_CATEGORY",            /* 117L   */
 "INVALID_VERIFY_SWITCH",       /* 118L   */
 "BAD_DRIVER_LEVEL",            /* 119L   */
 "CALL_NOT_IMPLEMENTED",        /* 120L   */
 "SEM_TIMEOUT",                 /* 121L   */
 "INSUFFICIENT_BUFFER",         /* 122L   */
 "INVALID_NAME",                /* 123L   */
 "INVALID_LEVEL",               /* 124L   */
 "NO_VOLUME_LABEL",             /* 125L   */
 "MOD_NOT_FOUND",               /* 126L   */
 "PROC_NOT_FOUND",              /* 127L   */
 "WAIT_NO_CHILDREN",            /* 128L   */
 "CHILD_NOT_COMPLETE",          /* 129L   */
 "DIRECT_ACCESS_HANDLE",        /* 130L   */
 "NEGATIVE_SEEK",               /* 131L   */
 "SEEK_ON_DEVICE",              /* 132L   */
 "IS_JOIN_TARGET",              /* 133L   */
 "IS_JOINED",                   /* 134L   */
 "IS_SUBSTED",                  /* 135L   */
 "NOT_JOINED",                  /* 136L   */
 "NOT_SUBSTED",                 /* 137L   */
 "JOIN_TO_JOIN",                /* 138L   */
 "SUBST_TO_SUBST",              /* 139L   */
 "JOIN_TO_SUBST",               /* 140L   */
 "SUBST_TO_JOIN",               /* 141L   */
 "BUSY_DRIVE",                  /* 142L   */
 "SAME_DRIVE",                  /* 143L   */
 "DIR_NOT_ROOT",                /* 144L   */
 "DIR_NOT_EMPTY",               /* 145L   */
 "IS_SUBST_PATH",               /* 146L   */
 "IS_JOIN_PATH",                /* 147L   */
 "PATH_BUSY",                   /* 148L   */
 "IS_SUBST_TARGET",             /* 149L   */
 "SYSTEM_TRACE",                /* 150L   */
 "INVALID_EVENT_COUNT",         /* 151L   */
 "TOO_MANY_MUXWAITERS",         /* 152L   */
 "INVALID_LIST_FORMAT",         /* 153L   */
 "LABEL_TOO_LONG",              /* 154L   */
 "TOO_MANY_TCBS",               /* 155L   */
 "SIGNAL_REFUSED",              /* 156L   */
 "DISCARDED",                   /* 157L   */
 "NOT_LOCKED",                  /* 158L   */
 "BAD_THREADID_ADDR",           /* 159L   */
 "BAD_ARGUMENTS",               /* 160L   */
 "BAD_PATHNAME",                /* 161L   */
 "SIGNAL_PENDING",              /* 162L   */
 0,
 "MAX_THRDS_REACHED",           /* 164L   */
#define T10 164
  0,0,
 "LOCK_FAILED",                 /* 167L   */
#define T11 167
  0,0,
#define T12 170
 "BUSY",                        /* 170L   */
  0,0,
#define T13 173
 "CANCEL_VIOLATION",            /* 173L   */
 "ATOMIC_LOCKS_NOT_SUPPORTED",  /* 174L   */
#define T14 174
  0,0,0,0,0,
#define T15 180
 "INVALID_SEGMENT_NUMBER",      /* 180L   */
  0,
 "INVALID_ORDINAL",             /* 182L   */
 "ALREADY_EXISTS",              /* 183L   */
  0,0,
#define T16 186
 "INVALID_FLAG_NUMBER",         /* 186L   */
 "SEM_NOT_FOUND",               /* 187L   */
 "INVALID_STARTING_CODESEG",    /* 188L   */
 "INVALID_STACKSEG",            /* 189L   */
 "INVALID_MODULETYPE",          /* 190L   */
 "INVALID_EXE_SIGNATURE",       /* 191L   */
 "EXE_MARKED_INVALID",          /* 192L   */
 "BAD_EXE_FORMAT",              /* 193L   */
 "ITERATED_DATA_EXCEEDS_64k",   /* 194L   */
 "INVALID_MINALLOCSIZE",        /* 195L   */
 "DYNLINK_FROM_INVALID_RING",   /* 196L   */
 "IOPL_NOT_ENABLED",            /* 197L   */
 "INVALID_SEGDPL",              /* 198L   */
 "AUTODATASEG_EXCEEDS_64k",     /* 199L   */
 "RING2SEG_MUST_BE_MOVABLE",    /* 200L   */
 "RELOC_CHAIN_XEEDS_SEGLIM",    /* 201L   */
 "INFLOOP_IN_RELOC_CHAIN",      /* 202L   */
 "ENVVAR_NOT_FOUND",            /* 203L   */
 0,
 "NO_SIGNAL_SENT",              /* 205L   */
 "FILENAME_EXCED_RANGE",        /* 206L   */
 "RING2_STACK_IN_USE",          /* 207L   */
 "META_EXPANSION_TOO_LONG",     /* 208L   */
 "INVALID_SIGNAL_NUMBER",       /* 209L   */
 "THREAD_1_INACTIVE",           /* 210L   */
#define T17 210
  0,
 "LOCKED",                      /* 212L   */
  0,
 "TOO_MANY_MODULES",            /* 214L   */
 "NESTING_NOT_ALLOWED",         /* 215L   */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,
#define T18 230
 "BAD_PIPE",                    /* 230L   */
 "PIPE_BUSY",                   /* 231L   */
 "NO_DATA",                     /* 232L   */
 "PIPE_NOT_CONNECTED",          /* 233L   */
 "MORE_DATA",                   /* 234L   */
  0,0,0,0,0,
#define T19 240
 "VC_DISCONNECTED",             /* 240L   */
  0,0,0,0,0,0,0,0,0,0,0,0,0,
#define T20 254
 "INVALID_EA_NAME",             /* 254L   */
 "EA_LIST_INCONSISTENT",        /* 255L   */
  0,0,0,
#define T21 259
 "NO_MORE_ITEMS",               /* 259L   */
  0,0,0,0,0,0,
#define T22 266
 "CANNOT_COPY",                 /* 266L   */
 "DIRECTORY",                   /* 267L   */
#define T23 267
  0,0,0,0,0,0,0,
#define T24 275
 "EAS_DIDNT_FIT",               /* 275L   */
 "EA_FILE_CORRUPT",             /* 276L   */
 "EA_TABLE_FULL",               /* 277L   */
 "INVALID_EA_HANDLE",           /* 278L   */
#define T24A 278
  0,0,0,
#define T25 282
 "EAS_NOT_SUPPORTED",           /* 282L   */
  0,0,0,0,0,
#define T26 288
 "NOT_OWNER",                   /* 288L   */
  0,0,0,0,0,0,0,0,0,
#define T26A 298
 "TOO_MANY_POSTS",              /* 298L   */
  0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,
#define T27 317
 "MR_MID_NOT_FOUND",            /* 317L   */
#define B1_E	318
};

#define B2_S	487
static char *B2[] = {
 "INVALID_ADDRESS",             /* 487L   */
#define B2_E	488
};

#define T28     534
#define B3_S	534
static char *B3[] = {
 "ARITHMETIC_OVERFLOW",         /* 534L   */
 "PIPE_CONNECTED",              /* 535L   */
 "PIPE_LISTENING",              /* 536L   */
#define B3_E	537
};


#define B4_S	994
static char *B4[] = {
 "EA_ACCESS_DENIED",            /* 994L   */
 "OPERATION_ABORTED",           /* 995L   */
 "IO_INCOMPLETE",               /* 996L   */
 "IO_PENDING",                  /* 997L   */
 "NOACCESS",                    /* 998L   */
 "SWAPERROR",                   /* 999L   */
#define T29 999
  0,				/* 1000L   */
 "STACK_OVERFLOW",              /* 1001L   */
 "INVALID_MESSAGE",             /* 1002L   */
 "CAN_NOT_COMPLETE",            /* 1003L   */
 "INVALID_FLAGS",               /* 1004L   */
 "UNRECOGNIZED_VOLUME",         /* 1005L   */
 "FILE_INVALID",                /* 1006L   */
 "FULLSCREEN_MODE",             /* 1007L   */
 "NO_TOKEN",                    /* 1008L   */
 "BADDB",                       /* 1009L   */
 "BADKEY",                      /* 1010L   */
 "CANTOPEN",                    /* 1011L   */
 "CANTREAD",                    /* 1012L   */
 "CANTWRITE",                   /* 1013L   */
 "REGISTRY_RECOVERED",          /* 1014L   */
 "REGISTRY_CORRUPT",            /* 1015L   */
 "REGISTRY_IO_FAILED",          /* 1016L   */
 "NOT_REGISTRY_FILE",           /* 1017L   */
 "KEY_DELETED",                 /* 1018L   */
 "NO_LOG_SPACE",                /* 1019L   */
 "KEY_HAS_CHILDREN",            /* 1020L   */
 "CHILD_MUST_BE_VOLATILE",      /* 1021L   */
 "NOTIFY_ENUM_DIR",             /* 1022L   */
#define T30 1022
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,
#define T31 1051
 "DEPENDENT_SERVICES_RUNNING"   /* 1051L   */
 "INVALID_SERVICE_CONTROL",     /* 1052L   */
 "SERVICE_REQUEST_TIMEOUT",     /* 1053L   */
 "SERVICE_NO_THREAD",           /* 1054L   */
 "SERVICE_DATABASE_LOCKED",     /* 1055L   */
 "SERVICE_ALREADY_RUNNING",     /* 1056L   */
 "INVALID_SERVICE_ACCOUNT",     /* 1057L   */
 "SERVICE_DISABLED",            /* 1058L   */
 "CIRCULAR_DEPENDENCY",         /* 1059L   */
 "SERVICE_DOES_NOT_EXIST",      /* 1060L   */
 "SERVICE_CANNOT_ACCEPT_CTRL"   /* 1061L   */
 "SERVICE_NOT_ACTIVE",          /* 1062L   */
 "FAILED_SERVICE_CONTROLLER_CONNECT"  /* 1063L   */
 "EXCEPTION_IN_SERVICE",        /* 1064L   */
 "DATABASE_DOES_NOT_EXIST",     /* 1065L   */
 "SERVICE_SPECIFIC_ERROR",      /* 1066L   */
 "PROCESS_ABORTED",             /* 1067L   */
 "SERVICE_DEPENDENCY_FAIL",     /* 1068L   */
 "SERVICE_LOGON_FAILED",        /* 1069L   */
 "SERVICE_START_HANG",          /* 1070L   */
 "INVALID_SERVICE_LOCK",        /* 1071L   */
 "SERVICE_MARKED_FOR_DELETE",   /* 1072L   */
 "SERVICE_EXISTS",              /* 1073L   */
#define T32 1074
 "ALREADY_RUNNING_LKG",         /* 1074L   */
 "SERVICE_DEPENDENCY_DELETED",  /* 1075L   */
 "BOOT_ALREADY_ACCEPTED",       /* 1076L   */
 "SERVICE_NEVER_STARTED",       /* 1077L   */
 "DUPLICATE_SERVICE_NAME",      /* 1078L   */
#define B4_E	1079
};

#define B5_S	1100
static char *B5[] = {
 "END_OF_MEDIA",                /* 1100L   */
 "FILEMARK_DETECTED",           /* 1101L   */
 "BEGINNING_OF_MEDIA",          /* 1102L   */
 "SETMARK_DETECTED",            /* 1103L   */
 "NO_DATA_DETECTED",            /* 1104L   */
 "PARTITION_FAILURE",           /* 1105L   */
 "INVALID_BLOCK_LENGTH",        /* 1106L   */
 "DEVICE_NOT_PARTITIONED",      /* 1107L   */
 "UNABLE_TO_LOCK_MEDIA",        /* 1108L   */
 "UNABLE_TO_UNLOAD_MEDIA",      /* 1109L   */
 "MEDIA_CHANGED",               /* 1110L   */
 "BUS_RESET",                   /* 1111L   */
 "NO_MEDIA_IN_DRIVE",           /* 1112L   */
 "NO_UNICODE_TRANSLATION",      /* 1113L   */
 "DLL_INIT_FAILED",             /* 1114L   */
 "SHUTDOWN_IN_PROGRESS",        /* 1115L   */
 "NO_SHUTDOWN_IN_PROGRESS",     /* 1116L   */
 "IO_DEVICE",                   /* 1117L   */
 "SERIAL_NO_DEVICE",            /* 1118L   */
 "IRQ_BUSY",                    /* 1119L   */
 "MORE_WRITES",                 /* 1120L   */
 "COUNTER_TIMEOUT",             /* 1121L   */
 "FLOPPY_ID_MARK_NOT_FOUND",    /* 1122L   */
 "FLOPPY_WRONG_CYLINDER",       /* 1123L   */
 "FLOPPY_UNKNOWN_ERROR",        /* 1124L   */
#define T33 1124
 "FLOPPY_BAD_REGISTERS",        /* 1125L   */
 "DISK_RECALIBRATE_FAILED",     /* 1126L   */
 "DISK_OPERATION_FAILED",       /* 1127L   */
 "DISK_RESET_FAILED",           /* 1128L   */
 "EOM_OVERFLOW",                /* 1129L   */
 "NOT_ENOUGH_SERVER_MEMORY",    /* 1130L   */
 "POSSIBLE_DEADLOCK",           /* 1131L   */
 "MAPPED_ALIGNMENT",            /* 1132L   */
#define B5_E	1133
};

#define T34 2202
#define B6_S	2202
static char *B6[] = {
 "BAD_USERNAME",                /* 2202L   */
#define B6_E	2203
};


#define B7_S	2250
static char *B7[] = {
 "NOT_CONNECTED",               /* 2250L   */
#define B7_E	2251
};

#define T35 2404
#define B8_S	2401
static char *B8[] = {
 "OPEN_FILES",                  /* 2401L   */
  0,0,
 "DEVICE_IN_USE",               /* 2404L   */
#define B8_E	2405
};

#define T36 1202
#define B9_S	1200
static char *B9[] = {
 "BAD_DEVICE",                  /* 1200L   */
 "CONNECTION_UNAVAIL",          /* 1201L   */
 "DEVICE_ALREADY_REMEMBERED",   /* 1202L   */
 "NO_NET_OR_BAD_PATH",          /* 1203L   */
 "BAD_PROVIDER",                /* 1204L   */
 "CANNOT_OPEN_PROFILE",         /* 1205L   */
 "BAD_PROFILE",                 /* 1206L   */
 "NOT_CONTAINER",               /* 1207L   */
 "EXTENDED_ERROR",              /* 1208L   */
 "INVALID_GROUPNAME",           /* 1209L   */
 "INVALID_COMPUTERNAME",        /* 1210L   */
 "INVALID_EVENTNAME",           /* 1211L   */
 "INVALID_DOMAINNAME",          /* 1212L   */
 "INVALID_SERVICENAME",         /* 1213L   */
 "INVALID_NETNAME",             /* 1214L   */
 "INVALID_SHARENAME",           /* 1215L   */
 "INVALID_PASSWORDNAME",        /* 1216L   */
 "INVALID_MESSAGENAME",         /* 1217L   */
 "INVALID_MESSAGEDEST",         /* 1218L   */
 "SESSION_CREDENTIAL_CONFLICT",  /* 1219L   */
 "REMOTE_SESSION_LIMIT_EXCEEDED",  /* 1220L   */
 "DUP_DOMAINNAME",              /* 1221L   */
 "NO_NETWORK",                  /* 1222L   */
#define B9_E	1223
};
#define T37 1218

#define BA_S	1300
static char *BA[] = {
 "NOT_ALL_ASSIGNED",            /* 1300L   */
 "SOME_NOT_MAPPED",             /* 1301L   */
 "NO_QUOTAS_FOR_ACCOUNT",       /* 1302L   */
 "LOCAL_USER_SESSION_KEY",      /* 1303L   */
 "NULL_LM_PASSWORD",            /* 1304L   */
 "UNKNOWN_REVISION",            /* 1305L   */
 "REVISION_MISMATCH",           /* 1306L   */
 "INVALID_OWNER",               /* 1307L   */
 "INVALID_PRIMARY_GROUP",       /* 1308L   */
 "NO_IMPERSONATION_TOKEN",      /* 1309L   */
 "CANT_DISABLE_MANDATORY",      /* 1310L   */
 "NO_LOGON_SERVERS",            /* 1311L   */
 "NO_SUCH_LOGON_SESSION",       /* 1312L   */
 "NO_SUCH_PRIVILEGE",           /* 1313L   */
 "PRIVILEGE_NOT_HELD",          /* 1314L   */
 "INVALID_ACCOUNT_NAME",        /* 1315L   */
 "USER_EXISTS",                 /* 1316L   */
 "NO_SUCH_USER",                /* 1317L   */
 "GROUP_EXISTS",                /* 1318L   */
 "NO_SUCH_GROUP",               /* 1319L   */
 "MEMBER_IN_GROUP",             /* 1320L   */
 "MEMBER_NOT_IN_GROUP",         /* 1321L   */
 "LAST_ADMIN",                  /* 1322L   */
 "WRONG_PASSWORD",              /* 1323L   */
 "ILL_FORMED_PASSWORD",         /* 1324L   */
 "PASSWORD_RESTRICTION",        /* 1325L   */
 "LOGON_FAILURE",               /* 1326L   */
 "ACCOUNT_RESTRICTION",         /* 1327L   */
 "INVALID_LOGON_HOURS",         /* 1328L   */
 "INVALID_WORKSTATION",         /* 1329L   */
 "PASSWORD_EXPIRED",            /* 1330L   */
 "ACCOUNT_DISABLED",            /* 1331L   */
 "NONE_MAPPED",                 /* 1332L   */
 "TOO_MANY_LUIDS_REQUESTED",    /* 1333L   */
 "LUIDS_EXHAUSTED",             /* 1334L   */
 "INVALID_SUB_AUTHORITY",       /* 1335L   */
 "INVALID_ACL",                 /* 1336L   */
 "INVALID_SID",                 /* 1337L   */
 "INVALID_SECURITY_DESCR",      /* 1338L   */
  0,
#define T38 1340
 "BAD_INHERITANCE_ACL",         /* 1340L   */
 "SERVER_DISABLED",             /* 1341L   */
 "SERVER_NOT_DISABLED",         /* 1342L   */
 "INVALID_ID_AUTHORITY",        /* 1343L   */
 "ALLOTTED_SPACE_EXCEEDED",     /* 1344L   */
 "INVALID_GROUP_ATTRIBUTES",    /* 1345L   */
 "BAD_IMPERSONATION_LEVEL",     /* 1346L   */
 "CANT_OPEN_ANONYMOUS",         /* 1347L   */
 "BAD_VALIDATION_CLASS",        /* 1348L   */
 "BAD_TOKEN_TYPE",              /* 1349L   */
 "NO_SECURITY_ON_OBJECT",       /* 1350L   */
 "CANT_ACCESS_DOMAIN_INFO",     /* 1351L   */
 "INVALID_SERVER_STATE",        /* 1352L   */
 "INVALID_DOMAIN_STATE",        /* 1353L   */
 "INVALID_DOMAIN_ROLE",         /* 1354L   */
 "NO_SUCH_DOMAIN",              /* 1355L   */
 "DOMAIN_EXISTS",               /* 1356L   */
 "DOMAIN_LIMIT_EXCEEDED",       /* 1357L   */
 "INTERNAL_DB_CORRUPTION",      /* 1358L   */
 "INTERNAL_ERROR",              /* 1359L   */
 "GENERIC_NOT_MAPPED",          /* 1360L   */
 "BAD_DESCRIPTOR_FORMAT",       /* 1361L   */
 "NOT_LOGON_PROCESS",           /* 1362L   */
 "LOGON_SESSION_EXISTS",        /* 1363L   */
 "NO_SUCH_PACKAGE",             /* 1364L   */
 "BAD_LOGON_SESSION_STATE",     /* 1365L   */
 "LOGON_SESSION_COLLISION",     /* 1366L   */
 "INVALID_LOGON_TYPE",          /* 1367L   */
 "CANNOT_IMPERSONATE",          /* 1368L   */
 "RXACT_INVALID_STATE",         /* 1369L   */
 "RXACT_COMMIT_FAILURE",        /* 1370L   */
 "SPECIAL_ACCOUNT",             /* 1371L   */
 "SPECIAL_GROUP",               /* 1372L   */
 "SPECIAL_USER",                /* 1373L   */
 "MEMBERS_PRIMARY_GROUP",       /* 1374L   */
 "TOKEN_ALREADY_IN_USE",        /* 1375L   */
 "NO_SUCH_ALIAS",               /* 1376L   */
 "MEMBER_NOT_IN_ALIAS",         /* 1377L   */
 "MEMBER_IN_ALIAS",             /* 1378L   */
 "ALIAS_EXISTS",                /* 1379L   */
 "LOGON_NOT_GRANTED",           /* 1380L   */
 "TOO_MANY_SECRETS",            /* 1381L   */
 "SECRET_TOO_LONG",             /* 1382L   */
 "INTERNAL_DB_ERROR",           /* 1383L   */
 "TOO_MANY_CONTEXT_IDS",        /* 1384L   */
 "LOGON_TYPE_NOT_GRANTED",      /* 1385L   */
 "NT_CROSS_ENCRYPTION_REQUIRED",  /* 1386L   */
 "NO_SUCH_MEMBER",              /* 1387L   */
 "INVALID_MEMBER",              /* 1388L   */
 "TOO_MANY_SIDS",               /* 1389L   */
 "LM_CROSS_ENCRYPTION_REQUIRED",  /* 1390L   */
 "NO_INHERITANCE",              /* 1391L   */
 "FILE_CORRUPT",                /* 1392L   */
 "DISK_CORRUPT",                /* 1393L   */
 "NO_USER_SESSION_KEY",         /* 1394L   */
  0,0,0,0,0,
#define T39 1401
 "INVALID_WINDOW_HANDLE",       /* 1400L   */
 "INVALID_MENU_HANDLE",         /* 1401L   */
 "INVALID_CURSOR_HANDLE",       /* 1402L   */
 "INVALID_ACCEL_HANDLE",        /* 1403L   */
 "INVALID_HOOK_HANDLE",         /* 1404L   */
 "INVALID_DWP_HANDLE",          /* 1405L   */
 "TLW_WITH_WSCHILD",            /* 1406L   */
 "CANNOT_FIND_WND_CLASS",       /* 1407L   */
 "WINDOW_OF_OTHER_THREAD",      /* 1408L   */
 "HOTKEY_ALREADY_REGISTERED",   /* 1409L   */
 "CLASS_ALREADY_EXISTS",        /* 1410L   */
 "CLASS_DOES_NOT_EXIST",        /* 1411L   */
 "CLASS_HAS_WINDOWS",           /* 1412L   */
 "INVALID_INDEX",               /* 1413L   */
 "INVALID_ICON_HANDLE",         /* 1414L   */
 "PRIVATE_DIALOG_INDEX",        /* 1415L   */
 "LISTBOX_ID_NOT_FOUND",        /* 1416L   */
 "NO_WILDCARD_CHARACTERS",      /* 1417L   */
 "CLIPBOARD_NOT_OPEN",          /* 1418L   */
 "HOTKEY_NOT_REGISTERED",       /* 1419L   */
 "WINDOW_NOT_DIALOG",           /* 1420L   */
 "CONTROL_ID_NOT_FOUND",        /* 1421L   */
 "INVALID_COMBOBOX_MESSAGE",    /* 1422L   */
 "WINDOW_NOT_COMBOBOX",         /* 1423L   */
 "INVALID_EDIT_HEIGHT",         /* 1424L   */
 "DC_NOT_FOUND",                /* 1425L   */
 "INVALID_HOOK_FILTER",         /* 1426L   */
 "INVALID_FILTER_PROC",         /* 1427L   */
 "HOOK_NEEDS_HMOD",             /* 1428L   */
 "GLOBAL_ONLY_HOOK",            /* 1429L   */
 "JOURNAL_HOOK_SET",            /* 1430L   */
 "HOOK_NOT_INSTALLED",          /* 1431L   */
 "INVALID_LB_MESSAGE",          /* 1432L   */
 "SETCOUNT_ON_BAD_LB",          /* 1433L   */
 "LB_WITHOUT_TABSTOPS",         /* 1434L   */
 "DESTROY_OBJECT_OF_OTHER_THREAD",  /* 1435L   */
 "CHILD_WINDOW_MENU",           /* 1436L   */
#define T39A 1437
 "NO_SYSTEM_MENU",              /* 1437L   */
 "INVALID_MSGBOX_STYLE",        /* 1438L   */
 "INVALID_SPI_VALUE",           /* 1439L   */
 "SCREEN_ALREADY_LOCKED",       /* 1440L   */
 "HWNDS_HAVE_DIFF_PARENT",      /* 1441L   */
 "NOT_CHILD_WINDOW",            /* 1442L   */
 "INVALID_GW_COMMAND",          /* 1443L   */
 "INVALID_THREAD_ID",           /* 1444L   */
 "NON_MDICHILD_WINDOW",         /* 1445L   */
 "POPUP_ALREADY_ACTIVE",        /* 1446L   */
 "NO_SCROLLBARS",               /* 1447L   */
 "INVALID_SCROLLBAR_RANGE",     /* 1448L   */
 "INVALID_SHOWWIN_COMMAND",     /* 1449L   */
#define BA_E    1450
};

#define T39B   1449

#define BB_S   1500
static char *BB[] = {
 "EVENTLOG_FILE_CORRUPT",       /* 1500L   */
 "EVENTLOG_CANT_START",         /* 1501L   */
 "LOG_FILE_FULL",               /* 1502L   */
 "EVENTLOG_FILE_CHANGED",       /* 1503L   */
#define BB_E	1504
};
#define T40 1502

#define BC_S	1784
static char *BC[] = {
 "INVALID_USER_BUFFER",         /* 1784L   */
 "UNRECOGNIZED_MEDIA",          /* 1785L   */
 "NO_TRUST_LSA_SECRET",         /* 1786L   */
 "NO_TRUST_SAM_ACCOUNT",        /* 1787L   */
 "TRUSTED_DOMAIN_FAILURE",      /* 1788L   */
 "TRUSTED_RELATIONSHIP_FAILURE", /* 1789L   */
 "TRUST_FAILURE",               /* 1790L   */
  0,
#define T41 1792
 "NETLOGON_NOT_STARTED",        /* 1792L   */
 "ACCOUNT_EXPIRED",             /* 1793L   */
 "REDIRECTOR_HAS_OPEN_HANDLES",  /* 1794L   */
 "PRINTER_DRIVER_ALREADY_INSTALLED",  /* 1795L   */
 "UNKNOWN_PORT",                /* 1796L   */
 "UNKNOWN_PRINTER_DRIVER",      /* 1797L   */
 "UNKNOWN_PRINTPROCESSOR",      /* 1798L   */
 "INVALID_SEPARATOR_FILE",      /* 1799L   */
 "INVALID_PRIORITY",            /* 1800L   */
 "INVALID_PRINTER_NAME",        /* 1801L   */
 "PRINTER_ALREADY_EXISTS",      /* 1802L   */
 "INVALID_PRINTER_COMMAND",     /* 1803L   */
 "INVALID_DATATYPE",            /* 1804L   */
 "INVALID_ENVIRONMENT",         /* 1805L   */
  0,
#define T42 1805
#define T43 1816
 "NOLOGON_INTERDOMAIN_TRUST_ACCOUNT",  /* 1807L   */
 "NOLOGON_WORKSTATION_TRUST_ACCOUNT",  /* 1808L   */
 "NOLOGON_SERVER_TRUST_ACCOUNT",  /* 1809L   */
 "DOMAIN_TRUST_INCONSISTENT",   /* 1810L   */
 "SERVER_HAS_OPEN_HANDLES",     /* 1811L   */
 "RESOURCE_DATA_NOT_FOUND",     /* 1812L   */
 "RESOURCE_TYPE_NOT_FOUND",     /* 1813L   */
 "RESOURCE_NAME_NOT_FOUND",     /* 1814L   */
 "RESOURCE_LANG_NOT_FOUND",     /* 1815L   */
 "NOT_ENOUGH_QUOTA",            /* 1816L   */
#define BC_E	1817
};


#define BD_S	1901
static char *BD[] = {
 "INVALID_TIME",                /* 1901L   */
 "INVALID_FORM_NAME",           /* 1902L   */
 "INVALID_FORM_SIZE",           /* 1903L   */
 "ALREADY_WAITING",             /* 1904L   */
 "PRINTER_DELETED",             /* 1905L   */
 "INVALID_PRINTER_STATE",       /* 1906L   */
#define BD_E	1907
};

#define T44 1904
#define T45 6118

#define BE_S	6118
static char *BE[] = {
 "NO_BROWSER_SERVERS_FOUND",    /* 6118L   */
#define BE_E	6119
};

char *
StrError(code)
{
    char *cp = (char *) 0;
    
    if (code >= B1_S && code  < B1_E)
		cp =  B1[ (code-B1_S) ];
    else if (code >= B2_S && code  < B2_E)
		cp =  B2[ (code-B2_S) ];
    else if (code >= B3_S && code  < B3_E)
		cp =  B3[ (code-B3_S) ];
    else if (code >= B4_S && code  < B4_E)
		cp =  B4[ (code-B4_S) ];
    else if (code >= B5_S && code  < B5_E)
		cp =  B5[ (code-B5_S) ];
    else if (code >= B6_S && code  < B6_E)
		cp =  B6[ (code-B6_S) ];
    else if (code >= B7_S && code  < B7_E)
		cp =  B7[ (code-B7_S) ];
    else if (code >= B8_S && code  < B8_E)
		cp =  B8[ (code-B8_S) ];
    else if (code >= B9_S && code  < B9_E)
		cp =  B9[ (code-B9_S) ];
    else if (code >= BA_S && code  < BA_E)
		cp =  BA[ (code-BA_S) ];
    else if (code >= BB_S && code  < BB_E)
		cp =  BB[ (code-BB_S) ];
    else if (code >= BC_S && code  < BC_E)
		cp =  BC[ (code-BC_S) ];
    else if (code >= BD_S && code  < BD_E)
		cp =  BD[ (code-BD_S) ];
    else if (code >= BE_S && code  < BE_E)
	        cp =  BE[ (code-BE_S) ];
    else {
        sprintf(buf,"%d: unknown error code",code);
        cp = buf;
    }
    if (cp == (char *) 0) {
        sprintf(buf,"%d: no error message",code);
        cp = buf;
    }
    return cp;
}

#ifdef _ERRMSG_DEBUG_

static int e[] = {
    T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,
    T17,T18,T19,T20,T21,T22,T23,T24,T24A,T25,T26, T26A,
    T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,
    T39A,T39B,T40,T41,T42,T43,T44,T45, -1
};

#endif /* _ERRMSG_DEBUG */
