

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#include "vsttype.h"
#include "resource.h"
#include "radextrn.h"

extern radparam_t rigInfo;

static radioinfo_t *rip;

static char defrx[16];
static char deftx[16];
static char rxbfo[4];
static char txbfo[4];
static int  radioflags;

#define RAD_RXONLY       0x000001
#define RAD_ARXADJ       0x000002

static button_t BtnTab[3] = {
    RAD_RXONLY,       IDB_SETUP_RXONLY,  0,
    RAD_ARXADJ,       IDB_SETUP_TRANSRX,  0,
    -1,             -1, 0,
};


static void
radio_to_controls() /* store struct values for display in the dialog box */
{
    register radioinfo_t *rp = rip;
    
    sprintf(defrx,"%d", rp->ra_rxcenter);
    sprintf(deftx,"%d", rp->ra_txcenter);
    sprintf(rxbfo,"%s", rp->ra_rxbfo);
    sprintf(txbfo,"%s", rp->ra_txbfo);
    radioflags = rp->ra_flags;
}

static void
controls_to_radio() /* store dialog box values in internal struct(s) */
{
    register radioinfo_t *rp = rip;

    sscanf(defrx,"%d", &rp->ra_rxcenter);
    sscanf(deftx,"%d", &rp->ra_txcenter);
    sscanf(rxbfo,"%s", rp->ra_rxbfo);
    sscanf(txbfo,"%s", rp->ra_txbfo);
    rp->ra_flags = radioflags;
}   


static int
check_radio_buttons(hwnd, wParam)
HWND hwnd;
WPARAM wParam;
{
    int cmd;

    cmd = LOWORD(wParam);
    
    switch (cmd) {
    case IDOK:
    case IDCANCEL:
        return cmd;
    default:
        break;
    }
    
    if (HIWORD(wParam) != BN_CLICKED)
        return -1;

    switch (cmd) {
    case IDB_SETUP_RXONLY:
        radioflags ^= RAD_RXONLY;
        goto bset;

    case IDB_SETUP_TRANSRX:
        radioflags ^= RAD_ARXADJ;
        /* Fall through to bset */
        
    bset:
        setbuttons(hwnd, radioflags, BtnTab);
        break;
        
     default: /* Warning: must return -1 */
        break;
     }
     return -1;
}


static void
setRadControls(hwnd)
HWND hwnd;
{    
    SendDlgItemMessage(hwnd, IDC_SETUP_DEFRX, WM_SETTEXT, (WPARAM) 0,
        (LPARAM) defrx);
    SendDlgItemMessage(hwnd, IDC_SETUP_DEFTX, WM_SETTEXT, (WPARAM) 0,
        (LPARAM) deftx);
    SendDlgItemMessage(hwnd, IDC_SETUP_RXBFO, WM_SETTEXT, (WPARAM) 0,
        (LPARAM) rxbfo);
    SendDlgItemMessage(hwnd, IDC_SETUP_TXBFO, WM_SETTEXT, (WPARAM) 0,
        (LPARAM) txbfo);

    setbuttons(hwnd, radioflags, BtnTab);
}

static void
getRadControls(hwnd)
HWND hwnd;
{
    extern char *GetEditText(HWND, int, char *, int);

    GetEditText(hwnd, IDC_SETUP_DEFRX, defrx, sizeof(defrx));
    GetEditText(hwnd, IDC_SETUP_DEFTX, deftx, sizeof(deftx));
    GetEditText(hwnd, IDC_SETUP_RXBFO, rxbfo, sizeof(rxbfo));
    GetEditText(hwnd, IDC_SETUP_TXBFO, txbfo, sizeof(txbfo));
}

static BOOL CALLBACK
RadioParamsProc(hwnd, message, wParam, lParam)
HWND hwnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
        POINT *p;
        int cmd;
            
        switch(message) {
            case WM_INITDIALOG:
                p = DialogPos(Gwnd, hwnd);
                SendMessage(hwnd, DM_SETDEFID, (WPARAM) IDNONE, (LPARAM)0 );
                SendMessage(GetDlgItem(hwnd, IDOK), WM_SETFOCUS, 0, (LPARAM)0);
                setRadControls(hwnd);
                SetWindowPos(hwnd, 0, (int)p->x, (int)p->y, 0, 0,
                         SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW);
                return TRUE;

            case WM_COMMAND:
                if ((cmd = check_radio_buttons(hwnd, wParam)) >= 0) {
                    switch (cmd) {
                    case IDOK:
                        getRadControls(hwnd);
                        EndDialog(hwnd, (WPARAM)TRUE);
                        return TRUE;

                    case IDCANCEL:
                        EndDialog(hwnd, (WPARAM)FALSE);
                        return TRUE;
                    }
                }
                break;

            default:
                break;
        }
        return FALSE;
}

void
RadioParams()
{
    int r;

    rip = &rigInfo.radio;
    radio_to_controls();
    r = DialogBox(NULL, MAKEINTRESOURCE(IDD_RAD_SETUP), Gwnd, RadioParamsProc);
    if (r)
        controls_to_radio();
}
